/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.tmf.core.request;

import java.util.Queue;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.common.core.NonNullUtils;
import org.eclipse.tracecompass.common.core.log.TraceCompassLog;
import org.eclipse.tracecompass.internal.tmf.core.TmfCoreTracer;
import org.eclipse.tracecompass.internal.tmf.core.component.TmfEventThread;
import org.eclipse.tracecompass.tmf.core.request.ITmfEventRequest;
import org.eclipse.tracecompass.traceeventlogger.LogUtils;

public class TmfRequestExecutor
implements Executor {
    private static final @NonNull Logger LOGGER = TraceCompassLog.getLogger(TmfRequestExecutor.class);
    private static final @NonNull String LOG_CATEGORY = "RequestExecutor";
    private static final long REQUEST_TIME = 100L;
    private static final int FOREGROUND_SLOT = 4;
    private final ExecutorService fExecutor = Executors.newCachedThreadPool();
    private final String fExecutorName;
    private final Queue<TmfEventThread> fForegroundTasks = new ArrayBlockingQueue<TmfEventThread>(10);
    private final Queue<TmfEventThread> fBackgroundTasks = new ArrayBlockingQueue<TmfEventThread>(10);
    private TmfEventThread fActiveTask;
    private Timer fTimer;
    private TimerTask fTimerTask;
    private int fForegroundCycle = 0;

    public TmfRequestExecutor() {
        String canonicalName = (String)NonNullUtils.checkNotNull((Object)this.fExecutor.getClass().getCanonicalName());
        this.fExecutorName = canonicalName.substring(canonicalName.lastIndexOf(46) + 1);
        if (TmfCoreTracer.isComponentTraced()) {
            TmfCoreTracer.trace(String.valueOf(this.fExecutor) + " created");
        }
    }

    public boolean isShutdown() {
        return this.fExecutor.isShutdown();
    }

    public boolean isTerminated() {
        return this.fExecutor.isTerminated();
    }

    public void init() {
        if (this.fTimer != null) {
            return;
        }
        this.fTimerTask = new SchedSwitch();
        this.fTimer = new Timer(true);
        this.fTimer.schedule(this.fTimerTask, 0L, 100L);
    }

    @Override
    public synchronized void execute(Runnable command) {
        if (!(command instanceof TmfEventThread)) {
            LogUtils.traceInstant((Logger)LOGGER, (Level)Level.WARNING, (String)"RequestExecutor:NotATmfEventThread", (Object[])new Object[]{"cmd", command.toString()});
            return;
        }
        Throwable throwable = null;
        Object var3_4 = null;
        try (final LogUtils.FlowScopeLog scope = new LogUtils.FlowScopeLogBuilder(LOGGER, Level.FINE, "RequestExecutor:CreatingThread", new Object[0]).setCategory(LOG_CATEGORY).build();){
            final TmfEventThread thread = (TmfEventThread)command;
            TmfEventThread wrapper = new TmfEventThread(thread){

                @Override
                public void run() {
                    try {
                        Throwable throwable = null;
                        Object var2_3 = null;
                        try (LogUtils.FlowScopeLog log = new LogUtils.FlowScopeLogBuilder(LOGGER, Level.FINE, "RequestExecutor:RunningRequest", new Object[]{"thread", thread.getThread(), "execution type", thread.getExecType()}).setParentScope((LogUtils.IFlowScopeLog)scope).build();){
                            thread.run();
                        }
                        catch (Throwable throwable2) {
                            if (throwable == null) {
                                throwable = throwable2;
                            } else if (throwable != throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                    }
                    finally {
                        TmfRequestExecutor.this.scheduleNext();
                    }
                }
            };
            ITmfEventRequest.ExecutionType priority = thread.getExecType();
            if (priority == ITmfEventRequest.ExecutionType.FOREGROUND) {
                if (!this.fForegroundTasks.offer(wrapper)) {
                    wrapper.cancel();
                }
            } else if (!this.fBackgroundTasks.offer(wrapper)) {
                wrapper.cancel();
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    protected synchronized void scheduleNext() {
        if (!this.isShutdown()) {
            if (this.fActiveTask == null) {
                this.schedule();
            } else if (this.fActiveTask.getExecType() == ITmfEventRequest.ExecutionType.FOREGROUND) {
                if (this.fActiveTask.getThread().isCompleted()) {
                    this.fActiveTask = null;
                    this.schedule();
                } else if (this.hasTasks()) {
                    this.fActiveTask.getThread().suspend();
                    if (!this.fForegroundTasks.offer(this.fActiveTask)) {
                        this.fActiveTask.cancel();
                        this.fActiveTask = null;
                    }
                    this.schedule();
                }
            } else if (this.fActiveTask.getExecType() == ITmfEventRequest.ExecutionType.BACKGROUND) {
                if (this.fActiveTask.getThread().isCompleted()) {
                    this.fActiveTask = null;
                    this.schedule();
                } else if (this.hasTasks()) {
                    this.fActiveTask.getThread().suspend();
                    if (!this.fBackgroundTasks.offer(this.fActiveTask)) {
                        this.fActiveTask.cancel();
                        this.fActiveTask = null;
                    }
                    this.schedule();
                }
            }
        }
    }

    public synchronized void stop() {
        if (this.fTimerTask != null) {
            this.fTimerTask.cancel();
        }
        if (this.fTimer != null) {
            this.fTimer.cancel();
        }
        if (this.fActiveTask != null) {
            this.fActiveTask.cancel();
        }
        while ((this.fActiveTask = this.fForegroundTasks.poll()) != null) {
            this.fActiveTask.cancel();
        }
        while ((this.fActiveTask = this.fBackgroundTasks.poll()) != null) {
            this.fActiveTask.cancel();
        }
        this.fExecutor.shutdown();
        if (TmfCoreTracer.isComponentTraced()) {
            TmfCoreTracer.trace(String.valueOf(this.fExecutor) + " terminated");
        }
    }

    private void schedule() {
        if (!this.fForegroundTasks.isEmpty()) {
            this.scheduleNextForeground();
        } else {
            this.scheduleNextBackground();
        }
    }

    private void scheduleNextForeground() {
        if (this.fForegroundCycle < 4 || this.fBackgroundTasks.isEmpty()) {
            ++this.fForegroundCycle;
            this.fActiveTask = this.fForegroundTasks.poll();
            this.executefActiveTask();
        } else {
            this.fActiveTask = null;
            this.scheduleNextBackground();
        }
    }

    private void scheduleNextBackground() {
        this.fForegroundCycle = 0;
        if (!this.fBackgroundTasks.isEmpty()) {
            this.fActiveTask = this.fBackgroundTasks.poll();
            this.executefActiveTask();
        }
    }

    private void executefActiveTask() {
        if (this.fActiveTask.getThread().isPaused()) {
            this.fActiveTask.getThread().resume();
        } else {
            this.fExecutor.execute(this.fActiveTask);
        }
    }

    private boolean hasTasks() {
        return !this.fForegroundTasks.isEmpty() || !this.fBackgroundTasks.isEmpty();
    }

    public String toString() {
        return "[TmfRequestExecutor(" + this.fExecutorName + ")]";
    }

    private class SchedSwitch
    extends TimerTask {
        SchedSwitch() {
        }

        @Override
        public void run() {
            TmfRequestExecutor.this.scheduleNext();
        }
    }
}

