/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.emf.internal.xpath;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.jxpath.ClassFunctions;
import org.apache.commons.jxpath.Functions;
import org.apache.commons.jxpath.JXPathContext;
import org.apache.commons.jxpath.NodeSet;
import org.apache.commons.jxpath.Pointer;
import org.apache.commons.jxpath.util.TypeUtils;
import org.eclipse.e4.emf.xpath.XPathContext;
import org.eclipse.emf.ecore.EObject;

public final class JXPathContextImpl
implements XPathContext {
    private JXPathContext context;

    JXPathContextImpl(Object contextBean) {
        this.context = JXPathContext.newContext((Object)contextBean);
        this.context.setFunctions((Functions)new ClassFunctions(EMFFunctions.class, "ecore"));
    }

    JXPathContextImpl(XPathContext parentContext, Object contextBean) {
        JXPathContext jContext = ((JXPathContextImpl)parentContext).getJXPathContext();
        this.context = JXPathContext.newContext((JXPathContext)jContext, (Object)contextBean);
    }

    @Override
    public Object getValue(String xpath) {
        return this.context.getValue(xpath);
    }

    @Override
    public <T> T getValue(String xpath, Class<T> requiredType) {
        Object value = this.context.getValue(xpath, requiredType);
        Object typedValue = TypeUtils.convert((Object)value, requiredType);
        return (T)typedValue;
    }

    @Override
    public <T> Iterator<T> iterate(String xpath) {
        return this.context.iterate(xpath);
    }

    private JXPathContext getJXPathContext() {
        return this.context;
    }

    public static class EMFFunctions {
        public static String eClassName(Object o) {
            if (o instanceof Collection) {
                if (!((Collection)o).isEmpty()) {
                    return EMFFunctions.eClassName(((Collection)o).iterator().next());
                }
            } else {
                if (o instanceof EObject) {
                    return ((EObject)o).eClass().getName();
                }
                if (o instanceof NodeSet) {
                    List l = ((NodeSet)o).getValues();
                    if (l.size() > 0 && l.get(0) instanceof EObject) {
                        return EMFFunctions.eClassName(l.get(0));
                    }
                } else if (o instanceof Pointer && ((Pointer)o).getValue() instanceof EObject) {
                    return EMFFunctions.eClassName(((Pointer)o).getValue());
                }
            }
            return null;
        }
    }
}

