/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.sse.ui.internal.filter;

import com.ibm.icu.text.Collator;
import java.util.ArrayList;
import java.util.HashSet;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.ui.IPluginContribution;
import org.eclipse.ui.activities.WorkbenchActivityHelper;
import org.eclipse.wst.sse.ui.internal.filter.OutlineFilterMessages;

public class OutlineFilterDescriptor
implements Comparable,
IPluginContribution {
    private static String PATTERN_FILTER_ID_PREFIX = "_patternFilterId_";
    private static final String EXTENSION_POINT_NAME = "outlineFilters";
    private static final String FILTER_TAG = "filter";
    private static final String PATTERN_ATTRIBUTE = "pattern";
    private static final String ID_ATTRIBUTE = "id";
    private static final String TARGET_ID_ATTRIBUTE = "targetId";
    private static final String CLASS_ATTRIBUTE = "class";
    private static final String NAME_ATTRIBUTE = "name";
    private static final String ENABLED_ATTRIBUTE = "enabled";
    private static final String DESCRIPTION_ATTRIBUTE = "description";
    private static OutlineFilterDescriptor[] fgFilterDescriptors;
    private IConfigurationElement fElement;

    public static OutlineFilterDescriptor[] getFilterDescriptors() {
        if (fgFilterDescriptors == null) {
            IExtensionRegistry registry = Platform.getExtensionRegistry();
            IConfigurationElement[] elements = registry.getConfigurationElementsFor("org.eclipse.wst.sse.ui", EXTENSION_POINT_NAME);
            fgFilterDescriptors = OutlineFilterDescriptor.createFilterDescriptors(elements);
        }
        return fgFilterDescriptors;
    }

    public static OutlineFilterDescriptor[] getFilterDescriptors(String targetId) {
        OutlineFilterDescriptor[] filterDescs = OutlineFilterDescriptor.getFilterDescriptors();
        ArrayList<OutlineFilterDescriptor> result = new ArrayList<OutlineFilterDescriptor>(filterDescs.length);
        int i = 0;
        while (i < filterDescs.length) {
            String tid = filterDescs[i].getTargetId();
            if (!WorkbenchActivityHelper.filterItem((Object)filterDescs[i]) && (tid == null || tid.equals(targetId))) {
                result.add(filterDescs[i]);
            }
            ++i;
        }
        return result.toArray(new OutlineFilterDescriptor[result.size()]);
    }

    private OutlineFilterDescriptor(IConfigurationElement element) {
        this.fElement = element;
        Assert.isTrue((boolean)(this.isPatternFilter() ^ this.isCustomFilter()), (String)"An extension for extension-point org.eclipse.sse.ui.outlineFilters does not specify a correct filter");
        Assert.isNotNull((Object)this.getId(), (String)"An extension for extension-point org.eclipse.sse.ui.outlineFilters does not provide a valid ID");
        Assert.isNotNull((Object)this.getName(), (String)"An extension for extension-point org.eclipse.sse.ui.outlineFilters does not provide a valid name");
    }

    public ViewerFilter createViewerFilter() {
        if (!this.isCustomFilter()) {
            return null;
        }
        final ViewerFilter[] result = new ViewerFilter[1];
        String message = OutlineFilterMessages.FilterDescriptor_filterCreationError_message;
        SafeRunnable code = new SafeRunnable(message){

            public void run() throws Exception {
                result[0] = (ViewerFilter)OutlineFilterDescriptor.this.fElement.createExecutableExtension(OutlineFilterDescriptor.CLASS_ATTRIBUTE);
            }
        };
        SafeRunner.run((ISafeRunnable)code);
        return result[0];
    }

    public String getId() {
        if (this.isPatternFilter()) {
            String targetId = this.getTargetId();
            if (targetId == null) {
                return String.valueOf(PATTERN_FILTER_ID_PREFIX) + this.getPattern();
            }
            return String.valueOf(targetId) + PATTERN_FILTER_ID_PREFIX + this.getPattern();
        }
        return this.fElement.getAttribute(ID_ATTRIBUTE);
    }

    public String getName() {
        String name = this.fElement.getAttribute(NAME_ATTRIBUTE);
        if (name == null && this.isPatternFilter()) {
            name = this.getPattern();
        }
        return name;
    }

    public String getPattern() {
        return this.fElement.getAttribute(PATTERN_ATTRIBUTE);
    }

    public String getTargetId() {
        String tid = this.fElement.getAttribute(TARGET_ID_ATTRIBUTE);
        if (tid != null) {
            return tid;
        }
        return null;
    }

    public String getDescription() {
        String description = this.fElement.getAttribute(DESCRIPTION_ATTRIBUTE);
        if (description == null) {
            description = "";
        }
        return description;
    }

    public boolean isPatternFilter() {
        return this.getPattern() != null;
    }

    public boolean isCustomFilter() {
        return this.fElement.getAttribute(CLASS_ATTRIBUTE) != null;
    }

    public boolean isEnabled() {
        String strVal = this.fElement.getAttribute(ENABLED_ATTRIBUTE);
        return strVal == null || Boolean.valueOf(strVal) != false;
    }

    public int compareTo(Object o) {
        if (o instanceof OutlineFilterDescriptor) {
            return Collator.getInstance().compare(this.getName(), ((OutlineFilterDescriptor)o).getName());
        }
        return Integer.MIN_VALUE;
    }

    private static OutlineFilterDescriptor[] createFilterDescriptors(IConfigurationElement[] elements) {
        ArrayList<OutlineFilterDescriptor> result = new ArrayList<OutlineFilterDescriptor>(5);
        HashSet<String> descIds = new HashSet<String>(5);
        int i = 0;
        while (i < elements.length) {
            final IConfigurationElement element = elements[i];
            if (FILTER_TAG.equals(element.getName())) {
                final OutlineFilterDescriptor[] desc = new OutlineFilterDescriptor[1];
                SafeRunner.run((ISafeRunnable)new SafeRunnable(OutlineFilterMessages.FilterDescriptor_filterDescriptionCreationError_message){

                    public void run() throws Exception {
                        desc[0] = new OutlineFilterDescriptor(element, null);
                    }
                });
                if (desc[0] != null && !descIds.contains(desc[0].getId())) {
                    result.add(desc[0]);
                    descIds.add(desc[0].getId());
                }
            }
            ++i;
        }
        return result.toArray(new OutlineFilterDescriptor[result.size()]);
    }

    public String getLocalId() {
        return this.fElement.getAttribute(ID_ATTRIBUTE);
    }

    public String getPluginId() {
        return this.fElement.getContributor().getName();
    }

    /* synthetic */ OutlineFilterDescriptor(IConfigurationElement iConfigurationElement, OutlineFilterDescriptor outlineFilterDescriptor) {
        this(iConfigurationElement);
    }
}

