/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swtchart.extensions.menu.legend;

import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.ColorDialog;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swtchart.ISeries;
import org.eclipse.swtchart.extensions.core.BaseChart;
import org.eclipse.swtchart.extensions.core.ISeriesSettings;
import org.eclipse.swtchart.extensions.core.ResourceSupport;
import org.eclipse.swtchart.extensions.core.SeriesLabelProvider;
import org.eclipse.swtchart.extensions.core.SeriesListUI;
import org.eclipse.swtchart.extensions.menu.legend.AbstractMenuListener;

public class SetColorAction
extends AbstractMenuListener {
    public SetColorAction(SeriesListUI seriesListUI) {
        super(seriesListUI);
    }

    public void menuAboutToShow(IMenuManager menuManager) {
        menuManager.add((IAction)new Action(){

            public String getText() {
                return "Set Color";
            }

            public String getToolTipText() {
                return "Adjust the color of the selected series.";
            }

            public void run() {
                BaseChart baseChart = SetColorAction.this.getBaseChart();
                SeriesListUI seriesListUI = SetColorAction.this.getSeriesListUI();
                Table table = seriesListUI.getTable();
                List<ISeries<?>> selectedSeries = SetColorAction.this.getSelectedSeries();
                if (selectedSeries.size() > 0) {
                    ColorDialog colorDialog = new ColorDialog(table.getShell());
                    colorDialog.setText("Set Series Color");
                    RGB rgbNew = colorDialog.open();
                    if (rgbNew != null) {
                        for (ISeries<?> series : selectedSeries) {
                            ISeriesSettings seriesSettings = baseChart.getSeriesSettings(series.getId());
                            Color color = ResourceSupport.getColor(rgbNew);
                            SeriesLabelProvider.setColor(seriesSettings, color);
                            baseChart.applySeriesSettings(series, seriesSettings, true);
                        }
                        SetColorAction.this.refresh();
                    }
                }
            }
        });
    }
}

