/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.viewers.breadcrumb;

import org.eclipse.debug.internal.ui.viewers.breadcrumb.BreadcrumbItem;
import org.eclipse.debug.internal.ui.viewers.breadcrumb.BreadcrumbViewer;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

class BreadcrumbItemDetails {
    private final Label fElementImage;
    private final Label fElementText;
    private final Composite fDetailComposite;
    private final BreadcrumbItem fParent;
    private final Composite fTextComposite;
    private final Composite fImageComposite;
    private boolean fTextVisible;
    private boolean fSelected;
    private boolean fHasFocus;

    public BreadcrumbItemDetails(BreadcrumbItem parent, Composite parentContainer) {
        this.fParent = parent;
        this.fTextVisible = true;
        this.fDetailComposite = new Composite(parentContainer, 0);
        this.fDetailComposite.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        GridLayout layout = new GridLayout(2, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.horizontalSpacing = 0;
        this.fDetailComposite.setLayout((Layout)layout);
        this.addElementListener((Control)this.fDetailComposite);
        this.fImageComposite = new Composite(this.fDetailComposite, 0);
        this.fImageComposite.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        layout = new GridLayout(1, false);
        layout.marginHeight = 1;
        layout.marginWidth = 2;
        this.fImageComposite.setLayout((Layout)layout);
        this.fImageComposite.addPaintListener(e -> {
            if (this.fHasFocus && !this.isTextVisible()) {
                e.gc.drawFocus(e.x, e.y, e.width, e.height);
            }
        });
        this.installFocusComposite(this.fImageComposite);
        this.addElementListener((Control)this.fImageComposite);
        this.fElementImage = new Label(this.fImageComposite, 0);
        GridData layoutData = new GridData(1, 0x1000000, false, false);
        this.fElementImage.setLayoutData((Object)layoutData);
        this.addElementListener((Control)this.fElementImage);
        this.fTextComposite = new Composite(this.fDetailComposite, 0);
        this.fTextComposite.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        layout = new GridLayout(1, false);
        layout.marginHeight = 2;
        layout.marginWidth = 2;
        this.fTextComposite.setLayout((Layout)layout);
        this.addElementListener((Control)this.fTextComposite);
        this.fTextComposite.addPaintListener(e -> {
            if (this.fHasFocus && this.isTextVisible()) {
                e.gc.drawFocus(e.x, e.y, e.width, e.height);
            }
        });
        this.installFocusComposite(this.fTextComposite);
        this.addElementListener((Control)this.fTextComposite);
        this.fElementText = new Label(this.fTextComposite, 0);
        layoutData = new GridData(1, 0x1000000, false, false);
        this.fElementText.setLayoutData((Object)layoutData);
        this.addElementListener((Control)this.fElementText);
        this.fTextComposite.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                e.result = BreadcrumbItemDetails.this.fElementText.getText();
            }
        });
        this.fImageComposite.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                e.result = BreadcrumbItemDetails.this.fElementText.getText();
            }
        });
        this.fDetailComposite.setTabList(new Control[]{this.fTextComposite});
        this.fDetailComposite.setData("org.eclipse.e4.ui.css.id", (Object)"DebugBreadcrumbItemDetailComposite");
        this.fTextComposite.setData("org.eclipse.e4.ui.css.id", (Object)"DebugBreadcrumbItemDetailTextComposite");
        this.fImageComposite.setData("org.eclipse.e4.ui.css.id", (Object)"DebugBreadcrumbItemDetailImageComposite");
        this.fElementImage.setData("org.eclipse.e4.ui.css.id", (Object)"DebugBreadcrumbItemDetailImageLabel");
        this.fElementText.setData("org.eclipse.e4.ui.css.id", (Object)"DebugBreadcrumbItemDetailTextLabel");
    }

    public boolean hasFocus() {
        return this.fHasFocus;
    }

    public void setToolTip(String text) {
        if (this.isTextVisible()) {
            this.fElementText.getParent().setToolTipText(text);
            this.fElementText.setToolTipText(text);
            this.fElementImage.setToolTipText(text);
        } else {
            this.fElementText.getParent().setToolTipText(null);
            this.fElementText.setToolTipText(null);
            this.fElementImage.setToolTipText(text);
        }
    }

    public void setImage(Image image) {
        if (image != this.fElementImage.getImage()) {
            this.fElementImage.setImage(image);
        }
    }

    public void setText(String text) {
        if (text == null) {
            text = "";
        }
        if (!text.equals(this.fElementText.getText())) {
            this.fElementText.setText(text);
        }
    }

    public int getWidth() {
        int result = 2;
        if (this.fElementImage.getImage() != null) {
            result += this.fElementImage.computeSize((int)-1, (int)-1).x;
        }
        if (this.fTextVisible && this.fElementText.getText().length() > 0) {
            result += this.fElementText.computeSize((int)-1, (int)-1).x;
        }
        return result;
    }

    public void setTextVisible(boolean enabled) {
        if (this.fTextVisible == enabled) {
            return;
        }
        this.fTextVisible = enabled;
        GridData data = (GridData)this.fTextComposite.getLayoutData();
        data.exclude = !enabled;
        this.fTextComposite.setVisible(enabled);
        if (this.fTextVisible) {
            this.fDetailComposite.setTabList(new Control[]{this.fTextComposite});
        } else {
            this.fDetailComposite.setTabList(new Control[]{this.fImageComposite});
        }
        if (this.fHasFocus) {
            if (this.isTextVisible()) {
                this.fTextComposite.setFocus();
            } else {
                this.fImageComposite.setFocus();
            }
        }
    }

    public boolean isTextVisible() {
        return this.fTextVisible;
    }

    public void setSelected(boolean selected) {
        if (selected == this.fSelected) {
            return;
        }
        this.fSelected = selected;
    }

    public void setFocus(boolean enabled) {
        if (enabled == this.fHasFocus) {
            return;
        }
        this.fHasFocus = enabled;
        if (this.fHasFocus) {
            if (this.isTextVisible()) {
                this.fTextComposite.setFocus();
            } else {
                this.fImageComposite.setFocus();
            }
        }
    }

    private void installFocusComposite(Composite composite) {
        composite.addTraverseListener(e -> {
            if (e.detail == 16 || e.detail == 8) {
                int index = this.fParent.getViewer().getIndexOfItem(this.fParent);
                index = e.detail == 16 ? ++index : --index;
                if (index > 0 && index < this.fParent.getViewer().getItemCount()) {
                    this.fParent.getViewer().selectItem(this.fParent.getViewer().getItem(index));
                }
                e.doit = true;
            }
        });
        composite.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
                BreadcrumbViewer viewer = BreadcrumbItemDetails.this.fParent.getViewer();
                switch (e.keyCode) {
                    case 0x1000003: {
                        if (BreadcrumbItemDetails.this.fSelected) {
                            viewer.doTraverse(false);
                            e.doit = false;
                            break;
                        }
                        viewer.selectItem(BreadcrumbItemDetails.this.fParent);
                        break;
                    }
                    case 0x1000004: {
                        if (BreadcrumbItemDetails.this.fSelected) {
                            viewer.doTraverse(true);
                            e.doit = false;
                            break;
                        }
                        viewer.selectItem(BreadcrumbItemDetails.this.fParent);
                        break;
                    }
                    case 0x1000001: 
                    case 0x1000002: 
                    case 16777259: {
                        if (!BreadcrumbItemDetails.this.fSelected) {
                            viewer.selectItem(BreadcrumbItemDetails.this.fParent);
                        }
                        this.openDropDown();
                        e.doit = false;
                        break;
                    }
                    case 13: {
                        if (!BreadcrumbItemDetails.this.fSelected) {
                            viewer.selectItem(BreadcrumbItemDetails.this.fParent);
                        }
                        viewer.fireOpen();
                        break;
                    }
                    default: {
                        if (e.character != ' ') break;
                        if (!BreadcrumbItemDetails.this.fSelected) {
                            viewer.selectItem(BreadcrumbItemDetails.this.fParent);
                        }
                        this.openDropDown();
                        e.doit = false;
                    }
                }
            }

            private void openDropDown() {
                Shell shell = BreadcrumbItemDetails.this.fParent.getDropDownShell();
                if (shell == null) {
                    BreadcrumbItemDetails.this.fParent.openDropDownMenu();
                    shell = BreadcrumbItemDetails.this.fParent.getDropDownShell();
                }
                shell.setFocus();
            }

            public void keyReleased(KeyEvent e) {
            }
        });
        composite.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
                if (!BreadcrumbItemDetails.this.fHasFocus) {
                    BreadcrumbItemDetails.this.fHasFocus = true;
                }
            }

            public void focusLost(FocusEvent e) {
                if (BreadcrumbItemDetails.this.fHasFocus) {
                    BreadcrumbItemDetails.this.fHasFocus = false;
                }
            }
        });
    }

    private void addElementListener(Control control) {
        control.addMouseListener(new MouseListener(){

            public void mouseDoubleClick(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
                BreadcrumbViewer viewer = BreadcrumbItemDetails.this.fParent.getViewer();
                Shell shell = BreadcrumbItemDetails.this.fParent.getDropDownShell();
                viewer.selectItem(BreadcrumbItemDetails.this.fParent);
                if (shell == null && e.button == 1 && e.stateMask == 0) {
                    BreadcrumbItemDetails.this.fParent.getViewer().fireDoubleClick();
                }
            }

            public void mouseUp(MouseEvent e) {
            }
        });
        control.addMenuDetectListener(e -> {
            BreadcrumbViewer viewer = this.fParent.getViewer();
            viewer.selectItem(this.fParent);
            this.fParent.getViewer().fireMenuDetect(e);
        });
    }
}

