/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.engine;

import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.EventObject;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.equinox.internal.p2.engine.CollectEvent;
import org.eclipse.equinox.internal.p2.engine.Messages;
import org.eclipse.equinox.internal.provisional.p2.core.eventbus.IProvisioningEventBus;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.engine.ProvisioningContext;
import org.eclipse.equinox.p2.metadata.IArtifactKey;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.IRequirement;
import org.eclipse.equinox.p2.metadata.expression.ExpressionUtil;
import org.eclipse.equinox.p2.query.ExpressionMatchQuery;
import org.eclipse.equinox.p2.query.IQuery;
import org.eclipse.equinox.p2.query.IQueryResult;
import org.eclipse.equinox.p2.query.IQueryable;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepository;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRequest;
import org.eclipse.osgi.util.NLS;

public class DownloadManager {
    private ProvisioningContext provContext = null;
    ArrayList<IArtifactRequest> requestsToProcess = new ArrayList();
    private IProvisioningAgent agent = null;
    private static final Comparator<IArtifactRepository> LOCAL_FIRST_COMPARATOR = (arg0, arg1) -> LOCAL_FIRST_URI_COMPARATOR.compare(arg0.getLocation(), arg1.getLocation());
    private static final Pattern LOCAL_URI_PATTERN = Pattern.compile("^(file:|jar:file:)", 2);
    public static final Comparator<URI> LOCAL_FIRST_URI_COMPARATOR = (arg0, arg1) -> {
        boolean isLocal1;
        boolean isLocal0 = LOCAL_URI_PATTERN.matcher(arg0.toString()).find();
        if (isLocal0 != (isLocal1 = LOCAL_URI_PATTERN.matcher(arg1.toString()).find())) {
            return isLocal0 ? -1 : 1;
        }
        return 0;
    };
    private Set<IInstallableUnit> ius;

    public DownloadManager(ProvisioningContext context, IProvisioningAgent agent) {
        this(context, Set.of(), agent);
    }

    public DownloadManager(ProvisioningContext context, Set<IInstallableUnit> ius, IProvisioningAgent agent) {
        this.provContext = context;
        this.ius = ius;
        this.agent = agent;
    }

    public void add(IArtifactRequest toAdd) {
        Assert.isNotNull((Object)toAdd);
        this.requestsToProcess.add(toAdd);
    }

    public void add(IArtifactRequest[] toAdd) {
        Assert.isNotNull((Object)toAdd);
        IArtifactRequest[] iArtifactRequestArray = toAdd;
        int n = toAdd.length;
        int n2 = 0;
        while (n2 < n) {
            IArtifactRequest element = iArtifactRequestArray[n2];
            this.add(element);
            ++n2;
        }
    }

    private void filterUnfetched() {
        Iterator<IArtifactRequest> iterator = this.requestsToProcess.iterator();
        while (iterator.hasNext()) {
            IArtifactRequest request = iterator.next();
            if (request.getResult() == null || !request.getResult().isOK()) continue;
            iterator.remove();
        }
    }

    public IStatus start(IProgressMonitor monitor) {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.download_artifact, (int)1000);
        try {
            IArtifactRepository[] repositories;
            if (this.requestsToProcess.isEmpty()) {
                IStatus iStatus = Status.OK_STATUS;
                return iStatus;
            }
            if (this.provContext == null) {
                this.provContext = new ProvisioningContext(this.agent);
            }
            if ((repositories = this.getArtifactRepositories(subMonitor)).length == 0) {
                Status status = new Status(4, "org.eclipse.equinox.p2.engine", Messages.download_no_repository, (Throwable)new Exception("noArtifactRepositoriesAvailable"));
                return status;
            }
            this.fetch(repositories, (IProgressMonitor)subMonitor.newChild(500));
            IStatus iStatus = this.overallStatus(monitor, repositories);
            return iStatus;
        }
        finally {
            subMonitor.done();
        }
    }

    private IArtifactRepository[] getArtifactRepositories(SubMonitor subMonitor) {
        ExpressionMatchQuery queryArtifactRepositories = new ExpressionMatchQuery(IArtifactRepository.class, ExpressionUtil.TRUE_EXPRESSION, new Object[0]);
        IQueryable<IArtifactRepository> artifactRepositories = this.provContext.getArtifactRepositories((IProgressMonitor)subMonitor.newChild(250));
        IQueryResult queryResult = artifactRepositories.query((IQuery)queryArtifactRepositories, (IProgressMonitor)subMonitor.newChild(250));
        IArtifactRepository[] repositories = (IArtifactRepository[])queryResult.toArray(IArtifactRepository.class);
        Arrays.sort(repositories, LOCAL_FIRST_COMPARATOR);
        return repositories;
    }

    private void fetch(IArtifactRepository[] repositories, IProgressMonitor mon) {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)mon, (int)this.requestsToProcess.size());
        int i = 0;
        while (i < repositories.length && !this.requestsToProcess.isEmpty() && !monitor.isCanceled()) {
            IArtifactRequest[] requests = this.getRequestsForRepository(repositories[i]);
            this.publishDownloadEvent(new CollectEvent(3, repositories[i], this.provContext, requests));
            IStatus dlStatus = repositories[i].getArtifacts(requests, (IProgressMonitor)monitor.newChild(requests.length));
            this.publishDownloadEvent(new CollectEvent(4, repositories[i], this.provContext, requests));
            if (dlStatus.getSeverity() == 8) {
                return;
            }
            this.filterUnfetched();
            monitor.setWorkRemaining(this.requestsToProcess.size());
            ++i;
        }
    }

    private void publishDownloadEvent(CollectEvent event) {
        IProvisioningEventBus bus = (IProvisioningEventBus)this.agent.getService(IProvisioningEventBus.class);
        if (bus != null) {
            bus.publishEvent((EventObject)event);
        }
    }

    private IArtifactRequest[] getRequestsForRepository(IArtifactRepository repository) {
        ArrayList<IArtifactRequest> applicable = new ArrayList<IArtifactRequest>();
        for (IArtifactRequest request : this.requestsToProcess) {
            if (!repository.contains(request.getArtifactKey())) continue;
            applicable.add(request);
        }
        return applicable.toArray(new IArtifactRequest[applicable.size()]);
    }

    private IStatus overallStatus(IProgressMonitor monitor, IArtifactRepository[] repositories) {
        if (monitor != null && monitor.isCanceled()) {
            return Status.CANCEL_STATUS;
        }
        if (this.requestsToProcess.size() == 0) {
            return Status.OK_STATUS;
        }
        MultiStatus result = new MultiStatus("org.eclipse.equinox.p2.engine", 0, null, null);
        for (IArtifactRequest request : this.requestsToProcess) {
            IStatus failed = request.getResult();
            if (failed == null || failed.isOK()) continue;
            IArtifactKey key = request.getArtifactKey();
            IInstallableUnit unit = this.getUnit(key);
            if (unit != null) {
                String dependencyPath = this.computeDependency(unit);
                result.add(Status.error((String)NLS.bind((String)Messages.DownloadManager_cant_find_artifact, (Object[])new Object[]{request.getArtifactKey().toString(), dependencyPath, Arrays.stream(repositories).map(repo -> repo.getLocation()).filter(Objects::nonNull).map(URI::toString).collect(Collectors.joining(System.lineSeparator(), System.lineSeparator(), ""))})));
                continue;
            }
            result.add(failed);
        }
        return result;
    }

    private IInstallableUnit getUnit(IArtifactKey artifactKey) {
        if (this.ius != null) {
            for (IInstallableUnit unit : this.ius) {
                if (!unit.getArtifacts().contains(artifactKey)) continue;
                return unit;
            }
        }
        return null;
    }

    private String computeDependency(IInstallableUnit unit) {
        ArrayList<String> requiredBy = new ArrayList<String>();
        requiredBy.add(DownloadManager.toIdAndVersion(unit));
        if (this.ius != null) {
            for (IInstallableUnit other : this.ius) {
                List<IRequirement> requirement = other.getRequirements().stream().filter(req -> unit.satisfies(req)).toList();
                if (requirement.isEmpty()) continue;
                requiredBy.add(DownloadManager.toIdAndVersion(other));
            }
        }
        return requiredBy.stream().collect(Collectors.joining(", "));
    }

    private static String toIdAndVersion(IInstallableUnit unit) {
        return String.format("%s[%s]", unit.getId(), unit.getVersion());
    }
}

