/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util.hnsw;

import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

final class HnswLock {
    private static final int NUM_LOCKS = 512;
    private final ReentrantReadWriteLock[] locks = new ReentrantReadWriteLock[512];

    HnswLock() {
        for (int i = 0; i < 512; ++i) {
            this.locks[i] = new ReentrantReadWriteLock();
        }
    }

    Lock read(int level, int node) {
        int lockid = HnswLock.hash(level, node) % 512;
        ReentrantReadWriteLock.ReadLock lock = this.locks[lockid].readLock();
        lock.lock();
        return lock;
    }

    Lock write(int level, int node) {
        int lockid = HnswLock.hash(level, node) % 512;
        ReentrantReadWriteLock.WriteLock lock = this.locks[lockid].writeLock();
        lock.lock();
        return lock;
    }

    private static int hash(int v1, int v2) {
        return v1 * 31 + v2;
    }
}

