/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp;

import java.util.Arrays;
import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.ICPPASTCompletionContext;
import org.eclipse.cdt.core.dom.ast.IEnumeration;
import org.eclipse.cdt.core.dom.ast.ITypedef;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTNamedTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPAliasTemplate;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPNamespace;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateTypeParameter;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTBaseDeclSpecifier;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPSemantics;

public class CPPASTNamedTypeSpecifier
extends CPPASTBaseDeclSpecifier
implements ICPPASTNamedTypeSpecifier,
ICPPASTCompletionContext {
    private boolean typename;
    private IASTName name;

    public CPPASTNamedTypeSpecifier() {
    }

    public CPPASTNamedTypeSpecifier(IASTName name) {
        this.setName(name);
    }

    @Override
    public CPPASTNamedTypeSpecifier copy() {
        return this.copy(IASTNode.CopyStyle.withoutLocations);
    }

    @Override
    public CPPASTNamedTypeSpecifier copy(IASTNode.CopyStyle style) {
        CPPASTNamedTypeSpecifier copy = new CPPASTNamedTypeSpecifier(this.name == null ? null : this.name.copy(style));
        copy.typename = this.typename;
        return super.copy(copy, style);
    }

    @Override
    public boolean isTypename() {
        return this.typename;
    }

    @Override
    public void setIsTypename(boolean value) {
        this.assertNotFrozen();
        this.typename = value;
    }

    @Override
    public IASTName getName() {
        return this.name;
    }

    @Override
    public void setName(IASTName name) {
        this.assertNotFrozen();
        this.name = name;
        if (name != null) {
            name.setParent(this);
            name.setPropertyInParent(NAME);
        }
    }

    @Override
    public boolean accept(ASTVisitor action) {
        if (action.shouldVisitDeclSpecifiers) {
            switch (action.visit(this)) {
                case 2: {
                    return false;
                }
                case 1: {
                    return true;
                }
            }
        }
        if (this.name != null && !this.name.accept(action)) {
            return false;
        }
        if (action.shouldVisitDeclSpecifiers) {
            switch (action.leave(this)) {
                case 2: {
                    return false;
                }
                case 1: {
                    return true;
                }
            }
        }
        return true;
    }

    @Override
    public int getRoleForName(IASTName n) {
        if (n == this.name) {
            return 1;
        }
        return 3;
    }

    @Override
    public IBinding[] findBindings(IASTName n, boolean isPrefix, String[] namespaces) {
        IBinding[] bindings = CPPSemantics.findBindingsForContentAssist(n, isPrefix, namespaces);
        int j = 0;
        int i = 0;
        while (i < bindings.length) {
            IBinding binding = bindings[i];
            if (binding instanceof ICPPClassType || binding instanceof IEnumeration || binding instanceof ICPPNamespace || binding instanceof ITypedef || binding instanceof ICPPAliasTemplate || binding instanceof ICPPTemplateTypeParameter) {
                if (i != j) {
                    bindings[j] = binding;
                }
                ++j;
            }
            ++i;
        }
        if (j < bindings.length) {
            return Arrays.copyOfRange(bindings, 0, j);
        }
        return bindings;
    }

    @Override
    public IBinding[] findBindings(IASTName n, boolean isPrefix) {
        return this.findBindings(n, isPrefix, null);
    }
}

