/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.views.memory.renderings;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.debug.internal.ui.DebugUIMessages;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.memory.IPersistableDebugElement;
import org.eclipse.debug.internal.ui.views.memory.renderings.AbstractBaseTableRendering;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.PageBook;

public class FormatTableRenderingDialog
extends TrayDialog {
    private final int[] fColumnSizes = new int[]{1, 2, 4, 8, 16, 32, 64, 128};
    private final int[] fRowSizes = new int[]{1, 2, 4, 8, 16, 32, 64, 128};
    private Combo fColumnControl;
    private Combo fRowControl;
    private int fCurrentColIdx = -1;
    private int fCurrentRowIdx = -1;
    private Control fPreivewPage;
    private PageBook fPreviewPageBook;
    private Button fDefaultButton;
    private Text fDefaultColValue;
    private Text fDefaultRowValue;
    private final AbstractBaseTableRendering fRendering;
    private int fColumnSize;
    private int fRowSize;
    private Label fMsgLabel;
    private boolean fDisableCancel = false;
    private String fMsg;

    public FormatTableRenderingDialog(AbstractBaseTableRendering rendering, Shell parentShell) {
        super(parentShell);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.fRendering = rendering;
        this.fMsg = DebugUIMessages.FormatTableRenderingAction_1;
    }

    protected Control createDialogArea(Composite parent) {
        this.getShell().setText(DebugUIMessages.FormatTableRenderingAction_0);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "org.eclipse.debug.ui.FormatTableRenderingDialog_context");
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        layout.makeColumnsEqualWidth = false;
        composite.setLayout((Layout)layout);
        GridData data = new GridData();
        data.grabExcessHorizontalSpace = true;
        data.grabExcessVerticalSpace = true;
        data.horizontalAlignment = 4;
        data.verticalAlignment = 4;
        composite.setLayoutData((Object)data);
        this.fMsgLabel = new Label(composite, 0);
        this.fMsgLabel.setText(this.fMsg);
        data = new GridData();
        data.grabExcessHorizontalSpace = true;
        data.horizontalAlignment = 1;
        data.horizontalSpan = 3;
        this.fMsgLabel.setLayoutData((Object)data);
        Label rowLabel = new Label(composite, 0);
        rowLabel.setText(DebugUIMessages.FormatTableRenderingAction_2);
        this.fRowControl = new Combo(composite, 8);
        int[] nArray = this.fRowSizes;
        int n = this.fRowSizes.length;
        int n2 = 0;
        while (n2 < n) {
            int size = nArray[n2];
            this.fRowControl.add(String.valueOf(size));
            ++n2;
        }
        this.fRowControl.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (FormatTableRenderingDialog.this.fCurrentRowIdx != FormatTableRenderingDialog.this.fRowControl.getSelectionIndex()) {
                    FormatTableRenderingDialog.this.fCurrentRowIdx = FormatTableRenderingDialog.this.fRowControl.getSelectionIndex();
                    FormatTableRenderingDialog.this.refreshPreviewPage();
                    FormatTableRenderingDialog.this.updateButtons();
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        data = new GridData();
        data.grabExcessHorizontalSpace = false;
        data.horizontalAlignment = 1;
        this.fRowControl.setLayoutData((Object)data);
        Label unit = new Label(composite, 0);
        unit.setText(DebugUIMessages.FormatTableRenderingAction_3);
        Label columnLabel = new Label(composite, 0);
        columnLabel.setText(DebugUIMessages.FormatTableRenderingAction_4);
        this.fColumnControl = new Combo(composite, 8);
        int[] nArray2 = this.fColumnSizes;
        int n3 = this.fColumnSizes.length;
        int n4 = 0;
        while (n4 < n3) {
            int size = nArray2[n4];
            this.fColumnControl.add(String.valueOf(size));
            ++n4;
        }
        this.fColumnControl.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (FormatTableRenderingDialog.this.fCurrentColIdx != FormatTableRenderingDialog.this.fColumnControl.getSelectionIndex()) {
                    FormatTableRenderingDialog.this.fCurrentColIdx = FormatTableRenderingDialog.this.fColumnControl.getSelectionIndex();
                    FormatTableRenderingDialog.this.refreshPreviewPage();
                    FormatTableRenderingDialog.this.updateButtons();
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        data = new GridData();
        data.grabExcessHorizontalSpace = false;
        data.horizontalAlignment = 1;
        this.fColumnControl.setLayoutData((Object)data);
        unit = new Label(composite, 0);
        unit.setText(DebugUIMessages.FormatTableRenderingAction_5);
        this.populateDialog();
        this.fDefaultButton = new Button(composite, 0);
        this.fDefaultButton.setText(DebugUIMessages.FormatTableRenderingAction_8);
        data = new GridData();
        data.grabExcessHorizontalSpace = true;
        data.grabExcessVerticalSpace = true;
        data.horizontalAlignment = 0x1000008;
        data.horizontalSpan = 3;
        this.fDefaultButton.setLayoutData((Object)data);
        this.fDefaultButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                FormatTableRenderingDialog.this.saveDefaults();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        Group group = new Group(composite, 0);
        group.setText(DebugUIMessages.FormatTableRenderingAction_7);
        group.setLayout((Layout)new GridLayout());
        data = new GridData();
        data.grabExcessHorizontalSpace = true;
        data.grabExcessVerticalSpace = true;
        data.horizontalAlignment = 4;
        data.verticalAlignment = 4;
        data.horizontalSpan = 3;
        group.setLayoutData((Object)data);
        this.fPreviewPageBook = new PageBook((Composite)group, 0);
        data = new GridData();
        data.grabExcessHorizontalSpace = true;
        data.grabExcessVerticalSpace = true;
        data.horizontalAlignment = 4;
        data.verticalAlignment = 4;
        this.fPreviewPageBook.setLayoutData((Object)data);
        int rowSize = this.fRowSizes[this.fRowControl.getSelectionIndex()];
        int colSize = this.fColumnSizes[this.fColumnControl.getSelectionIndex()];
        this.fPreivewPage = this.createPreviewPage((Composite)this.fPreviewPageBook, rowSize, colSize);
        this.fPreviewPageBook.showPage(this.fPreivewPage);
        Label defaultRow = new Label(composite, 0);
        defaultRow.setText(DebugUIMessages.FormatTableRenderingDialog_0);
        this.fDefaultRowValue = new Text(composite, 8);
        int defRow = this.getDefaultRowSize();
        this.fDefaultRowValue.setText(String.valueOf(defRow));
        Label def = new Label(composite, 0);
        def.setText(DebugUIMessages.FormatTableRenderingDialog_1);
        data = new GridData();
        data.grabExcessHorizontalSpace = true;
        data.grabExcessVerticalSpace = true;
        data.horizontalAlignment = 1;
        def.setLayoutData((Object)data);
        Label defaultCol = new Label(composite, 0);
        defaultCol.setText(DebugUIMessages.FormatTableRenderingDialog_2);
        this.fDefaultColValue = new Text(composite, 8);
        int defCol = this.getDefaultColumnSize();
        this.fDefaultColValue.setText(String.valueOf(defCol));
        def = new Label(composite, 0);
        def.setText(DebugUIMessages.FormatTableRenderingDialog_3);
        data = new GridData();
        data.grabExcessHorizontalSpace = true;
        data.grabExcessVerticalSpace = true;
        data.horizontalAlignment = 1;
        def.setLayoutData((Object)data);
        Button restoreButton = new Button(composite, 0);
        restoreButton.setText(DebugUIMessages.FormatTableRenderingAction_6);
        restoreButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                FormatTableRenderingDialog.this.restoreDefaults();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        data = new GridData();
        data.grabExcessHorizontalSpace = true;
        data.horizontalAlignment = 0x1000008;
        data.horizontalSpan = 3;
        data.verticalAlignment = 0x1000000;
        restoreButton.setLayoutData((Object)data);
        return composite;
    }

    protected void okPressed() {
        int idx = this.fColumnControl.getSelectionIndex();
        this.fColumnSize = this.fColumnSizes[idx];
        this.fRowSize = this.fRowSizes[this.fRowControl.getSelectionIndex()];
        super.okPressed();
    }

    private void populateDialog() {
        int currentColSize = this.fRendering.getAddressableUnitPerColumn();
        int currentRowSize = this.fRendering.getAddressableUnitPerLine();
        this.setCurrentRowColSizes(currentRowSize, currentColSize);
    }

    private int populateControl(int currentSize, int[] searchArray, Combo control) {
        int idx = 0;
        int i = 0;
        while (i < searchArray.length) {
            if (searchArray[i] == currentSize) {
                idx = i;
                break;
            }
            ++i;
        }
        control.select(idx);
        return idx;
    }

    private Control createPreviewPage(Composite parent, int rowSize, int colSize) {
        if (!this.isValid(rowSize, colSize)) {
            Label label = new Label(parent, 0);
            StringBuilder errorMsg = new StringBuilder();
            errorMsg.append(DebugUIMessages.FormatTableRenderingAction_9);
            errorMsg.append("\n");
            errorMsg.append(DebugUIMessages.FormatTableRenderingAction_11);
            if (colSize > rowSize) {
                errorMsg.append("\n");
                errorMsg.append(DebugUIMessages.FormatTableRenderingAction_13);
            }
            label.setText(errorMsg.toString());
            return label;
        }
        Table table = new Table(parent, 2048);
        table.setHeaderVisible(true);
        int numCol = rowSize / colSize;
        TableColumn addressCol = new TableColumn(table, 0);
        TableColumn[] columns = new TableColumn[numCol];
        int i = 0;
        while (i < columns.length) {
            columns[i] = new TableColumn(table, 0);
            ++i;
        }
        StringBuilder buf = new StringBuilder();
        int j = 0;
        while (j < colSize) {
            buf.append("X");
            ++j;
        }
        int i2 = 0;
        while (i2 < 4) {
            TableItem tableItem = new TableItem(table, 0);
            String[] text = new String[numCol + 1];
            text[0] = DebugUIMessages.FormatTableRenderingAction_15;
            int j2 = 1;
            while (j2 < text.length) {
                text[j2] = buf.toString();
                ++j2;
            }
            tableItem.setText(text);
            ++i2;
        }
        addressCol.pack();
        TableColumn[] tableColumnArray = columns;
        int n = columns.length;
        int n2 = 0;
        while (n2 < n) {
            TableColumn column = tableColumnArray[n2];
            column.pack();
            ++n2;
        }
        return table;
    }

    private boolean isValid(int rowSize, int colSize) {
        if (rowSize % colSize != 0) {
            return false;
        }
        return colSize <= rowSize;
    }

    private void refreshPreviewPage() {
        this.fPreivewPage.dispose();
        int rowSize = this.fRowSizes[this.fRowControl.getSelectionIndex()];
        int colSize = this.fColumnSizes[this.fColumnControl.getSelectionIndex()];
        this.fPreivewPage = this.createPreviewPage((Composite)this.fPreviewPageBook, rowSize, colSize);
        this.fPreviewPageBook.showPage(this.fPreivewPage);
    }

    private void updateButtons() {
        int rowSize = this.fRowSizes[this.fRowControl.getSelectionIndex()];
        int colSize = this.fColumnSizes[this.fColumnControl.getSelectionIndex()];
        Button button = this.getButton(0);
        if (!this.isValid(rowSize, colSize)) {
            button.setEnabled(false);
            this.fDefaultButton.setEnabled(false);
        } else {
            button.setEnabled(true);
            this.fDefaultButton.setEnabled(true);
        }
    }

    private String getRowPrefId(String modelId) {
        String rowPrefId = "org.eclipse.debug.ui.memory.rowSize:" + modelId;
        return rowPrefId;
    }

    private String getColumnPrefId(String modelId) {
        String colPrefId = "org.eclipse.debug.ui.memory.columnSize:" + modelId;
        return colPrefId;
    }

    private int getDefaultRowSize() {
        int size = -1;
        IPersistableDebugElement elmt = (IPersistableDebugElement)this.fRendering.getMemoryBlock().getAdapter(IPersistableDebugElement.class);
        if (elmt != null && elmt.supportsProperty(this.fRendering, "org.eclipse.debug.ui.AbstractTableRendering.rowSize")) {
            return this.getDefaultFromPersistableElement("org.eclipse.debug.ui.AbstractTableRendering.rowSize");
        }
        size = this.getDefaultRowSize(this.fRendering.getMemoryBlock().getModelIdentifier());
        return size;
    }

    private int getDefaultColumnSize() {
        int size = -1;
        IPersistableDebugElement elmt = (IPersistableDebugElement)this.fRendering.getMemoryBlock().getAdapter(IPersistableDebugElement.class);
        if (elmt != null && elmt.supportsProperty(this.fRendering, "org.eclipse.debug.ui.AbstractTableRendering.colSize")) {
            return this.getDefaultFromPersistableElement("org.eclipse.debug.ui.AbstractTableRendering.colSize");
        }
        size = this.getDefaultColumnSize(this.fRendering.getMemoryBlock().getModelIdentifier());
        return size;
    }

    private int getDefaultRowSize(String modelId) {
        int row = DebugUITools.getPreferenceStore().getInt(this.getRowPrefId(modelId));
        if (row == 0) {
            DebugUITools.getPreferenceStore().setValue(this.getRowPrefId(modelId), 16);
            row = DebugUITools.getPreferenceStore().getInt(this.getRowPrefId(modelId));
        }
        return row;
    }

    private int getDefaultColumnSize(String modelId) {
        int col = DebugUITools.getPreferenceStore().getInt(this.getColumnPrefId(modelId));
        if (col == 0) {
            DebugUITools.getPreferenceStore().setValue(this.getColumnPrefId(modelId), 4);
            col = DebugUITools.getPreferenceStore().getInt(this.getColumnPrefId(modelId));
        }
        return col;
    }

    private void saveDefaults() {
        int columnSize = this.fColumnSizes[this.fColumnControl.getSelectionIndex()];
        int rowSize = this.fRowSizes[this.fRowControl.getSelectionIndex()];
        IPersistableDebugElement elmt = (IPersistableDebugElement)this.fRendering.getMemoryBlock().getAdapter(IPersistableDebugElement.class);
        if (elmt != null && elmt.supportsProperty(this.fRendering, "org.eclipse.debug.ui.AbstractTableRendering.rowSize") && elmt.supportsProperty(this.fRendering, "org.eclipse.debug.ui.AbstractTableRendering.colSize")) {
            try {
                elmt.setProperty(this.fRendering, "org.eclipse.debug.ui.AbstractTableRendering.rowSize", rowSize);
                elmt.setProperty(this.fRendering, "org.eclipse.debug.ui.AbstractTableRendering.colSize", columnSize);
            }
            catch (CoreException e) {
                DebugUIPlugin.errorDialog(DebugUIPlugin.getShell(), DebugUIMessages.FormatTableRenderingDialog_4, DebugUIMessages.FormatTableRenderingDialog_5, e);
            }
        } else {
            String modelId = this.fRendering.getMemoryBlock().getModelIdentifier();
            String rowPrefId = this.getRowPrefId(modelId);
            String colPrefId = this.getColumnPrefId(modelId);
            IPreferenceStore prefStore = DebugUITools.getPreferenceStore();
            prefStore.setValue(rowPrefId, rowSize);
            prefStore.setValue(colPrefId, columnSize);
        }
        this.fDefaultColValue.setText(String.valueOf(this.getDefaultColumnSize()));
        this.fDefaultRowValue.setText(String.valueOf(this.getDefaultRowSize()));
        this.fDefaultRowValue.getParent().layout();
    }

    private void restoreDefaults() {
        int defaultRowSize = this.getDefaultRowSize();
        int defaultColSize = this.getDefaultColumnSize();
        this.populateControl(defaultRowSize, this.fRowSizes, this.fRowControl);
        this.populateControl(defaultColSize, this.fColumnSizes, this.fColumnControl);
        this.fCurrentRowIdx = this.fRowControl.getSelectionIndex();
        this.fCurrentColIdx = this.fColumnControl.getSelectionIndex();
        this.refreshPreviewPage();
        this.updateButtons();
    }

    public int getColumnSize() {
        return this.fColumnSize;
    }

    public int getRowSize() {
        return this.fRowSize;
    }

    public void setCurrentRowColSizes(int row, int col) {
        this.fCurrentColIdx = this.populateControl(col, this.fColumnSizes, this.fColumnControl);
        this.fCurrentRowIdx = this.populateControl(row, this.fRowSizes, this.fRowControl);
    }

    protected Control createButtonBar(Composite parent) {
        Control ret = super.createButtonBar(parent);
        if (this.fDisableCancel) {
            this.getButton(1).setEnabled(false);
        }
        this.updateButtons();
        return ret;
    }

    public void openError(String msg) {
        this.fDisableCancel = true;
        this.fMsg = msg;
        this.open();
    }

    private int getDefaultFromPersistableElement(String propertyId) {
        int defaultValue = -1;
        IPersistableDebugElement elmt = (IPersistableDebugElement)this.fRendering.getMemoryBlock().getAdapter(IPersistableDebugElement.class);
        if (elmt != null) {
            try {
                Object valueMB = elmt.getProperty((Object)this, propertyId);
                if (valueMB != null && !(valueMB instanceof Integer)) {
                    IStatus status = DebugUIPlugin.newErrorStatus("Model returned invalid type on " + propertyId, null);
                    DebugUIPlugin.log(status);
                }
                if (valueMB != null) {
                    Integer value = (Integer)valueMB;
                    defaultValue = value;
                }
            }
            catch (CoreException e) {
                DebugUIPlugin.log(e);
            }
        }
        return defaultValue;
    }
}

