/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.analysis.timing.core.tests.statistics;

import java.util.List;
import java.util.function.Function;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.analysis.timing.core.statistics.ITreeStatistics;
import org.eclipse.tracecompass.analysis.timing.core.statistics.TreeStatistics;
import org.eclipse.tracecompass.analysis.timing.core.tests.statistics.StatObjectStub;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TreeStatisticsTest {
    private TreeStatistics<@NonNull StatObjectStub> treeStatistics;

    @Before
    public void setUp() {
        this.treeStatistics = new TreeStatistics("Root");
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Test
    public void testAddChild() {
        @NonNull TreeStatistics childStatistics = new TreeStatistics("Child1");
        boolean result = this.treeStatistics.addChild((ITreeStatistics)childStatistics);
        Assert.assertTrue((boolean)result);
        Assert.assertEquals((long)1L, (long)this.treeStatistics.getChildren().size());
        Assert.assertEquals((Object)"Child1", (Object)((ITreeStatistics)this.treeStatistics.getChildren().get(0)).getName());
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Test
    public void testGetChildren() {
        @NonNull TreeStatistics childStatistics1 = new TreeStatistics("Child1");
        @NonNull TreeStatistics childStatistics2 = new TreeStatistics("Child2");
        this.treeStatistics.addChild((ITreeStatistics)childStatistics1);
        this.treeStatistics.addChild((ITreeStatistics)childStatistics2);
        @NonNull List children = this.treeStatistics.getChildren();
        Assert.assertEquals((long)2L, (long)children.size());
        Assert.assertEquals((Object)"Child1", (Object)((ITreeStatistics)children.get(0)).getName());
        Assert.assertEquals((Object)"Child2", (Object)((ITreeStatistics)children.get(1)).getName());
    }

    @Test
    public void testGetName() {
        Assert.assertEquals((Object)"Root", (Object)this.treeStatistics.getName());
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Test
    public void testConstructorWithMapper() {
        @NonNull Function<@NonNull StatObjectStub, @Nullable Number> valueMapper = StatObjectStub::getValue;
        @NonNull TreeStatistics mappedStatistics = new TreeStatistics(valueMapper, "Mapped");
        Assert.assertEquals((Object)"Mapped", (Object)mappedStatistics.getName());
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Test
    public void testTwoLevelsOfChildren() {
        @NonNull TreeStatistics childStatistics1 = new TreeStatistics("Child1");
        @NonNull TreeStatistics childStatistics2 = new TreeStatistics("Child2");
        @NonNull TreeStatistics grandChildStatistics1 = new TreeStatistics("GrandChild1");
        @NonNull TreeStatistics grandChildStatistics2 = new TreeStatistics("GrandChild2");
        this.treeStatistics.addChild((ITreeStatistics)childStatistics1);
        this.treeStatistics.addChild((ITreeStatistics)childStatistics2);
        childStatistics1.addChild((ITreeStatistics)grandChildStatistics1);
        childStatistics1.addChild((ITreeStatistics)grandChildStatistics2);
        @NonNull @NonNull @NonNull List rootChildren = this.treeStatistics.getChildren();
        Assert.assertEquals((long)2L, (long)rootChildren.size());
        Assert.assertEquals((Object)"Child1", (Object)((ITreeStatistics)rootChildren.get(0)).getName());
        Assert.assertEquals((Object)"Child2", (Object)((ITreeStatistics)rootChildren.get(1)).getName());
        @NonNull @NonNull @NonNull List child1Children = ((ITreeStatistics)rootChildren.get(0)).getChildren();
        Assert.assertEquals((long)2L, (long)child1Children.size());
        Assert.assertEquals((Object)"GrandChild1", (Object)((ITreeStatistics)child1Children.get(0)).getName());
        Assert.assertEquals((Object)"GrandChild2", (Object)((ITreeStatistics)child1Children.get(1)).getName());
    }
}

