/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.common.core.tests.log;

import java.lang.management.ManagementFactory;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.JMX;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.common.core.log.TraceCompassMonitorManager;
import org.eclipse.tracecompass.internal.common.core.log.ITraceCompassMonitor;
import org.junit.Assert;
import org.junit.Test;

public class MonitorTest {
    private static final String SUM = "sum";
    private static final String COUNT = "count";
    private static final String MEAN = "mean";
    private static final String MIN = "min";
    private static final String MAX = "max";
    private static final String JMX_PACKAGE = "javax.management";
    private static final String JMX_MESSAGE = "javax.management log level";

    @Test
    public void testClimbing() throws MalformedObjectNameException {
        long[] inputVector = new long[]{1L, 2L, 3L, 4L, 5L};
        String name = "testClimbing";
        ITraceCompassMonitor fixture = MonitorTest.populateVector(inputVector, name);
        Assert.assertNotNull((Object)fixture);
        Assert.assertEquals((String)MEAN, (double)3.0, (double)fixture.getMeanTime(), (double)1.0E-5);
        Assert.assertEquals((String)COUNT, (long)inputVector.length, (long)fixture.getCount());
        Assert.assertEquals((String)SUM, (long)15L, (long)fixture.getTotalTime());
        Assert.assertEquals((String)MIN, (long)1L, (long)fixture.getMinTime());
        Assert.assertEquals((String)MAX, (long)5L, (long)fixture.getMaxTime());
    }

    @Test
    public void testDescending() throws MalformedObjectNameException {
        long[] inputVector = new long[]{5L, 4L, 3L, 2L, 1L};
        String name = "testDescending";
        ITraceCompassMonitor fixture = MonitorTest.populateVector(inputVector, name);
        Assert.assertNotNull((Object)fixture);
        Assert.assertEquals((String)MEAN, (double)3.0, (double)fixture.getMeanTime(), (double)1.0E-5);
        Assert.assertEquals((String)COUNT, (long)inputVector.length, (long)fixture.getCount());
        Assert.assertEquals((String)SUM, (long)15L, (long)fixture.getTotalTime());
        Assert.assertEquals((String)MIN, (long)1L, (long)fixture.getMinTime());
        Assert.assertEquals((String)MAX, (long)5L, (long)fixture.getMaxTime());
    }

    @Test
    public void testSame() throws MalformedObjectNameException {
        long[] inputVector = new long[]{3L, 3L, 3L, 3L, 3L};
        String name = "testSame";
        ITraceCompassMonitor fixture = MonitorTest.populateVector(inputVector, name);
        Assert.assertNotNull((Object)fixture);
        Assert.assertEquals((String)MEAN, (double)3.0, (double)fixture.getMeanTime(), (double)1.0E-5);
        Assert.assertEquals((String)COUNT, (long)inputVector.length, (long)fixture.getCount());
        Assert.assertEquals((String)SUM, (long)15L, (long)fixture.getTotalTime());
        Assert.assertEquals((String)MIN, (long)3L, (long)fixture.getMinTime());
        Assert.assertEquals((String)MAX, (long)3L, (long)fixture.getMaxTime());
    }

    @Test
    public void testJmx() {
        long input = 0L;
        String name = "testJmx";
        TraceCompassMonitorManager.getInstance().update(name, input);
        Level expected = Level.FINE;
        @Nullable Level actual = Logger.getLogger(JMX_PACKAGE).getLevel();
        Assert.assertNotNull((String)"javax.management log level unexpectedly null", (Object)actual);
        Assert.assertEquals((String)JMX_MESSAGE, (Object)expected, (Object)actual);
    }

    private static ITraceCompassMonitor populateVector(long[] inputVector, String name) throws MalformedObjectNameException {
        Assert.assertNotNull((Object)name);
        int i = 0;
        while (i < inputVector.length) {
            TraceCompassMonitorManager.getInstance().update(name, inputVector[i]);
            ++i;
        }
        ITraceCompassMonitor fixture = MonitorTest.getBean(name);
        Assert.assertNotNull((Object)fixture);
        Assert.assertEquals((String)"Contains name", (Object)name, (Object)fixture.getObservedElementName());
        return fixture;
    }

    private static ITraceCompassMonitor getBean(String label) throws MalformedObjectNameException {
        MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
        ObjectName mbeanName = new ObjectName("org.eclipse.tracecompass.common.core.log:type=TraceCompassMonitoring,name=" + label);
        @Nullable ITraceCompassMonitor fixture = JMX.newMXBeanProxy(mbs, mbeanName, ITraceCompassMonitor.class, true);
        Assert.assertNotNull((Object)fixture);
        return fixture;
    }
}

