/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.ui.views.timechart;

import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Vector;
import java.util.regex.Pattern;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.common.core.NonNullUtils;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.ui.views.timechart.TimeChartEvent;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.ITimeEvent;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.ITimeGraphEntry;

public class TimeChartAnalysisEntry
implements ITimeGraphEntry {
    private final ITmfTrace fTrace;
    private final Vector<TimeChartEvent> fTraceEvents;
    private int fPower = 0;
    private long fReferenceTime = -1L;
    private long fStartTime = -1L;
    private long fStopTime = -1L;
    private long fLastRank = -1L;

    TimeChartAnalysisEntry(ITmfTrace trace, int modelSize) {
        this.fTrace = trace;
        this.fTraceEvents = new Vector(modelSize);
    }

    public List<@NonNull ITimeGraphEntry> getChildren() {
        return null;
    }

    @Override
    public ITimeGraphEntry getParent() {
        return null;
    }

    @Override
    public boolean hasChildren() {
        return false;
    }

    @Override
    public String getName() {
        return this.fTrace.getName();
    }

    @Override
    public long getStartTime() {
        return this.fStartTime;
    }

    @Override
    public long getEndTime() {
        return this.fStopTime;
    }

    @Override
    public boolean hasTimeEvents() {
        return true;
    }

    public Iterator<@NonNull ITimeEvent> getTimeEventsIterator() {
        return new EntryIterator(0L, Long.MAX_VALUE, 0L);
    }

    public Iterator<@NonNull ITimeEvent> getTimeEventsIterator(long startTime, long stopTime, long maxDuration) {
        return new EntryIterator(startTime, stopTime, maxDuration);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTraceEvent(ITimeEvent timeEvent) {
        long time = timeEvent.getTime();
        Vector<TimeChartEvent> vector = this.fTraceEvents;
        synchronized (vector) {
            long index;
            long l = index = this.fReferenceTime == -1L ? 0L : time - this.fReferenceTime >> this.fPower;
            if (index < 0L) {
                if ((long)(this.fTraceEvents.capacity() - this.fTraceEvents.size()) < -index) {
                    powershift = -index + (long)this.fTraceEvents.size() <= (long)(2 * this.fTraceEvents.capacity()) ? 1 : (int)Math.ceil(Math.log((double)(-index + (long)this.fTraceEvents.size()) / (double)this.fTraceEvents.capacity()) / Math.log(2.0));
                    this.merge(powershift);
                    index = (int)(time - this.fReferenceTime >> this.fPower);
                }
                this.shift((int)(-index));
                index = 0L;
                this.fTraceEvents.set(0, (TimeChartEvent)timeEvent);
            } else if (index < (long)this.fTraceEvents.capacity()) {
                if (index >= (long)this.fTraceEvents.size()) {
                    this.fTraceEvents.setSize((int)index + 1);
                }
            } else {
                powershift = index < (long)(2 * this.fTraceEvents.capacity()) ? 1 : (int)Math.ceil(Math.log((double)(index + 1L) / (double)this.fTraceEvents.capacity()) / Math.log(2.0));
                this.merge(powershift);
                index = (int)(time - this.fReferenceTime >> this.fPower);
                this.fTraceEvents.setSize((int)index + 1);
            }
            TimeChartEvent event = this.fTraceEvents.get((int)index);
            if (event == null) {
                this.fTraceEvents.set((int)index, (TimeChartEvent)timeEvent);
            } else if (event.getItemizedEntry() == null) {
                event.merge((TimeChartEvent)timeEvent);
            } else {
                event.mergeDecorations((TimeChartEvent)timeEvent);
                event.getItemizedEntry().addTraceEvent(timeEvent);
            }
            if (this.fReferenceTime == -1L || time < this.fReferenceTime) {
                this.fReferenceTime = time >> this.fPower << this.fPower;
            }
            if (this.fStartTime == -1L || time < this.fStartTime) {
                this.fStartTime = time;
            }
            if (this.fStopTime == -1L || time > this.fStopTime) {
                this.fStopTime = time;
            }
        }
    }

    private void merge(int powershift) {
        this.fPower += powershift;
        this.fReferenceTime = this.fReferenceTime >> this.fPower << this.fPower;
        int index = 0;
        int i = 0;
        while (i < this.fTraceEvents.size()) {
            TimeChartEvent event = this.fTraceEvents.get(i);
            if (event != null) {
                index = (int)(event.getTime() - this.fReferenceTime >> this.fPower);
                TimeChartEvent mergedEvent = this.fTraceEvents.get(index);
                if (mergedEvent == null) {
                    this.fTraceEvents.set(index, event);
                } else {
                    mergedEvent.merge(event);
                }
                if (i != index) {
                    this.fTraceEvents.set(i, null);
                }
            }
            ++i;
        }
        this.fTraceEvents.setSize(index + 1);
    }

    private void shift(int indexshift) {
        int oldSize = this.fTraceEvents.size();
        this.fTraceEvents.setSize(oldSize + indexshift);
        int i = oldSize - 1;
        while (i >= 0) {
            this.fTraceEvents.set(i + indexshift, this.fTraceEvents.get(i));
            --i;
        }
        i = 0;
        while (i < indexshift) {
            this.fTraceEvents.set(i, null);
            ++i;
        }
    }

    public ITmfTrace getTrace() {
        return this.fTrace;
    }

    public void setLastRank(long rank) {
        this.fLastRank = rank;
    }

    public long getLastRank() {
        return this.fLastRank;
    }

    @Override
    public boolean matches(@NonNull Pattern pattern) {
        return this.getName() != null ? pattern.matcher(this.getName()).find() : false;
    }

    private class EntryIterator
    implements Iterator<ITimeEvent> {
        private final long fIteratorStartTime;
        private final long fIteratorStopTime;
        private final long fIteratorMaxDuration;
        private long lastTime = -1L;
        private TimeChartEvent next = null;
        private Iterator<ITimeEvent> nestedIterator = null;

        public EntryIterator(long startTime, long stopTime, long maxDuration) {
            this.fIteratorStartTime = startTime;
            this.fIteratorStopTime = stopTime;
            this.fIteratorMaxDuration = maxDuration;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public boolean hasNext() {
            Vector<TimeChartEvent> vector = TimeChartAnalysisEntry.this.fTraceEvents;
            synchronized (vector) {
                TimeChartEvent event;
                int index;
                if (this.next != null) {
                    return true;
                }
                if (this.nestedIterator != null) {
                    if (this.nestedIterator.hasNext()) {
                        return true;
                    }
                    this.nestedIterator = null;
                }
                long time = this.lastTime == -1L ? TimeChartAnalysisEntry.this.fStartTime : this.lastTime;
                int n = index = TimeChartAnalysisEntry.this.fReferenceTime == -1L ? 0 : (int)(time - TimeChartAnalysisEntry.this.fReferenceTime >> TimeChartAnalysisEntry.this.fPower);
                do {
                    if (index < TimeChartAnalysisEntry.this.fTraceEvents.size()) continue;
                    return false;
                } while ((event = TimeChartAnalysisEntry.this.fTraceEvents.get(index++)) == null || this.lastTime != -1L && event.getTime() <= time || event.getTime() + event.getDuration() < this.fIteratorStartTime || event.getTime() > this.fIteratorStopTime);
                if (event.getItemizedEntry() != null && event.getDuration() > this.fIteratorMaxDuration) {
                    this.nestedIterator = event.getItemizedEntry().getTimeEventsIterator(this.fIteratorStartTime, this.fIteratorStopTime, this.fIteratorMaxDuration);
                    return this.nestedIterator.hasNext();
                }
                this.lastTime = event.getTime() + event.getDuration();
                this.next = event;
                return true;
            }
        }

        @Override
        public TimeChartEvent next() {
            Vector<TimeChartEvent> vector = TimeChartAnalysisEntry.this.fTraceEvents;
            synchronized (vector) {
                if (this.nestedIterator != null) {
                    TimeChartEvent event = (TimeChartEvent)this.nestedIterator.next();
                    this.lastTime = event.getTime() + event.getDuration();
                    return event;
                }
                if (this.hasNext()) {
                    TimeChartEvent event = (TimeChartEvent)NonNullUtils.checkNotNull((Object)this.next);
                    this.next = null;
                    return event;
                }
                throw new NoSuchElementException();
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

