/*
 * Copyright (c) 2015 Goldman Sachs.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * and Eclipse Distribution License v. 1.0 which accompany this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 */

package org.eclipse.collections.impl.map.immutable.primitive;

import java.io.IOException;
import java.io.Serializable;

import org.eclipse.collections.api.CharIterable;
import org.eclipse.collections.api.FloatIterable;
import org.eclipse.collections.api.LazyCharIterable;
import org.eclipse.collections.api.LazyFloatIterable;
import org.eclipse.collections.api.RichIterable;
import org.eclipse.collections.api.bag.primitive.MutableCharBag;
import org.eclipse.collections.api.block.function.primitive.CharToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.ObjectCharToObjectFunction;
import org.eclipse.collections.api.block.predicate.primitive.CharPredicate;
import org.eclipse.collections.api.block.predicate.primitive.FloatCharPredicate;
import org.eclipse.collections.api.block.procedure.primitive.CharProcedure;
import org.eclipse.collections.api.block.procedure.primitive.FloatCharProcedure;
import org.eclipse.collections.api.block.procedure.primitive.FloatProcedure;
import org.eclipse.collections.api.collection.ImmutableCollection;
import org.eclipse.collections.api.collection.primitive.ImmutableCharCollection;
import org.eclipse.collections.api.collection.primitive.MutableCharCollection;
import org.eclipse.collections.api.iterator.CharIterator;
import org.eclipse.collections.api.list.primitive.MutableCharList;
import org.eclipse.collections.api.map.primitive.FloatCharMap;
import org.eclipse.collections.api.map.primitive.ImmutableFloatCharMap;
import org.eclipse.collections.api.set.primitive.MutableFloatSet;
import org.eclipse.collections.api.set.primitive.MutableCharSet;
import org.eclipse.collections.api.tuple.primitive.FloatCharPair;
import org.eclipse.collections.impl.bag.mutable.primitive.CharHashBag;
import org.eclipse.collections.impl.collection.mutable.primitive.UnmodifiableCharCollection;
import org.eclipse.collections.impl.factory.Lists;
import org.eclipse.collections.impl.factory.primitive.FloatCharMaps;
import org.eclipse.collections.impl.factory.primitive.FloatLists;
import org.eclipse.collections.impl.iterator.UnmodifiableCharIterator;
import org.eclipse.collections.impl.lazy.primitive.LazyCharIterableAdapter;
import org.eclipse.collections.impl.list.mutable.primitive.CharArrayList;
import org.eclipse.collections.impl.map.mutable.primitive.FloatCharHashMap;
import org.eclipse.collections.impl.set.mutable.primitive.CharHashSet;
import org.eclipse.collections.impl.set.mutable.primitive.FloatHashSet;
import org.eclipse.collections.impl.set.mutable.primitive.UnmodifiableFloatSet;
import org.eclipse.collections.impl.tuple.primitive.PrimitiveTuples;

/**
 * ImmutableFloatCharSingletonMap is an optimization for {@link ImmutableFloatCharMap} of size 1.
 * This file was automatically generated from template file immutablePrimitivePrimitiveSingletonMap.stg.
 * @since 4.0.
 */
final class ImmutableFloatCharSingletonMap implements ImmutableFloatCharMap, Serializable
{
    private static final long serialVersionUID = 1L;
    private static final char EMPTY_VALUE = '\0';
    private final float key1;
    private final char value1;

    ImmutableFloatCharSingletonMap(float key1, char value1)
    {
        this.key1 = key1;
        this.value1 = value1;
    }

    public char get(float key)
    {
        return this.getIfAbsent(key, EMPTY_VALUE);
    }

    public char getIfAbsent(float key, char ifAbsent)
    {
        return Float.compare(this.key1, key) == 0 ? this.value1 : ifAbsent;
    }

    public char getOrThrow(float key)
    {
        if (Float.compare(this.key1, key) == 0)
        {
            return this.value1;
        }
        throw new IllegalStateException("Key " + key + " not present.");
    }

    public boolean containsKey(float key)
    {
        return Float.compare(this.key1, key) == 0;
    }

    public boolean containsValue(char value)
    {
        return this.value1 == value;
    }

    public void forEachValue(CharProcedure procedure)
    {
        procedure.value(this.value1);
    }

    public void forEachKey(FloatProcedure procedure)
    {
        procedure.value(this.key1);
    }

    public void forEachKeyValue(FloatCharProcedure procedure)
    {
        procedure.value(this.key1, this.value1);
    }

    public LazyFloatIterable keysView()
    {
        return FloatLists.immutable.of(this.key1).asLazy();
    }

    public RichIterable<FloatCharPair> keyValuesView()
    {
        return Lists.immutable.of(PrimitiveTuples.pair(this.key1, this.value1)).asLazy();
    }

    public ImmutableFloatCharMap select(FloatCharPredicate predicate)
    {
        return predicate.accept(this.key1, this.value1) ? FloatCharHashMap.newWithKeysValues(this.key1, this.value1).toImmutable()
                : new FloatCharHashMap().toImmutable();
    }

    public ImmutableFloatCharMap reject(FloatCharPredicate predicate)
    {
        return predicate.accept(this.key1, this.value1) ? new FloatCharHashMap().toImmutable()
                : FloatCharHashMap.newWithKeysValues(this.key1, this.value1).toImmutable();
    }

    public <T> T injectInto(T injectedValue, ObjectCharToObjectFunction<? super T, ? extends T> function)
    {
        return function.valueOf(injectedValue, this.value1);
    }

    public ImmutableFloatCharMap toImmutable()
    {
        return this;
    }

    public CharIterator charIterator()
    {
        return new UnmodifiableCharIterator(FloatCharHashMap.newWithKeysValues(this.key1, this.value1).charIterator());
    }

    public void forEach(CharProcedure procedure)
    {
        this.each(procedure);
    }

    /**
     * @since 7.0.
     */
    public void each(CharProcedure procedure)
    {
        procedure.value(this.value1);
    }

    public int count(CharPredicate predicate)
    {
        return predicate.accept(this.value1) ? 1 : 0;
    }

    public long sum()
    {
        return this.value1;
    }

    public char min()
    {
        return this.value1;
    }

    public char max()
    {
        return this.value1;
    }

    public char maxIfEmpty(char defaultValue)
    {
        return this.value1;
    }

    public char minIfEmpty(char defaultValue)
    {
        return this.value1;
    }

    public double average()
    {
        return this.value1;
    }

    public double median()
    {
        return this.value1;
    }

    public char[] toSortedArray()
    {
        return new char[]{this.value1};
    }

    public MutableCharList toSortedList()
    {
        return CharArrayList.newListWith(this.value1);
    }

    public boolean anySatisfy(CharPredicate predicate)
    {
        return predicate.accept(this.value1);
    }

    public boolean allSatisfy(CharPredicate predicate)
    {
        return predicate.accept(this.value1);
    }

    public boolean noneSatisfy(CharPredicate predicate)
    {
        return !predicate.accept(this.value1);
    }

    public ImmutableCharCollection select(CharPredicate predicate)
    {
        return predicate.accept(this.value1) ? CharArrayList.newListWith(this.value1).toImmutable() : new CharArrayList().toImmutable();
    }

    public ImmutableCharCollection reject(CharPredicate predicate)
    {
        return predicate.accept(this.value1) ? new CharArrayList().toImmutable() : CharArrayList.newListWith(this.value1).toImmutable();
    }

    public char detectIfNone(CharPredicate predicate, char ifNone)
    {
        return predicate.accept(this.value1) ? this.value1 : ifNone;
    }

    public <V> ImmutableCollection<V> collect(CharToObjectFunction<? extends V> function)
    {
        return Lists.immutable.of(function.valueOf(this.value1));
    }

    public char[] toArray()
    {
        return new char[]{this.value1};
    }

    public boolean contains(char value)
    {
        return this.value1 == value;
    }

    public boolean containsAll(char... source)
    {
        for (char value : source)
        {
            if (this.value1 != value)
            {
                return false;
            }
        }
        return true;
    }

    public boolean containsAll(CharIterable source)
    {
        for (CharIterator iterator = source.charIterator(); iterator.hasNext(); )
        {
            if (this.value1 != iterator.next())
            {
                return false;
            }
        }
        return true;
    }

    public MutableCharList toList()
    {
        return CharArrayList.newListWith(this.value1);
    }

    public MutableCharSet toSet()
    {
        return CharHashSet.newSetWith(this.value1);
    }

    public MutableCharBag toBag()
    {
        return CharHashBag.newBagWith(this.value1);
    }

    public LazyCharIterable asLazy()
    {
        return new LazyCharIterableAdapter(this);
    }

    public ImmutableFloatCharMap newWithKeyValue(float key, char value)
    {
        return FloatCharMaps.immutable.withAll(FloatCharHashMap.newWithKeysValues(this.key1, this.value1, key, value));
    }

    public ImmutableFloatCharMap newWithoutKey(float key)
    {
        return Float.compare(this.key1, key) == 0 ? FloatCharMaps.immutable.with() : this;
    }

    public ImmutableFloatCharMap newWithoutAllKeys(FloatIterable keys)
    {
        return keys.contains(this.key1) ? FloatCharMaps.immutable.with() : this;
    }

    public int size()
    {
        return 1;
    }

    public boolean isEmpty()
    {
        return false;
    }

    public boolean notEmpty()
    {
        return true;
    }

    public MutableFloatSet keySet()
    {
        return UnmodifiableFloatSet.of(FloatHashSet.newSetWith(this.key1));
    }

    public MutableCharCollection values()
    {
        return UnmodifiableCharCollection.of(CharArrayList.newListWith(this.value1));
    }

    @Override
    public boolean equals(Object obj)
    {
        if (obj == this)
        {
            return true;
        }
        if (!(obj instanceof FloatCharMap))
        {
            return false;
        }
        FloatCharMap map = (FloatCharMap) obj;
        if (map.size() != 1)
        {
            return false;
        }
        return map.containsKey(this.key1) && this.value1 == map.getOrThrow(this.key1);
    }

    @Override
    public int hashCode()
    {
        return Float.floatToIntBits(this.key1) ^ (int) this.value1;
    }

    @Override
    public String toString()
    {
        return "{" + this.key1 + "=" + this.value1 + "}";
    }

    public String makeString()
    {
        return this.makeString(", ");
    }

    public String makeString(String separator)
    {
        return this.makeString("", separator, "");
    }

    public String makeString(String start, String separator, String end)
    {
        Appendable stringBuilder = new StringBuilder();
        this.appendString(stringBuilder, start, separator, end);
        return stringBuilder.toString();
    }

    public void appendString(Appendable appendable)
    {
        this.appendString(appendable, ", ");
    }

    public void appendString(Appendable appendable, String separator)
    {
        this.appendString(appendable, "", separator, "");
    }

    public void appendString(Appendable appendable, String start, String separator, String end)
    {
        try
        {
            appendable.append(start);
            appendable.append(String.valueOf(this.value1));
            appendable.append(end);
        }
        catch (IOException e)
        {
            throw new RuntimeException(e);
        }
    }
}
