/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.runtime.localsearch.operations.check;

import java.util.Arrays;
import java.util.List;
import org.eclipse.viatra.query.runtime.localsearch.MatchingFrame;
import org.eclipse.viatra.query.runtime.localsearch.exceptions.LocalSearchException;
import org.eclipse.viatra.query.runtime.localsearch.matcher.ISearchContext;
import org.eclipse.viatra.query.runtime.localsearch.operations.check.CheckOperation;

public class InequalityCheck
extends CheckOperation {
    int sourceLocation;
    int targetLocation;

    public InequalityCheck(int sourceLocation, int targetLocation) {
        this.sourceLocation = sourceLocation;
        this.targetLocation = targetLocation;
    }

    @Override
    protected boolean check(MatchingFrame frame, ISearchContext context) {
        Object source = frame.getValue(this.sourceLocation);
        Object target = frame.getValue(this.targetLocation);
        if (source == null) {
            throw new LocalSearchException("Source not bound.");
        }
        if (target == null) {
            throw new LocalSearchException("Target not bound");
        }
        return !source.equals(target);
    }

    public String toString() {
        return "check     " + this.sourceLocation + " != " + this.targetLocation;
    }

    @Override
    public List<Integer> getVariablePositions() {
        return Arrays.asList(this.sourceLocation, this.targetLocation);
    }
}

