/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.runtime.localsearch.operations.generic;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.viatra.query.runtime.localsearch.MatchingFrame;
import org.eclipse.viatra.query.runtime.localsearch.matcher.ISearchContext;
import org.eclipse.viatra.query.runtime.localsearch.operations.IIteratingSearchOperation;
import org.eclipse.viatra.query.runtime.localsearch.operations.ISearchOperation;
import org.eclipse.viatra.query.runtime.matchers.context.IInputKey;
import org.eclipse.viatra.query.runtime.matchers.tuple.ITuple;
import org.eclipse.viatra.query.runtime.matchers.tuple.Tuple;
import org.eclipse.viatra.query.runtime.matchers.tuple.TupleMask;
import org.eclipse.viatra.query.runtime.matchers.tuple.VolatileMaskedTuple;
import org.eclipse.viatra.query.runtime.matchers.util.Preconditions;

public class GenericTypeExtend
implements ISearchOperation,
IIteratingSearchOperation {
    private final IInputKey type;
    private final int[] positions;
    private final List<Integer> positionList;
    private final Set<Integer> unboundVariableIndices;
    private Iterator<Tuple> it;
    private final VolatileMaskedTuple maskedTuple;
    private TupleMask indexerMask;

    public GenericTypeExtend(IInputKey type, int[] positions, TupleMask callMask, TupleMask indexerMask, Set<Integer> unboundVariableIndices) {
        Preconditions.checkArgument((positions.length == type.getArity() ? 1 : 0) != 0, (String)"The type %s requires %d parameters, but %d positions are provided", (Object[])new Object[]{type.getPrettyPrintableName(), type.getArity(), positions.length});
        ArrayList<Integer> modifiablePositionList = new ArrayList<Integer>();
        int[] nArray = positions;
        int n = positions.length;
        int n2 = 0;
        while (n2 < n) {
            int position = nArray[n2];
            modifiablePositionList.add(position);
            ++n2;
        }
        this.positionList = Collections.unmodifiableList(modifiablePositionList);
        this.positions = positions;
        this.type = type;
        this.unboundVariableIndices = unboundVariableIndices;
        this.maskedTuple = new VolatileMaskedTuple(callMask);
        this.indexerMask = indexerMask;
    }

    @Override
    public IInputKey getIteratedInputKey() {
        return this.type;
    }

    @Override
    public void onBacktrack(MatchingFrame frame, ISearchContext context) {
        for (Integer position : this.unboundVariableIndices) {
            frame.setValue(position, null);
        }
    }

    @Override
    public void onInitialize(MatchingFrame frame, ISearchContext context) {
        this.maskedTuple.updateTuple((ITuple)frame);
        this.it = context.getRuntimeContext().enumerateTuples(this.type, this.indexerMask, (ITuple)this.maskedTuple).iterator();
    }

    @Override
    public boolean execute(MatchingFrame frame, ISearchContext context) {
        if (this.it.hasNext()) {
            Tuple next = this.it.next();
            for (Integer position : this.unboundVariableIndices) {
                frame.setValue(position, null);
            }
            int i = 0;
            while (i < this.positions.length) {
                Object newValue = next.get(i);
                Object oldValue = frame.getValue(this.positions[i]);
                if (oldValue != null && !Objects.equals(oldValue, newValue)) {
                    return false;
                }
                frame.setValue(this.positions[i], newValue);
                ++i;
            }
            return true;
        }
        return false;
    }

    @Override
    public List<Integer> getVariablePositions() {
        return this.positionList;
    }

    public String toString() {
        return "extend    " + this.type.getPrettyPrintableName() + "(" + this.positionList.stream().map(input -> String.format("%s%d", this.unboundVariableIndices.contains(input) ? "-" : "+", input)).collect(Collectors.joining(", ")) + ")";
    }
}

