/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.runtime.rete.network;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.viatra.query.runtime.matchers.tuple.Tuple;
import org.eclipse.viatra.query.runtime.matchers.tuple.TupleMask;
import org.eclipse.viatra.query.runtime.matchers.util.CollectionsFactory;
import org.eclipse.viatra.query.runtime.rete.index.GenericProjectionIndexer;
import org.eclipse.viatra.query.runtime.rete.index.ProjectionIndexer;
import org.eclipse.viatra.query.runtime.rete.network.BaseNode;
import org.eclipse.viatra.query.runtime.rete.network.Direction;
import org.eclipse.viatra.query.runtime.rete.network.Mailbox;
import org.eclipse.viatra.query.runtime.rete.network.Receiver;
import org.eclipse.viatra.query.runtime.rete.network.ReteContainer;
import org.eclipse.viatra.query.runtime.rete.network.Supplier;
import org.eclipse.viatra.query.runtime.rete.traceability.TraceInfo;

public abstract class StandardNode
extends BaseNode
implements Supplier {
    protected List<Receiver> children = CollectionsFactory.createObserverList();
    private List<Mailbox> childMailboxes = CollectionsFactory.createObserverList();

    public StandardNode(ReteContainer reteContainer) {
        super(reteContainer);
    }

    protected void propagateUpdate(Direction direction, Tuple updateElement) {
        for (Mailbox childMailbox : this.childMailboxes) {
            childMailbox.postMessage(direction, updateElement);
        }
    }

    @Override
    public void appendChild(Receiver receiver) {
        this.children.add(receiver);
        this.childMailboxes.add(receiver.getMailbox());
    }

    @Override
    public void removeChild(Receiver receiver) {
        this.children.remove(receiver);
        this.childMailboxes.remove(receiver.getMailbox());
    }

    @Override
    public Collection<Receiver> getReceivers() {
        return this.children;
    }

    @Override
    public Set<Tuple> getPulledContents() {
        HashSet<Tuple> results = new HashSet<Tuple>();
        this.pullInto(results);
        return results;
    }

    @Override
    public ProjectionIndexer constructIndex(TupleMask mask, TraceInfo ... traces) {
        GenericProjectionIndexer indexer = new GenericProjectionIndexer(this.reteContainer, mask);
        TraceInfo[] traceInfoArray = traces;
        int n = traces.length;
        int n2 = 0;
        while (n2 < n) {
            TraceInfo traceInfo = traceInfoArray[n2];
            indexer.assignTraceInfo(traceInfo);
            ++n2;
        }
        this.reteContainer.connectAndSynchronize(this, indexer);
        return indexer;
    }

    protected void issueError(String message, Exception ex) {
        if (ex == null) {
            this.reteContainer.getNetwork().getEngine().getLogger().error((Object)message);
        } else {
            this.reteContainer.getNetwork().getEngine().getLogger().error((Object)message, (Throwable)ex);
        }
    }
}

