/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.transformation.evm.api;

import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.log4j.Logger;
import org.eclipse.viatra.query.runtime.matchers.util.CollectionsFactory;
import org.eclipse.viatra.transformation.evm.api.Agenda;
import org.eclipse.viatra.transformation.evm.api.RuleInstance;
import org.eclipse.viatra.transformation.evm.api.RuleSpecification;
import org.eclipse.viatra.transformation.evm.api.event.EventFilter;
import org.eclipse.viatra.transformation.evm.api.event.EventRealm;
import org.eclipse.viatra.transformation.evm.api.resolver.ConflictResolver;
import org.eclipse.viatra.transformation.evm.api.resolver.ScopedConflictSet;

public class RuleBase {
    protected final EventRealm eventRealm;
    protected final Map<RuleSpecification<?>, Map<EventFilter<?>, RuleInstance<?>>> ruleInstanceTable;
    protected final Agenda agenda;
    protected final Logger logger;

    protected RuleBase(EventRealm eventRealm, Agenda agenda) {
        this.eventRealm = Objects.requireNonNull(eventRealm, "Cannot create RuleBase with null event source");
        this.ruleInstanceTable = CollectionsFactory.createMap();
        this.logger = agenda.getLogger();
        this.agenda = agenda;
    }

    protected <EventAtom> RuleInstance<EventAtom> instantiateRule(RuleSpecification<EventAtom> specification, EventFilter<? super EventAtom> filter) {
        Objects.requireNonNull(specification, "Cannot instantiate null rule!");
        Objects.requireNonNull(filter, "Cannot instantiate rule with null filter!");
        RuleInstance<? super EventAtom> instance = this.findInstance(specification, filter);
        if (instance != null) {
            return instance;
        }
        RuleInstance<EventAtom> rule = specification.instantiateRule(this.eventRealm, filter);
        rule.addActivationNotificationListener(this.agenda.getActivationListener(), true);
        this.ruleInstanceTable.computeIfAbsent(specification, k -> CollectionsFactory.createMap()).put(filter, rule);
        return rule;
    }

    protected <EventAtom> boolean removeRule(RuleInstance<EventAtom> instance) {
        Objects.requireNonNull(instance, "Cannot remove null rule instance!");
        return this.removeRule(instance.getSpecification(), instance.getFilter());
    }

    protected <EventAtom> boolean removeRule(RuleSpecification<EventAtom> specification, EventFilter<? super EventAtom> filter) {
        Objects.requireNonNull(specification, "Cannot remove null rule specification!");
        Objects.requireNonNull(filter, "Cannot remove instance for null filter");
        RuleInstance<EventAtom> instance = this.findInstance(specification, filter);
        if (instance != null) {
            instance.dispose();
            this.ruleInstanceTable.compute(specification, (k, old) -> {
                old.remove(filter);
                return old.isEmpty() ? null : old;
            });
            return true;
        }
        return false;
    }

    protected void dispose() {
        for (RuleInstance<?> instance : this.getRuleInstances()) {
            instance.dispose();
        }
    }

    public EventRealm getEventRealm() {
        return this.eventRealm;
    }

    public Map<RuleSpecification<?>, Set<EventFilter<?>>> getRuleSpecificationMultimap() {
        return this.ruleInstanceTable.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> ((Map)entry.getValue()).keySet()));
    }

    public Set<RuleInstance<?>> getRuleInstances() {
        return this.ruleInstanceTable.values().stream().flatMap(instancesByFilter -> instancesByFilter.values().stream()).collect(Collectors.toSet());
    }

    public <EventAtom> RuleInstance<EventAtom> getInstance(RuleSpecification<EventAtom> specification, EventFilter<? super EventAtom> filter) {
        Objects.requireNonNull(specification, "Cannot get instance for null specification");
        Objects.requireNonNull(filter, "Cannot get instance for null filter");
        return this.findInstance(specification, filter);
    }

    protected <EventAtom> RuleInstance<EventAtom> findInstance(RuleSpecification<EventAtom> specification, EventFilter<? super EventAtom> filter) {
        return (RuleInstance)this.ruleInstanceTable.getOrDefault(specification, Collections.emptyMap()).get(filter);
    }

    public ScopedConflictSet createScopedConflictSet(ConflictResolver conflictResolver, Map<RuleSpecification<?>, Set<EventFilter<?>>> specifications) {
        ScopedConflictSet set = new ScopedConflictSet(this, conflictResolver, specifications);
        return set;
    }

    public Agenda getAgenda() {
        return this.agenda;
    }

    public Logger getLogger() {
        return this.logger;
    }
}

