/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.runtime.rete.construction.quasitree;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.viatra.query.runtime.matchers.planning.SubPlan;
import org.eclipse.viatra.query.runtime.matchers.planning.SubPlanFactory;
import org.eclipse.viatra.query.runtime.matchers.planning.helpers.FunctionalDependencyHelper;
import org.eclipse.viatra.query.runtime.matchers.planning.operations.PJoin;
import org.eclipse.viatra.query.runtime.matchers.planning.operations.POperation;
import org.eclipse.viatra.query.runtime.matchers.psystem.PConstraint;
import org.eclipse.viatra.query.runtime.matchers.psystem.PVariable;
import org.eclipse.viatra.query.runtime.matchers.psystem.analysis.QueryAnalyzer;
import org.eclipse.viatra.query.runtime.matchers.util.CollectionsFactory;
import org.eclipse.viatra.query.runtime.rete.construction.quasitree.TieBreaker;

class JoinCandidate {
    private QueryAnalyzer analyzer;
    SubPlan primary;
    SubPlan secondary;
    Set<PVariable> varPrimary;
    Set<PVariable> varSecondary;
    Set<PVariable> varCommon;
    List<PConstraint> consPrimary;
    List<PConstraint> consSecondary;
    private Boolean heath;

    JoinCandidate(SubPlan primary, SubPlan secondary, QueryAnalyzer analyzer) {
        this.primary = primary;
        this.secondary = secondary;
        this.analyzer = analyzer;
        this.varPrimary = this.getPrimary().getVisibleVariables();
        this.varSecondary = this.getSecondary().getVisibleVariables();
        this.varCommon = CollectionsFactory.createSet(this.varPrimary);
        this.varCommon.retainAll(this.varSecondary);
        this.consPrimary = new ArrayList<PConstraint>(primary.getAllEnforcedConstraints());
        Collections.sort(this.consPrimary, TieBreaker.CONSTRAINT_COMPARATOR);
        this.consSecondary = new ArrayList<PConstraint>(secondary.getAllEnforcedConstraints());
        Collections.sort(this.consSecondary, TieBreaker.CONSTRAINT_COMPARATOR);
    }

    public SubPlan getPrimary() {
        return this.primary;
    }

    public SubPlan getSecondary() {
        return this.secondary;
    }

    public SubPlan getJoinedPlan(SubPlanFactory factory) {
        if (this.isTrivial()) {
            return this.primary;
        }
        if (this.isSubsumption()) {
            return this.consPrimary.size() > this.consSecondary.size() ? this.primary : this.secondary;
        }
        return factory.createSubPlan((POperation)new PJoin(), new SubPlan[]{this.primary, this.secondary});
    }

    public String toString() {
        return String.valueOf(this.primary.toString()) + " |x| " + this.secondary.toString();
    }

    public Set<PVariable> getVarPrimary() {
        return this.varPrimary;
    }

    public Set<PVariable> getVarSecondary() {
        return this.varSecondary;
    }

    public List<PConstraint> getConsPrimary() {
        return this.consPrimary;
    }

    public List<PConstraint> getConsSecondary() {
        return this.consSecondary;
    }

    public boolean isTrivial() {
        return this.getPrimary().equals((Object)this.getSecondary());
    }

    public boolean isSubsumption() {
        return this.consPrimary.containsAll(this.consSecondary) || this.consSecondary.containsAll(this.consPrimary);
    }

    public boolean isCheckOnly() {
        return this.varPrimary.containsAll(this.varSecondary) || this.varSecondary.containsAll(this.varPrimary);
    }

    public boolean isDescartes() {
        return Collections.disjoint(this.varPrimary, this.varSecondary);
    }

    public boolean isHeath() {
        if (this.heath == null) {
            Set union = Stream.concat(this.primary.getAllEnforcedConstraints().stream(), this.secondary.getAllEnforcedConstraints().stream()).collect(Collectors.toSet());
            Map dependencies = this.analyzer.getFunctionalDependencies(union, false);
            Set varCommonClosure = FunctionalDependencyHelper.closureOf(this.varCommon, (Map)dependencies);
            this.heath = varCommonClosure.containsAll(this.varPrimary) || varCommonClosure.containsAll(this.varSecondary);
        }
        return this.heath;
    }
}

