/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.tooling.localsearch.ui.debugger.provider.viewelement;

import org.eclipse.viatra.query.runtime.localsearch.matcher.MatcherReference;
import org.eclipse.viatra.query.runtime.localsearch.operations.IPatternMatcherOperation;
import org.eclipse.viatra.query.runtime.localsearch.operations.ISearchOperation;
import org.eclipse.viatra.query.runtime.localsearch.plan.IPlanDescriptor;
import org.eclipse.viatra.query.runtime.localsearch.plan.SearchPlanForBody;
import org.eclipse.viatra.query.tooling.localsearch.ui.debugger.LocalSearchDebugger;
import org.eclipse.viatra.query.tooling.localsearch.ui.debugger.provider.viewelement.DebugSessionNode;
import org.eclipse.viatra.query.tooling.localsearch.ui.debugger.provider.viewelement.IPlanNode;
import org.eclipse.viatra.query.tooling.localsearch.ui.debugger.provider.viewelement.PatternBodyNode;
import org.eclipse.viatra.query.tooling.localsearch.ui.debugger.provider.viewelement.SearchOperationNode;

public class ViewModelFactory {
    private final LocalSearchDebugger debugger;

    public ViewModelFactory(LocalSearchDebugger debugger) {
        this.debugger = debugger;
    }

    public IPlanNode createViewModel(IPlanDescriptor descriptor) {
        return this.createRootNode(descriptor);
    }

    private IPlanNode createRootNode(IPlanDescriptor descriptor) {
        DebugSessionNode root = new DebugSessionNode(descriptor.getQuery());
        this.doCreateChildren(root, descriptor);
        return root;
    }

    private IPlanNode createBodyNode(IPlanNode parent, SearchPlanForBody plan) {
        PatternBodyNode node = new PatternBodyNode(parent, plan);
        parent.addChild(plan.getBody(), node);
        plan.getCompiledOperations().forEach(op -> {
            IPlanNode iPlanNode = this.createSearchOperationNode(node, (ISearchOperation)op);
        });
        return node;
    }

    private IPlanNode createSearchOperationNode(PatternBodyNode parent, ISearchOperation operation) {
        SearchOperationNode node = new SearchOperationNode(parent, operation);
        parent.addChild(operation, node);
        if (operation instanceof IPatternMatcherOperation) {
            MatcherReference reference = ((IPatternMatcherOperation)operation).getCallInformation().getReference();
            this.debugger.getSearchPlan(reference.getQuery(), reference.getAdornment()).ifPresent(desc -> this.doCreateChildren(node, (IPlanDescriptor)desc));
        }
        return node;
    }

    private void doCreateChildren(IPlanNode node, IPlanDescriptor desc) {
        desc.getPlan().forEach(plan -> {
            IPlanNode iPlanNode2 = this.createBodyNode(node, (SearchPlanForBody)plan);
        });
    }
}

