/**
 * 
 *   Copyright (c) 2010-2015, Csaba Debreceni, Istvan Rath and Daniel Varro
 *   This program and the accompanying materials are made available under the
 *   terms of the Eclipse Public License v. 2.0 which is available at
 *   http://www.eclipse.org/legal/epl-v20.html.
 *   
 *   SPDX-License-Identifier: EPL-2.0
 *  
 */
package org.eclipse.viatra.transformation.views.traceability.patterns;

import org.eclipse.viatra.query.runtime.api.ViatraQueryEngine;
import org.eclipse.viatra.query.runtime.api.impl.BaseGeneratedPatternGroup;

/**
 * A pattern group formed of all public patterns defined in helpers.vql.
 * 
 * <p>Use the static instance as any {@link interface org.eclipse.viatra.query.runtime.api.IQueryGroup}, to conveniently prepare
 * a VIATRA Query engine for matching all patterns originally defined in file helpers.vql,
 * in order to achieve better performance than one-by-one on-demand matcher initialization.
 * 
 * <p> From package org.eclipse.viatra.transformation.views.traceability.patterns, the group contains the definition of the following patterns: <ul>
 * <li>emptyTrace</li>
 * <li>trace2target</li>
 * <li>trace2param</li>
 * <li>trace2object</li>
 * <li>param2target</li>
 * <li>trace</li>
 * </ul>
 * 
 * @see IQueryGroup
 * 
 */
@SuppressWarnings("all")
public final class Helpers extends BaseGeneratedPatternGroup {
  /**
   * Access the pattern group.
   * 
   * @return the singleton instance of the group
   * @throws ViatraQueryRuntimeException if there was an error loading the generated code of pattern specifications
   * 
   */
  public static Helpers instance() {
    if (INSTANCE == null) {
        INSTANCE = new Helpers();
    }
    return INSTANCE;
  }

  private static Helpers INSTANCE;

  private Helpers() {
    querySpecifications.add(EmptyTrace.instance());
    querySpecifications.add(Trace2target.instance());
    querySpecifications.add(Trace2param.instance());
    querySpecifications.add(Trace2object.instance());
    querySpecifications.add(Param2target.instance());
    querySpecifications.add(Trace.instance());
  }

  public EmptyTrace getEmptyTrace() {
    return EmptyTrace.instance();
  }

  public EmptyTrace.Matcher getEmptyTrace(final ViatraQueryEngine engine) {
    return EmptyTrace.Matcher.on(engine);
  }

  public Trace2target getTrace2target() {
    return Trace2target.instance();
  }

  public Trace2target.Matcher getTrace2target(final ViatraQueryEngine engine) {
    return Trace2target.Matcher.on(engine);
  }

  public Trace2param getTrace2param() {
    return Trace2param.instance();
  }

  public Trace2param.Matcher getTrace2param(final ViatraQueryEngine engine) {
    return Trace2param.Matcher.on(engine);
  }

  public Trace2object getTrace2object() {
    return Trace2object.instance();
  }

  public Trace2object.Matcher getTrace2object(final ViatraQueryEngine engine) {
    return Trace2object.Matcher.on(engine);
  }

  public Param2target getParam2target() {
    return Param2target.instance();
  }

  public Param2target.Matcher getParam2target(final ViatraQueryEngine engine) {
    return Param2target.Matcher.on(engine);
  }

  public Trace getTrace() {
    return Trace.instance();
  }

  public Trace.Matcher getTrace(final ViatraQueryEngine engine) {
    return Trace.Matcher.on(engine);
  }
}
