/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.runtime.api;

import java.util.Objects;
import java.util.ServiceLoader;
import org.eclipse.viatra.query.runtime.matchers.backend.IQueryBackendFactory;
import org.eclipse.viatra.query.runtime.matchers.backend.IQueryBackendFactoryProvider;
import org.eclipse.viatra.query.runtime.matchers.backend.QueryEvaluationHint;
import org.eclipse.viatra.query.runtime.matchers.util.Preconditions;

public final class ViatraQueryEngineOptions {
    private static boolean areSystemDefaultsCalculated = false;
    private static IQueryBackendFactory systemDefaultBackendFactory;
    private static IQueryBackendFactory systemDefaultCachingBackendFactory;
    private static IQueryBackendFactory systemDefaultSearchBackendFactory;
    private final QueryEvaluationHint engineDefaultHints;
    private final IQueryBackendFactory defaultCachingBackendFactory;
    private final IQueryBackendFactory defaultSearchBackendFactory;
    private static ViatraQueryEngineOptions DEFAULT;

    public static void setSystemDefaultBackends(IQueryBackendFactory systemDefaultBackendFactory, IQueryBackendFactory systemDefaultCachingBackendFactory, IQueryBackendFactory systemDefaultSearchBackendFactory) {
        areSystemDefaultsCalculated = true;
        ViatraQueryEngineOptions.systemDefaultBackendFactory = systemDefaultBackendFactory;
        ViatraQueryEngineOptions.systemDefaultCachingBackendFactory = systemDefaultCachingBackendFactory;
        ViatraQueryEngineOptions.systemDefaultSearchBackendFactory = systemDefaultSearchBackendFactory;
    }

    private static void calculateSystemDefaultBackends() {
        for (IQueryBackendFactoryProvider provider : ServiceLoader.load(IQueryBackendFactoryProvider.class)) {
            if (provider.isSystemDefaultEngine()) {
                systemDefaultBackendFactory = provider.getFactory();
            }
            if (provider.isSystemDefaultCachingBackend()) {
                systemDefaultCachingBackendFactory = provider.getFactory();
            }
            if (!provider.isSystemDefaultSearchBackend()) continue;
            systemDefaultSearchBackendFactory = provider.getFactory();
        }
        areSystemDefaultsCalculated = true;
    }

    private static IQueryBackendFactory getSystemDefaultBackend() {
        if (!areSystemDefaultsCalculated) {
            ViatraQueryEngineOptions.calculateSystemDefaultBackends();
        }
        return Objects.requireNonNull(systemDefaultBackendFactory, "System default backend not found");
    }

    private static IQueryBackendFactory getSystemDefaultCachingBackend() {
        if (!areSystemDefaultsCalculated) {
            ViatraQueryEngineOptions.calculateSystemDefaultBackends();
        }
        return Objects.requireNonNull(systemDefaultCachingBackendFactory, "System default caching backend not found");
    }

    private static IQueryBackendFactory getSystemDefaultSearchBackend() {
        if (!areSystemDefaultsCalculated) {
            ViatraQueryEngineOptions.calculateSystemDefaultBackends();
        }
        return Objects.requireNonNull(systemDefaultSearchBackendFactory, "System default search backend not found");
    }

    public static final ViatraQueryEngineOptions getDefault() {
        if (DEFAULT == null) {
            DEFAULT = new Builder().build();
        }
        return DEFAULT;
    }

    public static Builder defineOptions() {
        return new Builder();
    }

    public static Builder copyOptions(ViatraQueryEngineOptions options) {
        return new Builder(options);
    }

    private ViatraQueryEngineOptions(QueryEvaluationHint engineDefaultHints, IQueryBackendFactory defaultCachingBackendFactory, IQueryBackendFactory defaultSearchBackendFactory) {
        this.engineDefaultHints = engineDefaultHints;
        this.defaultCachingBackendFactory = defaultCachingBackendFactory;
        this.defaultSearchBackendFactory = defaultSearchBackendFactory;
    }

    public QueryEvaluationHint getEngineDefaultHints() {
        return this.engineDefaultHints;
    }

    public IQueryBackendFactory getDefaultBackendFactory() {
        switch (this.engineDefaultHints.getQueryBackendRequirementType()) {
            case DEFAULT_CACHING: {
                return ViatraQueryEngineOptions.getSystemDefaultCachingBackend();
            }
            case DEFAULT_SEARCH: {
                return ViatraQueryEngineOptions.getSystemDefaultCachingBackend();
            }
            case SPECIFIC: {
                return this.engineDefaultHints.getQueryBackendFactory();
            }
        }
        return ViatraQueryEngineOptions.getSystemDefaultBackend();
    }

    public IQueryBackendFactory getDefaultCachingBackendFactory() {
        return this.defaultCachingBackendFactory;
    }

    public IQueryBackendFactory getDefaultSearchBackendFactory() {
        return this.defaultSearchBackendFactory;
    }

    public String toString() {
        if (Objects.equals(this.engineDefaultHints, ViatraQueryEngineOptions.DEFAULT.engineDefaultHints)) {
            return "defaults";
        }
        return this.engineDefaultHints.toString();
    }

    public IQueryBackendFactory getQueryBackendFactory(QueryEvaluationHint hint) {
        if (hint == null) {
            return this.getDefaultBackendFactory();
        }
        switch (hint.getQueryBackendRequirementType()) {
            case DEFAULT_CACHING: {
                return this.getDefaultCachingBackendFactory();
            }
            case DEFAULT_SEARCH: {
                return this.getDefaultSearchBackendFactory();
            }
            case SPECIFIC: {
                return hint.getQueryBackendFactory();
            }
        }
        return this.getDefaultBackendFactory();
    }

    public static final class Builder {
        private QueryEvaluationHint engineDefaultHints;
        private IQueryBackendFactory defaultBackendFactory;
        private IQueryBackendFactory defaultCachingBackendFactory;
        private IQueryBackendFactory defaultSearchBackendFactory;

        public Builder() {
        }

        public Builder(ViatraQueryEngineOptions from) {
            this.engineDefaultHints = from.engineDefaultHints;
            this.defaultBackendFactory = this.engineDefaultHints.getQueryBackendFactory();
            this.defaultCachingBackendFactory = from.defaultCachingBackendFactory;
            this.defaultSearchBackendFactory = from.defaultSearchBackendFactory;
        }

        public Builder withDefaultHint(QueryEvaluationHint engineDefaultHints) {
            this.engineDefaultHints = engineDefaultHints;
            return this;
        }

        public Builder withDefaultBackend(IQueryBackendFactory defaultBackendFactory) {
            this.defaultBackendFactory = defaultBackendFactory;
            return this;
        }

        public Builder withDefaultSearchBackend(IQueryBackendFactory defaultSearchBackendFactory) {
            Preconditions.checkArgument((!defaultSearchBackendFactory.isCaching() ? 1 : 0) != 0, (String)"%s is not a search backend", (Object[])new Object[]{defaultSearchBackendFactory.getClass()});
            this.defaultSearchBackendFactory = defaultSearchBackendFactory;
            return this;
        }

        public Builder withDefaultCachingBackend(IQueryBackendFactory defaultCachingBackendFactory) {
            Preconditions.checkArgument((boolean)defaultCachingBackendFactory.isCaching(), (String)"%s is not a caching backend", (Object[])new Object[]{defaultCachingBackendFactory.getClass()});
            this.defaultCachingBackendFactory = defaultCachingBackendFactory;
            return this;
        }

        public ViatraQueryEngineOptions build() {
            IQueryBackendFactory defaultFactory = this.getDefaultBackend();
            QueryEvaluationHint hint = this.getEngineDefaultHints(defaultFactory);
            return new ViatraQueryEngineOptions(hint, this.getDefaultCachingBackend(), this.getDefaultSearchBackend());
        }

        private IQueryBackendFactory getDefaultBackend() {
            if (this.defaultBackendFactory != null) {
                return this.defaultBackendFactory;
            }
            if (this.engineDefaultHints != null) {
                return this.engineDefaultHints.getQueryBackendFactory();
            }
            return ViatraQueryEngineOptions.getSystemDefaultBackend();
        }

        private IQueryBackendFactory getDefaultCachingBackend() {
            if (this.defaultCachingBackendFactory != null) {
                return this.defaultCachingBackendFactory;
            }
            if (this.defaultBackendFactory != null && this.defaultBackendFactory.isCaching()) {
                return this.defaultBackendFactory;
            }
            return ViatraQueryEngineOptions.getSystemDefaultCachingBackend();
        }

        private IQueryBackendFactory getDefaultSearchBackend() {
            if (this.defaultSearchBackendFactory != null) {
                return this.defaultSearchBackendFactory;
            }
            if (this.defaultBackendFactory != null && !this.defaultBackendFactory.isCaching()) {
                return this.defaultBackendFactory;
            }
            return ViatraQueryEngineOptions.getSystemDefaultSearchBackend();
        }

        private QueryEvaluationHint getEngineDefaultHints(IQueryBackendFactory defaultFactory) {
            if (this.engineDefaultHints != null) {
                return this.engineDefaultHints.overrideBy(new QueryEvaluationHint(null, defaultFactory));
            }
            return new QueryEvaluationHint(null, defaultFactory);
        }
    }
}

