/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.dse.statecoding;

import java.util.Collection;
import java.util.HashSet;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.viatra.dse.api.DSEException;
import org.eclipse.viatra.dse.statecoding.IObjectsProvider;
import org.eclipse.viatra.dse.statecoding.StatecodingDependencyGraph;
import org.eclipse.viatra.dse.statecoding.StatecodingNode;
import org.eclipse.viatra.query.runtime.api.ViatraQueryEngine;
import org.eclipse.viatra.query.runtime.api.scope.QueryScope;
import org.eclipse.viatra.query.runtime.base.api.IndexingLevel;
import org.eclipse.viatra.query.runtime.base.api.NavigationHelper;
import org.eclipse.viatra.query.runtime.emf.EMFScope;
import org.eclipse.viatra.query.runtime.exception.ViatraQueryException;

public class IncrementalObjectProvider
implements IObjectsProvider {
    private Logger logger = Logger.getLogger(this.getClass());
    private NavigationHelper baseIndex;

    @Override
    public void init(Notifier notifier, StatecodingDependencyGraph statecodingDependencyGraph) {
        try {
            EMFScope scope = new EMFScope(notifier);
            ViatraQueryEngine queryEngine = ViatraQueryEngine.on((QueryScope)scope);
            HashSet<EClass> classes = new HashSet<EClass>();
            for (StatecodingNode node : statecodingDependencyGraph.getNodes()) {
                classes.add(node.getClazz());
            }
            this.baseIndex = EMFScope.extractUnderlyingEMFIndex((ViatraQueryEngine)queryEngine);
            this.baseIndex.registerEClasses(classes, IndexingLevel.FULL);
        }
        catch (ViatraQueryException e) {
            this.logger.error((Object)"Failed to initialize VIATRA Query engine on the given notifier", (Throwable)e);
            throw new DSEException("Failed to initialize VIATRA Query engine on the given notifier");
        }
    }

    @Override
    public Collection<EObject> getEObjects(EClass eClass) {
        return this.baseIndex.getAllInstances(eClass);
    }
}

