/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.tooling.ui.retevis.views;

import java.util.HashSet;
import java.util.Map;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.swt.graphics.Image;
import org.eclipse.viatra.addon.viewers.runtime.notation.Item;
import org.eclipse.viatra.addon.viewers.runtime.zest.sources.ZestLabelProvider;
import org.eclipse.viatra.query.runtime.matchers.memories.MaskedTupleMemory;
import org.eclipse.viatra.query.runtime.matchers.tuple.Tuple;
import org.eclipse.viatra.query.runtime.rete.boundary.ExternalInputEnumeratorNode;
import org.eclipse.viatra.query.runtime.rete.index.IndexerWithMemory;
import org.eclipse.viatra.query.runtime.rete.index.IterableIndexer;
import org.eclipse.viatra.query.runtime.rete.network.Node;
import org.eclipse.viatra.query.runtime.rete.recipes.IndexerRecipe;
import org.eclipse.viatra.query.runtime.rete.recipes.Mask;
import org.eclipse.viatra.query.runtime.rete.recipes.ReteNodeRecipe;
import org.eclipse.viatra.query.runtime.rete.single.AbstractUniquenessEnforcerNode;

public class ReteVisualizationLabelProvider
extends ZestLabelProvider {
    private final Map<ReteNodeRecipe, Node> nodeTrace;

    public ReteVisualizationLabelProvider(Map<ReteNodeRecipe, Node> nodeTrace) {
        this.nodeTrace = nodeTrace;
    }

    public Image getImage(Object element) {
        return null;
    }

    public String getText(Object element) {
        Item item;
        EObject paramObject;
        String inherited = super.getText(element);
        StringBuilder text = new StringBuilder(inherited == null ? "" : inherited);
        if (element instanceof Item && (paramObject = (item = (Item)element).getParamEObject()) instanceof ReteNodeRecipe) {
            ReteNodeRecipe recipe = (ReteNodeRecipe)paramObject;
            Node node = this.nodeTrace.get(recipe);
            if (node instanceof ExternalInputEnumeratorNode) {
                ExternalInputEnumeratorNode input = (ExternalInputEnumeratorNode)node;
                text.append(ReteVisualizationLabelProvider.formatSize(input.getPulledContents().size()));
            } else if (node instanceof AbstractUniquenessEnforcerNode) {
                AbstractUniquenessEnforcerNode uniquenessEnforcerNode = (AbstractUniquenessEnforcerNode)node;
                text.append(ReteVisualizationLabelProvider.formatSize(uniquenessEnforcerNode.getTuples().size()));
            } else if (node instanceof IndexerWithMemory) {
                IndexerWithMemory indexerWithMemory = (IndexerWithMemory)node;
                MaskedTupleMemory memory = indexerWithMemory.getMemory();
                text.append(ReteVisualizationLabelProvider.formatSizeWithBuckets(memory.getTotalSize(), memory.getKeysetSize()));
            } else if (node instanceof IterableIndexer) {
                IterableIndexer iterableIndexer = (IterableIndexer)node;
                Iterable signatures = iterableIndexer.getSignatures();
                int bucketCount = iterableIndexer.getBucketCount();
                boolean identityIndexer = false;
                if (recipe instanceof IndexerRecipe) {
                    Mask mask = ((IndexerRecipe)recipe).getMask();
                    identityIndexer = mask.getSourceArity() == new HashSet(mask.getSourceIndices()).size();
                }
                int allTuples = 0;
                if (identityIndexer) {
                    allTuples = bucketCount;
                } else {
                    for (Tuple bucketSignature : signatures) {
                        allTuples += ((IterableIndexer)node).get(bucketSignature).size();
                    }
                }
                text.append(ReteVisualizationLabelProvider.formatSizeWithBuckets(allTuples, bucketCount));
            }
        }
        return text.toString();
    }

    private static String formatSize(int size) {
        return "\n [" + size + " tuples]";
    }

    private static String formatSizeWithBuckets(int size, int buckets) {
        return "\n [" + size + " tuples in " + buckets + " buckets]";
    }
}

