/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.ide.manifest.core;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Writer;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Dictionary;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IPathVariableManager;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jst.j2ee.web.componentcore.util.WebArtifactEdit;
import org.eclipse.osgi.util.ManifestElement;
import org.eclipse.virgo.ide.facet.core.FacetUtils;
import org.eclipse.virgo.ide.manifest.core.BundleManifestCorePlugin;
import org.eclipse.virgo.ide.manifest.internal.core.model.BundleManifestHeader;
import org.eclipse.virgo.ide.module.core.ServerModuleDelegate;
import org.eclipse.virgo.util.osgi.manifest.BundleManifest;
import org.eclipse.virgo.util.osgi.manifest.BundleManifestFactory;
import org.eclipse.wst.common.project.facet.core.FacetedProjectFramework;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BundleManifestUtils {
    private static final String FILE_SCHEME = "file";

    public static BundleManifest getBundleManifest(IJavaProject javaProject, boolean testBundle) {
        IFile manifestFile = BundleManifestUtils.locateManifest(javaProject, testBundle);
        if (manifestFile != null) {
            try {
                return BundleManifestFactory.createBundleManifest((Reader)new InputStreamReader(manifestFile.getContents(true)));
            }
            catch (Exception exception) {}
        }
        return null;
    }

    public static IFile locateManifest(IJavaProject javaProject, boolean testBundle) {
        String manifestLocation = testBundle ? BundleManifestCorePlugin.TEST_MANIFEST_FILE_LOCATION : BundleManifestCorePlugin.MANIFEST_FILE_LOCATION;
        try {
            IPath webDotXmlPath;
            WebArtifactEdit webArtifact;
            IFile manifestFileHandle;
            IPath path;
            for (IClasspathEntry entry : ServerModuleDelegate.getSourceClasspathEntries(javaProject.getProject(), testBundle)) {
                path = entry.getPath().append(manifestLocation).removeFirstSegments(1);
                manifestFileHandle = javaProject.getProject().getFile(path);
                if (!manifestFileHandle.exists()) continue;
                return manifestFileHandle;
            }
            if (FacetedProjectFramework.hasProjectFacet((IProject)javaProject.getProject(), (String)"jst.web") && (webArtifact = WebArtifactEdit.getWebArtifactEditForRead((IProject)javaProject.getProject())) != null && (webDotXmlPath = webArtifact.getDeploymentDescriptorPath()) != null) {
                path = webDotXmlPath.removeLastSegments(2).append(manifestLocation).removeFirstSegments(1);
                manifestFileHandle = javaProject.getProject().getFile(path);
                if (manifestFileHandle.exists()) {
                    return manifestFileHandle;
                }
            }
        }
        catch (Exception exception) {}
        return null;
    }

    public static String locateManifestFolder(IJavaProject javaProject) {
        IContainer container;
        IPath location;
        IFile resource = BundleManifestUtils.locateManifest(javaProject, false);
        if (resource != null && (location = (container = resource.getParent().getParent()).getRawLocation()) != null) {
            return location.toString();
        }
        return null;
    }

    public static File locateManifestFile(IJavaProject javaProject, boolean testBundle) {
        URI uri;
        IFile resource = BundleManifestUtils.locateManifest(javaProject, testBundle);
        if (resource != null && (uri = BundleManifestUtils.convertResourceToUrl((IResource)resource)) != null) {
            return new File(uri);
        }
        return null;
    }

    private static URI convertResourceToUrl(IResource resource) {
        URI uri;
        if (resource != null && (uri = resource.getRawLocationURI()) != null) {
            String scheme = uri.getScheme();
            if (FILE_SCHEME.equalsIgnoreCase(scheme)) {
                return uri;
            }
            if ("sourcecontrol".equals(scheme)) {
                IPath path = resource.getLocation();
                File file = path.toFile();
                if (file.exists()) {
                    return file.toURI();
                }
            } else {
                IPathVariableManager variableManager = ResourcesPlugin.getWorkspace().getPathVariableManager();
                return variableManager.resolveURI(uri);
            }
        }
        return null;
    }

    private static IResource findResource(IProject project, IPath path) {
        if (path != null && project != null && path.removeFirstSegments(1) != null) {
            return project.findMember(path.removeFirstSegments(1));
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    public static void createNewBundleManifest(IJavaProject javaProject, String symbolicName, String bundleVersion, String providerName, String bundleName, String serverModule, Map<String, String> properties) {
        block39: {
            block37: {
                manifest = null;
                existingManifestFile = BundleManifestUtils.locateManifestFile(javaProject, false);
                if (existingManifestFile != null) {
                    reader = null;
                    try {
                        reader = new FileReader(existingManifestFile);
                        manifest = BundleManifestFactory.createBundleManifest((Reader)new FileReader(existingManifestFile));
                    }
                    catch (FileNotFoundException v0) {
                        if (reader != null) {
                            try {
                                reader.close();
                            }
                            catch (IOException v1) {}
                        }
                        break block37;
                    }
                    catch (IOException v2) {
                        try {
                            ** if (reader == null) goto lbl-1000
                        }
                        catch (Throwable var10_10) {
                            if (reader != null) {
                                try {
                                    reader.close();
                                }
                                catch (IOException v4) {}
                            }
                            throw var10_10;
                        }
lbl-1000:
                        // 1 sources

                        {
                            try {
                                reader.close();
                            }
                            catch (IOException v3) {}
                        }
lbl-1000:
                        // 2 sources

                        {
                            break block37;
                        }
                    }
                    ** if (reader == null) goto lbl-1000
lbl-1000:
                    // 1 sources

                    {
                        try {
                            reader.close();
                        }
                        catch (IOException v5) {}
                    }
lbl-1000:
                    // 2 sources

                    {
                        break block37;
                    }
                }
                manifest = BundleManifestFactory.createBundleManifest();
            }
            manifest.setBundleManifestVersion(2);
            dictonary = manifest.toDictionary();
            if (StringUtils.isNotBlank((String)symbolicName)) {
                dictonary.put("Bundle-SymbolicName", symbolicName);
            }
            if (StringUtils.isNotBlank((String)bundleVersion)) {
                dictonary.put("Bundle-Version", bundleVersion);
            }
            if (StringUtils.isNotBlank((String)bundleName)) {
                dictonary.put("Bundle-Name", bundleName);
            }
            if (StringUtils.isNotBlank((String)providerName)) {
                dictonary.put("Bundle-Description", providerName);
            }
            for (Map.Entry<String, String> entry : properties.entrySet()) {
                if (!StringUtils.isNotEmpty((String)entry.getValue()) || !StringUtils.isNotEmpty((String)entry.getKey())) continue;
                dictonary.put(entry.getKey(), entry.getValue());
            }
            writer = null;
            try {
                try {
                    writer = existingManifestFile != null ? new FileWriter(existingManifestFile) : new FileWriter(BundleManifestUtils.getFirstPossibleManifestFile(javaProject.getProject(), false).getRawLocation().toFile());
                    bundleManifest = BundleManifestFactory.createBundleManifest((Dictionary)dictonary);
                    bundleManifest.write(writer);
                }
                catch (IOException v6) {
                    if (writer != null) {
                        try {
                            writer.flush();
                            writer.close();
                        }
                        catch (IOException v7) {}
                    }
                    break block39;
                }
            }
            catch (Throwable var12_13) {
                if (writer != null) {
                    try {
                        writer.flush();
                        writer.close();
                    }
                    catch (IOException v8) {}
                }
                throw var12_13;
            }
            if (writer != null) {
                try {
                    writer.flush();
                    writer.close();
                }
                catch (IOException v9) {}
            }
        }
    }

    public static void createNewParManifest(IProject project, String symbolicName, String version, String name, String description) {
        block18: {
            Dictionary manifest = BundleManifestFactory.createBundleManifest().toDictionary();
            if (StringUtils.isNotBlank((String)symbolicName)) {
                manifest.put("Application-SymbolicName", symbolicName);
            }
            if (StringUtils.isNotBlank((String)version)) {
                manifest.put("Application-Version", version);
            }
            if (StringUtils.isNotBlank((String)name)) {
                manifest.put("Application-Name", name);
            }
            if (StringUtils.isNotBlank((String)description)) {
                manifest.put("Application-Description", description);
            }
            Writer writer = null;
            try {
                try {
                    writer = new FileWriter(BundleManifestUtils.getFirstPossibleManifestFile(project, false).getRawLocation().toFile());
                    BundleManifest bundleManifest = BundleManifestFactory.createBundleManifest((Dictionary)manifest);
                    bundleManifest.write(writer);
                }
                catch (IOException iOException) {
                    if (writer != null) {
                        try {
                            writer.flush();
                            writer.close();
                        }
                        catch (IOException iOException2) {}
                    }
                    break block18;
                }
            }
            catch (Throwable throwable) {
                if (writer != null) {
                    try {
                        writer.flush();
                        writer.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            if (writer != null) {
                try {
                    writer.flush();
                    writer.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static IFile getFirstPossibleManifestFile(final IProject project, boolean isTestManifest) {
        block4: {
            try {
                if (FacetUtils.hasNature((IResource)project, (String)"org.eclipse.jdt.core.javanature")) {
                    ArrayList<IClasspathEntry> entries = new ArrayList<IClasspathEntry>(ServerModuleDelegate.getSourceClasspathEntries(project, isTestManifest));
                    Collections.sort(entries, new Comparator<IClasspathEntry>(){

                        @Override
                        public int compare(IClasspathEntry o1, IClasspathEntry o2) {
                            String s1 = o1.getPath().toString();
                            String s2 = o2.getPath().toString();
                            if (("/" + project.getName() + "/src/main/resources").equals(s1)) {
                                return -1;
                            }
                            if (("/" + project.getName() + "/src/test/resources").equals(s1)) {
                                return -1;
                            }
                            if (("/" + project.getName() + "/src/main/resources").equals(s2)) {
                                return 1;
                            }
                            if (("/" + project.getName() + "/src/test/resources").equals(s2)) {
                                return 1;
                            }
                            return s1.compareTo(s2);
                        }
                    });
                    Iterator iterator = entries.iterator();
                    if (iterator.hasNext()) {
                        IClasspathEntry entry = (IClasspathEntry)iterator.next();
                        return BundleManifestUtils.createNewManifestInFolder(BundleManifestUtils.findResource(project, entry.getPath()), isTestManifest);
                    }
                    break block4;
                }
                return BundleManifestUtils.createNewManifestInFolder((IResource)project, isTestManifest);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    private static IFile createNewManifestInFolder(IResource resource, boolean isTestManifest) throws CoreException {
        String manifestFilePath = "META-INF/" + (isTestManifest ? "TEST.MF" : "MANIFEST.MF");
        IFile manifestFile = null;
        if (resource instanceof IFolder) {
            manifestFile = ((IFolder)resource).getFile(manifestFilePath);
        } else if (resource instanceof IProject) {
            manifestFile = ((IProject)resource).getFile(manifestFilePath);
        }
        if (manifestFile != null && !manifestFile.exists()) {
            if (!manifestFile.getParent().exists()) {
                ((IFolder)manifestFile.getParent()).create(true, true, (IProgressMonitor)new NullProgressMonitor());
            }
            manifestFile.create((InputStream)new ByteArrayInputStream("Manifest-Version: 1.0".getBytes()), true, (IProgressMonitor)new NullProgressMonitor());
        }
        return manifestFile;
    }

    public static int getLineNumber(IDocument document, BundleManifestHeader header, String valueSubstring) {
        if (header == null) {
            return 0;
        }
        int l = header.getLineNumber();
        while (l < header.getLineNumber() + header.getLinesSpan()) {
            try {
                IRegion lineRegion = document.getLineInformation(l);
                String lineStr = document.get(lineRegion.getOffset(), lineRegion.getLength());
                if (lineStr.indexOf(valueSubstring) >= 0) {
                    return l + 1;
                }
            }
            catch (BadLocationException badLocationException) {}
            ++l;
        }
        try {
            IRegion lineRegion = document.getLineInformation(header.getLineNumber());
            String lineStr = document.get(lineRegion.getOffset(), lineRegion.getLength());
            int l2 = header.getLineNumber() + 1;
            while (l2 < header.getLineNumber() + header.getLinesSpan()) {
                lineRegion = document.getLineInformation(l2);
                if ((lineStr = String.valueOf(lineStr) + document.get(lineRegion.getOffset() + 1, lineRegion.getLength())).indexOf(valueSubstring) >= 0) {
                    return l2;
                }
                ++l2;
            }
        }
        catch (BadLocationException badLocationException) {}
        return header.getLineNumber() + 1;
    }

    public static int getPackageLineNumber(IDocument document, BundleManifestHeader header, ManifestElement element) {
        String packageName = element.getValue();
        if (element.getDirectiveKeys() != null || element.getKeys() != null) {
            return BundleManifestUtils.getLineNumber(document, header, String.valueOf(packageName) + ";");
        }
        try {
            IRegion lineRegion = document.getLineInformation(header.getLineNumber() + header.getLinesSpan() - 1);
            String lineStr = document.get(lineRegion.getOffset(), lineRegion.getLength());
            if (lineStr.endsWith(packageName)) {
                return header.getLineNumber() + header.getLinesSpan();
            }
        }
        catch (BadLocationException badLocationException) {}
        return BundleManifestUtils.getLineNumber(document, header, String.valueOf(packageName) + ",");
    }
}

