/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.repository.internal.management;

import java.net.URI;
import java.util.Set;
import org.eclipse.virgo.repository.ArtifactDescriptor;
import org.eclipse.virgo.repository.DuplicateArtifactException;
import org.eclipse.virgo.repository.internal.ArtifactDescriptorDepository;
import org.eclipse.virgo.repository.internal.MutableRepository;
import org.eclipse.virgo.repository.internal.management.AbstractRepositoryInfo;
import org.eclipse.virgo.repository.management.ArtifactDescriptorSummary;
import org.eclipse.virgo.repository.management.ExternalStorageRepositoryInfo;
import org.osgi.framework.Version;

public class StandardExternalStorageRepositoryInfo
extends AbstractRepositoryInfo
implements ExternalStorageRepositoryInfo {
    private static final String TYPE = "external";
    private final MutableRepository repository;

    public StandardExternalStorageRepositoryInfo(String name, ArtifactDescriptorDepository depository, MutableRepository repository) {
        super(name, depository);
        this.repository = repository;
    }

    @Override
    public String getType() {
        return TYPE;
    }

    @Override
    public ArtifactDescriptorSummary publish(String artifactUri) {
        URI uri = URI.create(artifactUri);
        try {
            ArtifactDescriptor published = this.repository.publish(uri);
            ArtifactDescriptorSummary summary = null;
            if (published != null) {
                summary = new ArtifactDescriptorSummary(published.getType(), published.getName(), published.getVersion().toString());
            }
            return summary;
        }
        catch (DuplicateArtifactException dae) {
            throw new IllegalArgumentException("The artifact '" + artifactUri + "' cannot be published: it is a duplicate of existing artifact '" + dae.getOriginal().getUri() + "'");
        }
    }

    @Override
    public boolean retract(String type, String name, String version) {
        return this.repository.retract(type, name, new Version(version));
    }

    @Override
    public Set<String> getArtifactLocations(String filename) {
        return this.repository.getArtifactLocations(filename);
    }
}

