/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.build.p2tools.binaries;

import java.io.File;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.equinox.p2.publisher.AbstractPublisherApplication;
import org.eclipse.equinox.p2.publisher.IPublisherAction;
import org.eclipse.equinox.p2.publisher.PublisherInfo;
import org.eclipse.virgo.build.p2tools.binaries.VirgoBinariesAction;

public class BinaryPublisherApplication
extends AbstractPublisherApplication {
    private File binaries = null;
    private Map<String, String> permissions = null;

    protected IPublisherAction[] createActions() {
        ArrayList<VirgoBinariesAction> result = new ArrayList<VirgoBinariesAction>();
        if (this.binaries == null) {
            this.binaries = new File(this.source, "binary");
        }
        result.add(new VirgoBinariesAction(this.binaries, this.permissions));
        return result.toArray(new IPublisherAction[result.size()]);
    }

    protected void processParameter(String arg, String parameter, PublisherInfo pinfo) throws URISyntaxException {
        super.processParameter(arg, parameter, pinfo);
        if (arg.equalsIgnoreCase("-chmod")) {
            this.permissions = this.parseChmodValues(parameter);
        }
    }

    Map<String, String> parseChmodValues(String parameter) {
        HashMap<String, String> result = new HashMap<String, String>();
        if (parameter != null && !parameter.isEmpty()) {
            String[] permissionsMapping;
            String[] stringArray = permissionsMapping = parameter.split(",");
            int n = permissionsMapping.length;
            int n2 = 0;
            while (n2 < n) {
                String mapping = stringArray[n2];
                String[] splitMapping = mapping.split("#");
                if (splitMapping.length == 2 && this.isLocationValid(splitMapping[0])) {
                    result.put(splitMapping[0], splitMapping[1]);
                }
                ++n2;
            }
        }
        return result;
    }

    boolean isLocationValid(String location) {
        String[] targetDetails = location.split("@");
        return targetDetails != null && targetDetails.length == 2 && !targetDetails[0].isEmpty() && !targetDetails[1].isEmpty();
    }
}

