/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.build.p2tools.binaries;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.internal.p2.metadata.ArtifactKey;
import org.eclipse.equinox.internal.p2.publisher.Messages;
import org.eclipse.equinox.p2.metadata.IArtifactKey;
import org.eclipse.equinox.p2.metadata.IProvidedCapability;
import org.eclipse.equinox.p2.metadata.MetadataFactory;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.publisher.AbstractPublisherAction;
import org.eclipse.equinox.p2.publisher.IPublisherInfo;
import org.eclipse.equinox.p2.publisher.IPublisherResult;
import org.eclipse.equinox.p2.repository.artifact.IArtifactDescriptor;
import org.eclipse.equinox.spi.p2.publisher.PublisherHelper;

public class VirgoBinariesAction
extends AbstractPublisherAction {
    private static final String NATIVE_TOUCHPOINT = "org.eclipse.equinox.p2.native";
    private static final Version DEFAULT_VERSION = Version.createOSGi((int)1, (int)0, (int)0);
    private final File sourceLocation;
    private final Object monitor = new Object();
    private final Map<String, String> args;

    public VirgoBinariesAction(File sourceLocation, Map<String, String> args) {
        this.sourceLocation = sourceLocation;
        this.args = args;
    }

    public VirgoBinariesAction(File sourceLocation) {
        this(sourceLocation, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IStatus perform(IPublisherInfo publisherInfo, IPublisherResult results, IProgressMonitor monitor) {
        if (this.sourceLocation == null) {
            throw new IllegalStateException(Messages.exception_noBundlesOrLocations);
        }
        Object object = this.monitor;
        synchronized (object) {
            this.setPublisherInfo(publisherInfo);
            try {
                File binary = this.getFirstBinaryFileFrom(this.sourceLocation);
                if (binary != null) {
                    this.publishBinaryIU(binary, publisherInfo, results, monitor);
                }
            }
            catch (OperationCanceledException operationCanceledException) {
                return Status.CANCEL_STATUS;
            }
        }
        return Status.OK_STATUS;
    }

    private File getFirstBinaryFileFrom(File source) {
        File[] binaries = source.listFiles();
        if (binaries == null || binaries.length == 0) {
            return null;
        }
        return binaries[0];
    }

    private void publishBinaryIU(File binary, IPublisherInfo publisherInfo, IPublisherResult results, IProgressMonitor monitor) {
        MetadataFactory.InstallableUnitDescription iuDescription = this.createBinaryIUDescriptionShell(binary.getName());
        this.addArtifactToIUDescription(binary, publisherInfo, iuDescription);
        this.setTouchpointInstructionsToIUDescription(iuDescription);
        results.addIU(MetadataFactory.createInstallableUnit((MetadataFactory.InstallableUnitDescription)iuDescription), "root");
    }

    private void setTouchpointInstructionsToIUDescription(MetadataFactory.InstallableUnitDescription iuDescription) {
        String chmodTouchpointData = this.getCHMODConfiguration();
        HashMap<String, String> touchpointData = new HashMap<String, String>();
        touchpointData.put("install", "unzip(source:@artifact, target:${installFolder}/);" + chmodTouchpointData + "remove(path:${artifact.location});");
        touchpointData.put("uninstall", "cleanupzip(source:@artifact, target:${installFolder}/);");
        iuDescription.addTouchpointData(MetadataFactory.createTouchpointData(touchpointData));
    }

    private String getCHMODConfiguration() {
        if (this.args != null && !this.args.isEmpty()) {
            StringBuilder chmodTouchpointData = new StringBuilder();
            for (String location : this.args.keySet()) {
                String[] targetDetails = location.split("@");
                String targetFile = targetDetails[0];
                String targetDir = targetDetails[1];
                String permission = this.args.get(location);
                chmodTouchpointData.append("chmod(targetDir:${installFolder}" + targetDir + ",targetFile:" + targetFile + ",permissions:" + permission + ");");
            }
            return chmodTouchpointData.toString();
        }
        return "";
    }

    private void addArtifactToIUDescription(File binary, IPublisherInfo publisherInfo, MetadataFactory.InstallableUnitDescription iuDescription) {
        ArrayList<ArtifactKey> binaryArtifacts = new ArrayList<ArtifactKey>();
        ArtifactKey key = new ArtifactKey("binary", binary.getName(), DEFAULT_VERSION);
        IArtifactDescriptor binaryDescriptor = PublisherHelper.createArtifactDescriptor((IPublisherInfo)publisherInfo, (IArtifactKey)key, (File)binary);
        this.publishArtifact(binaryDescriptor, binary, publisherInfo);
        binaryArtifacts.add(key);
        iuDescription.setArtifacts(binaryArtifacts.toArray(new IArtifactKey[binaryArtifacts.size()]));
    }

    private MetadataFactory.InstallableUnitDescription createBinaryIUDescriptionShell(String iuId) {
        MetadataFactory.InstallableUnitDescription iuDescription = new MetadataFactory.InstallableUnitDescription();
        iuDescription.setId(iuId);
        iuDescription.setVersion(DEFAULT_VERSION);
        ArrayList<IProvidedCapability> providedCapabilities = new ArrayList<IProvidedCapability>();
        IProvidedCapability p2IUCapability = MetadataFactory.createProvidedCapability((String)"org.eclipse.equinox.p2.iu", (String)iuDescription.getId(), (Version)DEFAULT_VERSION);
        providedCapabilities.add(p2IUCapability);
        iuDescription.setCapabilities(providedCapabilities.toArray(new IProvidedCapability[providedCapabilities.size()]));
        iuDescription.setTouchpointType(MetadataFactory.createTouchpointType((String)NATIVE_TOUCHPOINT, (Version)DEFAULT_VERSION));
        return iuDescription;
    }
}

