/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.kernel.userregion.internal.equinox;

import java.io.IOException;
import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.IllegalClassFormatException;
import java.lang.reflect.Field;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;
import java.sql.Driver;
import java.sql.DriverManager;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.osgi.baseadaptor.BaseData;
import org.eclipse.osgi.baseadaptor.bundlefile.BundleEntry;
import org.eclipse.osgi.baseadaptor.loader.BaseClassLoader;
import org.eclipse.osgi.baseadaptor.loader.ClasspathEntry;
import org.eclipse.osgi.baseadaptor.loader.ClasspathManager;
import org.eclipse.osgi.framework.adaptor.ClassLoaderDelegate;
import org.eclipse.osgi.internal.baseadaptor.DefaultClassLoader;
import org.eclipse.osgi.service.resolver.PlatformAdmin;
import org.eclipse.virgo.kernel.osgi.framework.ExtendedClassNotFoundException;
import org.eclipse.virgo.kernel.osgi.framework.ExtendedNoClassDefFoundError;
import org.eclipse.virgo.kernel.osgi.framework.InstrumentableClassLoader;
import org.eclipse.virgo.kernel.osgi.framework.OsgiFrameworkUtils;
import org.eclipse.virgo.kernel.userregion.internal.equinox.EquinoxUtils;
import org.eclipse.virgo.medic.log.EntryExitTrace;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class KernelBundleClassLoader
extends DefaultClassLoader
implements InstrumentableClassLoader {
    private static final String[] EXCLUDED_PACKAGES;
    private static final String HEADER_INSTRUMENT_PACKAGE = "Instrument-Package";
    private static final Logger LOGGER;
    private final List<ClassFileTransformer> classFileTransformers = new CopyOnWriteArrayList<ClassFileTransformer>();
    private final String[] instrumentedPackages;
    private final String[] classpath;
    private final String bundleScope;
    private final Set<Class<Driver>> loadedDriverClasses = new HashSet<Class<Driver>>();
    private final Object monitor = new Object();
    private volatile boolean instrumented;
    private static transient /* synthetic */ EntryExitTrace ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance;

    static {
        ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance = EntryExitTrace.ajc$createAspectInstance((String)"org.eclipse.virgo.kernel.userregion.internal.equinox.KernelBundleClassLoader");
        EXCLUDED_PACKAGES = new String[]{"java.", "javax.", "sun.", "oracle."};
        LOGGER = LoggerFactory.getLogger(KernelBundleClassLoader.class);
    }

    KernelBundleClassLoader(ClassLoader parent, ClassLoaderDelegate delegate, ProtectionDomain domain, BaseData bundledata, String[] classpath) {
        super(parent, delegate, domain, bundledata, classpath);
        this.classpath = classpath;
        this.bundleScope = OsgiFrameworkUtils.getScopeName((Bundle)bundledata.getBundle());
        this.instrumentedPackages = this.findInstrumentedPackages(bundledata.getBundle());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addClassFileTransformer(ClassFileTransformer transformer) {
        Bundle[] bundles;
        this.instrumented = true;
        List<ClassFileTransformer> list = this.classFileTransformers;
        synchronized (list) {
            if (this.classFileTransformers.contains(transformer)) {
                return;
            }
            this.classFileTransformers.add(transformer);
        }
        Bundle[] bundleArray = bundles = this.getDependencyBundles(false);
        int n = bundles.length;
        int n2 = 0;
        while (n2 < n) {
            ClassLoader bundleClassLoader;
            Bundle bundle = bundleArray[n2];
            if (this.propagateInstrumentationTo(bundle) && (bundleClassLoader = this.getBundleClassLoader(bundle)) instanceof KernelBundleClassLoader) {
                ((KernelBundleClassLoader)((Object)bundleClassLoader)).addClassFileTransformer(transformer);
            }
            ++n2;
        }
    }

    private ClassLoader getBundleClassLoader(Bundle bundle) {
        return EquinoxUtils.getBundleClassLoader(bundle);
    }

    protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        try {
            Class loadedClass = super.loadClass(name, resolve);
            this.storeClassIfDriver(loadedClass);
            return loadedClass;
        }
        catch (ClassNotFoundException e) {
            throw new ExtendedClassNotFoundException((ClassLoader)((Object)this), e);
        }
        catch (NoClassDefFoundError e) {
            throw new ExtendedNoClassDefFoundError((ClassLoader)((Object)this), e);
        }
    }

    public boolean isInstrumented() {
        return this.instrumented;
    }

    public int getClassFileTransformerCount() {
        return this.classFileTransformers.size();
    }

    private String[] findInstrumentedPackages(Bundle bundle) {
        String headerValue = (String)bundle.getHeaders().get(HEADER_INSTRUMENT_PACKAGE);
        if (headerValue == null || headerValue.length() == 0) {
            return new String[0];
        }
        String[] vals = headerValue.split(",");
        String[] packageNames = new String[vals.length];
        int x = 0;
        while (x < packageNames.length) {
            packageNames[x] = vals[x].trim();
            ++x;
        }
        return packageNames;
    }

    private boolean propagateInstrumentationTo(Bundle bundle) {
        return !EquinoxUtils.isSystemBundle(bundle) && this.bundleScope != null && this.bundleScope.equals(OsgiFrameworkUtils.getScopeName((Bundle)bundle));
    }

    private boolean shouldInstrument(String className) {
        return this.includedForInstrumentation(className) && !this.excludedFromInstrumentation(className);
    }

    private boolean includedForInstrumentation(String className) {
        if (this.instrumentedPackages.length == 0) {
            return true;
        }
        String[] stringArray = this.instrumentedPackages;
        int n = this.instrumentedPackages.length;
        int n2 = 0;
        while (n2 < n) {
            String instrumentedPackage = stringArray[n2];
            if (className.startsWith(instrumentedPackage)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private boolean excludedFromInstrumentation(String className) {
        String[] stringArray = EXCLUDED_PACKAGES;
        int n = EXCLUDED_PACKAGES.length;
        int n2 = 0;
        while (n2 < n) {
            String excludedPackage = stringArray[n2];
            if (className.startsWith(excludedPackage)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public ThrowAwayClassLoader createThrowAway() {
        final ClasspathManager manager = new ClasspathManager(this.manager.getBaseData(), this.classpath, (BaseClassLoader)this);
        manager.initialize();
        return AccessController.doPrivileged(new PrivilegedAction<ThrowAwayClassLoader>(){
            private static transient /* synthetic */ EntryExitTrace ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance;

            @Override
            public ThrowAwayClassLoader run() {
                return new ThrowAwayClassLoader(manager);
            }

            public static /* synthetic */ EntryExitTrace ajc$org_eclipse_virgo_medic_log_EntryExitTrace$localAspectOf() {
                return ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance;
            }

            static {
                ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance = EntryExitTrace.ajc$createAspectInstance((String)"org.eclipse.virgo.kernel.userregion.internal.equinox.KernelBundleClassLoader$1");
            }
        });
    }

    public Class<?> defineClass(String name, byte[] classbytes, ClasspathEntry classpathEntry, BundleEntry entry) {
        byte[] transformedBytes = classbytes;
        if (this.shouldInstrument(name)) {
            for (ClassFileTransformer transformer : this.classFileTransformers) {
                try {
                    String transformName = name.replaceAll("\\.", "/");
                    byte[] transform = transformer.transform((ClassLoader)((Object)this), transformName, null, this.domain, transformedBytes);
                    if (transform == null) continue;
                    transformedBytes = transform;
                }
                catch (IllegalClassFormatException e) {
                    throw new ClassFormatError("Error reading class from bundle entry '" + entry.getName() + "'. " + e.getMessage());
                }
            }
        }
        try {
            Class definedClass = super.defineClass(name, transformedBytes, classpathEntry, entry);
            this.storeClassIfDriver(definedClass);
            return definedClass;
        }
        catch (NoClassDefFoundError e) {
            throw new ExtendedNoClassDefFoundError((ClassLoader)((Object)this), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void storeClassIfDriver(Class<?> candidateClass) {
        if (Driver.class.isAssignableFrom(candidateClass)) {
            Object object = this.monitor;
            synchronized (object) {
                this.loadedDriverClasses.add(candidateClass);
            }
        }
    }

    public void close() {
        this.clearJdbcDrivers();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearJdbcDrivers() {
        HashSet<Class<Driver>> localLoadedDriverClasses;
        Class<DriverManager> clazz = this.monitor;
        synchronized (clazz) {
            localLoadedDriverClasses = new HashSet<Class<Driver>>(this.loadedDriverClasses);
        }
        clazz = DriverManager.class;
        synchronized (DriverManager.class) {
            try {
                Field writeDriversField = DriverManager.class.getDeclaredField("writeDrivers");
                writeDriversField.setAccessible(true);
                Vector writeDrivers = (Vector)writeDriversField.get(null);
                Iterator driverElements = writeDrivers.iterator();
                while (driverElements.hasNext()) {
                    Object driverObj = driverElements.next();
                    Field driverField = driverObj.getClass().getDeclaredField("driver");
                    driverField.setAccessible(true);
                    if (!localLoadedDriverClasses.contains(driverField.get(driverObj).getClass())) continue;
                    driverElements.remove();
                }
                Vector readDrivers = (Vector)writeDrivers.clone();
                Field readDriversField = DriverManager.class.getDeclaredField("readDrivers");
                readDriversField.setAccessible(true);
                readDriversField.set(null, readDrivers);
            }
            catch (Exception e) {
                LOGGER.warn("Failure when clearing JDBC drivers for " + (Object)((Object)this), (Throwable)e);
            }
            return;
        }
    }

    public String toString() {
        return String.format("%s: [bundle=%s]", ((Object)((Object)this)).getClass().getSimpleName(), this.delegate);
    }

    private Bundle[] getDependencyBundles(boolean includeDependenciesFragments) {
        Bundle bundle = this.manager.getBaseData().getBundle();
        BundleContext systemBundleContext = this.getBundleContext();
        PlatformAdmin serverAdmin = this.getPlatformAdmin();
        Bundle[] deps = EquinoxUtils.getDirectDependencies(bundle, systemBundleContext, serverAdmin, includeDependenciesFragments);
        return deps;
    }

    private BundleContext getBundleContext() {
        return this.manager.getBaseData().getAdaptor().getContext();
    }

    private PlatformAdmin getPlatformAdmin() {
        return this.manager.getBaseData().getAdaptor().getPlatformAdmin();
    }

    static /* synthetic */ Class access$2(KernelBundleClassLoader kernelBundleClassLoader, String string) {
        return ((ClassLoader)((Object)kernelBundleClassLoader)).findLoadedClass(string);
    }

    public static /* synthetic */ EntryExitTrace ajc$org_eclipse_virgo_medic_log_EntryExitTrace$localAspectOf() {
        return ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class ThrowAwayClassLoader
    extends ClassLoader {
        private final ConcurrentMap<String, Class<?>> loadedClasses = new ConcurrentHashMap();
        private final ClasspathManager manager;
        private static transient /* synthetic */ EntryExitTrace ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance;

        private ThrowAwayClassLoader(ClasspathManager manager) {
            this.manager = manager;
        }

        @Override
        public Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
            if (!KernelBundleClassLoader.this.shouldInstrument(name)) {
                return KernelBundleClassLoader.this.loadClass(name, resolve);
            }
            Class<?> cls = KernelBundleClassLoader.access$2(KernelBundleClassLoader.this, name);
            if (cls == null && (cls = (Class)this.loadedClasses.get(name)) == null && (cls = this.findClassInternal(name, true)) == null) {
                cls = KernelBundleClassLoader.this.loadClass(name, resolve);
            }
            if (cls == null) {
                throw new ClassNotFoundException(name);
            }
            if (resolve) {
                this.resolveClass(cls);
            }
            this.loadedClasses.putIfAbsent(name, cls);
            return cls;
        }

        Class<?> findClassInternal(String name, boolean traverseDependencies) {
            byte[] bytes;
            String path = name.replaceAll("\\.", "/").concat(".class");
            BundleEntry entry = this.manager.findLocalEntry(path);
            if (entry == null) {
                if (traverseDependencies) {
                    return this.findClassFromImport(name);
                }
                return null;
            }
            try {
                bytes = entry.getBytes();
            }
            catch (IOException iOException) {
                bytes = null;
            }
            return bytes == null ? null : this.defineClass(name, bytes, 0, bytes.length);
        }

        private Class<?> findClassFromImport(String name) {
            Bundle[] deps;
            Bundle[] bundleArray = deps = KernelBundleClassLoader.this.getDependencyBundles(false);
            int n = deps.length;
            int n2 = 0;
            while (n2 < n) {
                Bundle dep = bundleArray[n2];
                ClassLoader depClassLoader = KernelBundleClassLoader.this.getBundleClassLoader(dep);
                if (depClassLoader instanceof KernelBundleClassLoader) {
                    KernelBundleClassLoader pbcl = (KernelBundleClassLoader)((Object)depClassLoader);
                    Class loadedClass = pbcl.publicFindLoaded(name);
                    if (loadedClass != null) {
                        return loadedClass;
                    }
                    ThrowAwayClassLoader throwAway = pbcl.createThrowAway();
                    Class<?> cls = throwAway.findClassInternal(name, false);
                    if (cls != null) {
                        return cls;
                    }
                }
                ++n2;
            }
            return null;
        }

        @Override
        public URL getResource(String name) {
            return KernelBundleClassLoader.this.getResource(name);
        }

        @Override
        public Enumeration<URL> getResources(String name) throws IOException {
            return KernelBundleClassLoader.this.getResources(name);
        }

        public static /* synthetic */ EntryExitTrace ajc$org_eclipse_virgo_medic_log_EntryExitTrace$localAspectOf() {
            return ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance;
        }

        static {
            ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance = EntryExitTrace.ajc$createAspectInstance((String)"org.eclipse.virgo.kernel.userregion.internal.equinox.KernelBundleClassLoader$ThrowAwayClassLoader");
        }
    }
}

