/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.http;

import java.io.IOException;
import java.net.URL;
import java.net.URLConnection;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import org.osgi.framework.Bundle;

public class SecureAction {
    private AccessControlContext controlContext = AccessController.getContext();

    public URL getBundleResource(final Bundle bundle, final String name) {
        if (System.getSecurityManager() == null) {
            return bundle.getResource(name);
        }
        return (URL)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return bundle.getResource(name);
            }
        }, this.controlContext);
    }

    public URLConnection openURL(final URL url) throws IOException {
        if (System.getSecurityManager() == null) {
            return this.open(url);
        }
        try {
            return (URLConnection)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws IOException {
                    return SecureAction.this.open(url);
                }
            }, this.controlContext);
        }
        catch (PrivilegedActionException ex) {
            throw (IOException)ex.getException();
        }
    }

    URLConnection open(URL url) throws IOException {
        URLConnection connection = url.openConnection();
        connection.connect();
        return connection;
    }

    public String getProperty(final String property, final String def) {
        if (System.getSecurityManager() == null) {
            return System.getProperty(property, def);
        }
        return (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return System.getProperty(property, def);
            }
        }, this.controlContext);
    }
}

