/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.indirection;

import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Vector;
import org.eclipse.persistence.descriptors.changetracking.CollectionChangeEvent;
import org.eclipse.persistence.descriptors.changetracking.CollectionChangeTracker;
import org.eclipse.persistence.indirection.IndirectCollection;
import org.eclipse.persistence.indirection.ValueHolder;
import org.eclipse.persistence.indirection.ValueHolderInterface;
import org.eclipse.persistence.indirection.WeavedAttributeValueHolderInterface;
import org.eclipse.persistence.internal.descriptors.changetracking.AttributeChangeListener;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.indirection.UnitOfWorkQueryValueHolder;
import org.eclipse.persistence.internal.indirection.UnitOfWorkValueHolder;
import org.eclipse.persistence.mappings.CollectionMapping;

public class IndirectList
extends Vector
implements CollectionChangeTracker,
IndirectCollection {
    protected volatile Vector delegate;
    protected ValueHolderInterface valueHolder;
    private transient PropertyChangeListener changeListener;
    private transient String attributeName;
    private transient List addedElements;
    private transient List removedElements;
    protected int initialCapacity;
    protected boolean isRegistered;
    private boolean isListOrderBrokenInDb;
    private boolean useLazyInstantiation = true;

    public IndirectList() {
        super(0, 0);
        this.initialCapacity = 10;
    }

    public IndirectList(int initialCapacity) {
        super(0, 0);
        this.initialCapacity = initialCapacity;
    }

    public IndirectList(int initialCapacity, int capacityIncrement) {
        super(0, capacityIncrement);
        this.initialCapacity = initialCapacity;
    }

    public IndirectList(Collection collection) {
        super(0);
        this.valueHolder = new ValueHolder(new Vector(collection));
    }

    @Override
    public void add(int index, Object element) {
        this.getDelegate().add(index, element);
        this.raiseAddChangeEvent(element, index);
    }

    protected void raiseAddChangeEvent(Object element, Integer index) {
        this.raiseAddChangeEvent(element, index, false);
    }

    protected void raiseAddChangeEvent(Object element, Integer index, boolean isSet) {
        if (this.hasTrackedPropertyChangeListener()) {
            this._persistence_getPropertyChangeListener().propertyChange(new CollectionChangeEvent(this, this.getTrackedAttributeName(), this, element, CollectionChangeEvent.ADD, index, isSet, true));
        }
        if (this.hasBeenRegistered()) {
            ((UnitOfWorkQueryValueHolder)this.getValueHolder()).updateForeignReferenceSet(element, null);
        }
    }

    protected void raiseRemoveChangeEvent(Object element, Integer index) {
        this.raiseRemoveChangeEvent(element, index, false);
    }

    protected void raiseRemoveChangeEvent(Object element, Integer index, boolean isSet) {
        if (this.hasTrackedPropertyChangeListener()) {
            this._persistence_getPropertyChangeListener().propertyChange(new CollectionChangeEvent(this, this.getTrackedAttributeName(), this, element, CollectionChangeEvent.REMOVE, index, isSet, true));
        }
        if (this.hasBeenRegistered()) {
            ((UnitOfWorkQueryValueHolder)this.getValueHolder()).updateForeignReferenceRemove(element);
        }
    }

    @Override
    public boolean add(Object element) {
        if (!this.isRegistered) {
            return this.getDelegate().add(element);
        }
        boolean added = true;
        if (this.shouldAvoidInstantiation()) {
            if (this.hasRemovedElements() && this.getRemovedElements().contains(element)) {
                this.getRemovedElements().remove(element);
            } else {
                if (this.getAddedElements().contains(element)) {
                    return false;
                }
                this.getAddedElements().add(element);
            }
        } else {
            added = this.getDelegate().add(element);
        }
        this.raiseAddChangeEvent(element, null);
        return added;
    }

    @Override
    public boolean addAll(int index, Collection c) {
        Iterator objects = c.iterator();
        if (this.hasBeenRegistered() || this.hasTrackedPropertyChangeListener()) {
            while (objects.hasNext()) {
                this.add(index, objects.next());
                ++index;
            }
            return true;
        }
        return this.getDelegate().addAll(index, c);
    }

    @Override
    public boolean addAll(Collection c) {
        if (this.hasBeenRegistered() || this.hasTrackedPropertyChangeListener()) {
            Iterator objects = c.iterator();
            while (objects.hasNext()) {
                this.add(objects.next());
            }
            return true;
        }
        return this.getDelegate().addAll(c);
    }

    public void addElement(Object obj) {
        this.add(obj);
    }

    protected Vector buildDelegate() {
        int index;
        int size;
        Vector delegate = (Vector)this.getValueHolder().getValue();
        if (delegate == null) {
            delegate = new Vector(this.initialCapacity, this.capacityIncrement);
        }
        while (delegate instanceof IndirectList) {
            if (((IndirectList)delegate).isListOrderBrokenInDb()) {
                this.isListOrderBrokenInDb = true;
            }
            delegate = ((IndirectList)delegate).getDelegate();
        }
        if (this.hasAddedElements()) {
            size = this.getAddedElements().size();
            index = 0;
            while (index < size) {
                Object element = ((List)this.getAddedElements()).get(index);
                if (!delegate.contains(element)) {
                    delegate.add(element);
                }
                ++index;
            }
            this.addedElements = null;
        }
        if (this.hasRemovedElements()) {
            size = this.getRemovedElements().size();
            index = 0;
            while (index < size) {
                delegate.remove(((List)this.getRemovedElements()).get(index));
                ++index;
            }
            this.removedElements = null;
        }
        return delegate;
    }

    @Override
    public int capacity() {
        return this.getDelegate().capacity();
    }

    @Override
    public void clear() {
        this.removeAllElements();
    }

    @Override
    public void clearDeferredChanges() {
        this.addedElements = null;
        this.removedElements = null;
    }

    @Override
    public synchronized Object clone() {
        IndirectList result = (IndirectList)super.clone();
        result.delegate = (Vector)this.getDelegate().clone();
        result.valueHolder = new ValueHolder(result.delegate);
        result.attributeName = null;
        result.changeListener = null;
        return result;
    }

    @Override
    public boolean contains(Object element) {
        if (this.hasAddedElements() && this.getAddedElements().contains(element)) {
            return true;
        }
        if (this.hasRemovedElements() && this.getRemovedElements().contains(element)) {
            return false;
        }
        return this.getDelegate().contains(element);
    }

    @Override
    public boolean containsAll(Collection c) {
        return this.getDelegate().containsAll(c);
    }

    @Override
    public synchronized void copyInto(Object[] anArray) {
        this.getDelegate().copyInto(anArray);
    }

    public Object elementAt(int index) {
        return this.getDelegate().elementAt(index);
    }

    public Enumeration elements() {
        return this.getDelegate().elements();
    }

    @Override
    public void ensureCapacity(int minCapacity) {
        this.getDelegate().ensureCapacity(minCapacity);
    }

    @Override
    public boolean equals(Object o) {
        return this.getDelegate().equals(o);
    }

    public Object firstElement() {
        return this.getDelegate().firstElement();
    }

    @Override
    public Object get(int index) {
        return this.getDelegate().get(index);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Vector getDelegate() {
        if (this.delegate == null) {
            IndirectList indirectList = this;
            synchronized (indirectList) {
                if (this.delegate == null) {
                    this.delegate = this.buildDelegate();
                }
            }
        }
        return this.delegate;
    }

    @Override
    public Object getDelegateObject() {
        return this.getDelegate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ValueHolderInterface getValueHolder() {
        if (this.valueHolder == null) {
            IndirectList indirectList = this;
            synchronized (indirectList) {
                if (this.valueHolder == null) {
                    this.valueHolder = new ValueHolder(new Vector(this.initialCapacity, this.capacityIncrement));
                }
            }
        }
        return this.valueHolder;
    }

    public boolean hasBeenRegistered() {
        return this.getValueHolder() instanceof UnitOfWorkQueryValueHolder;
    }

    @Override
    public int hashCode() {
        return this.getDelegate().hashCode();
    }

    @Override
    public int indexOf(Object elem) {
        return this.getDelegate().indexOf(elem);
    }

    @Override
    public int indexOf(Object elem, int index) {
        return this.getDelegate().indexOf(elem, index);
    }

    public void insertElementAt(Object obj, int index) {
        this.getDelegate().insertElementAt(obj, index);
        this.raiseAddChangeEvent(obj, index);
    }

    @Override
    public boolean isEmpty() {
        return this.getDelegate().isEmpty();
    }

    @Override
    public boolean isInstantiated() {
        return this.getValueHolder().isInstantiated();
    }

    @Override
    public Iterator iterator() {
        return this.listIterator(0);
    }

    public Object lastElement() {
        return this.getDelegate().lastElement();
    }

    @Override
    public int lastIndexOf(Object elem) {
        return this.getDelegate().lastIndexOf(elem);
    }

    @Override
    public int lastIndexOf(Object elem, int index) {
        return this.getDelegate().lastIndexOf(elem, index);
    }

    @Override
    public ListIterator listIterator() {
        return this.listIterator(0);
    }

    @Override
    public ListIterator listIterator(int index) {
        return new ListIterator(index){
            ListIterator delegateIterator;
            Object currentObject;
            {
                this.delegateIterator = IndirectList.this.getDelegate().listIterator(n);
            }

            @Override
            public boolean hasNext() {
                return this.delegateIterator.hasNext();
            }

            @Override
            public boolean hasPrevious() {
                return this.delegateIterator.hasPrevious();
            }

            @Override
            public int previousIndex() {
                return this.delegateIterator.previousIndex();
            }

            @Override
            public int nextIndex() {
                return this.delegateIterator.nextIndex();
            }

            @Override
            public Object next() {
                this.currentObject = this.delegateIterator.next();
                return this.currentObject;
            }

            public Object previous() {
                this.currentObject = this.delegateIterator.previous();
                return this.currentObject;
            }

            @Override
            public void remove() {
                this.delegateIterator.remove();
                IndirectList.this.raiseRemoveChangeEvent(this.currentObject, this.delegateIterator.nextIndex());
            }

            public void set(Object object) {
                this.delegateIterator.set(object);
                Integer index = this.delegateIterator.previousIndex();
                IndirectList.this.raiseRemoveChangeEvent(this.currentObject, index, true);
                IndirectList.this.raiseAddChangeEvent(object, index, true);
            }

            public void add(Object object) {
                this.delegateIterator.add(object);
                IndirectList.this.raiseAddChangeEvent(object, this.delegateIterator.previousIndex());
            }
        };
    }

    @Override
    public Object remove(int index) {
        Object value = this.getDelegate().remove(index);
        this.raiseRemoveChangeEvent(value, index);
        return value;
    }

    @Override
    public boolean remove(Object element) {
        if (!this.isRegistered) {
            return this.getDelegate().remove(element);
        }
        if (this.shouldAvoidInstantiation()) {
            if (this.hasAddedElements() && this.getAddedElements().contains(element)) {
                this.getAddedElements().remove(element);
            } else {
                if (this.getRemovedElements().contains(element)) {
                    return false;
                }
                this.getRemovedElements().add(element);
            }
            this.raiseRemoveChangeEvent(element, null);
            return true;
        }
        int index = this.getDelegate().indexOf(element);
        if (index > -1) {
            this.getDelegate().remove(index);
            this.raiseRemoveChangeEvent(element, index);
            return true;
        }
        return false;
    }

    @Override
    public boolean removeAll(Collection c) {
        if (this.hasBeenRegistered() || this.hasTrackedPropertyChangeListener()) {
            boolean hasChanged = false;
            Iterator objects = c.iterator();
            while (objects.hasNext()) {
                hasChanged |= this.remove(objects.next());
            }
            return hasChanged;
        }
        return this.getDelegate().removeAll(c);
    }

    @Override
    public void removeAllElements() {
        if (this.hasBeenRegistered() || this.hasTrackedPropertyChangeListener()) {
            Iterator objects = this.iterator();
            while (objects.hasNext()) {
                objects.next();
                objects.remove();
            }
            return;
        }
        this.getDelegate().removeAllElements();
    }

    @Override
    public boolean removeElement(Object obj) {
        return this.remove(obj);
    }

    @Override
    public void removeElementAt(int index) {
        this.remove(index);
    }

    @Override
    public boolean retainAll(Collection c) {
        if (this.hasBeenRegistered() || this.hasTrackedPropertyChangeListener()) {
            Iterator objects = this.getDelegate().iterator();
            while (objects.hasNext()) {
                Object object = objects.next();
                if (c.contains(object)) continue;
                objects.remove();
                this.raiseRemoveChangeEvent(object, null);
            }
            return true;
        }
        return this.getDelegate().retainAll(c);
    }

    @Override
    public Object set(int index, Object element) {
        Object oldValue = this.getDelegate().set(index, element);
        Integer bigIntIndex = index;
        this.raiseRemoveChangeEvent(oldValue, bigIntIndex, true);
        this.raiseAddChangeEvent(element, bigIntIndex, true);
        return oldValue;
    }

    public void setElementAt(Object obj, int index) {
        this.set(index, obj);
    }

    @Override
    public void setSize(int newSize) {
        if ((this.hasBeenRegistered() || this.hasTrackedPropertyChangeListener()) && newSize > this.size()) {
            int index = this.size();
            while (index > newSize) {
                this.remove(index - 1);
                --index;
            }
        }
        this.getDelegate().setSize(newSize);
    }

    @Override
    public void setUseLazyInstantiation(boolean useLazyInstantiation) {
        this.useLazyInstantiation = useLazyInstantiation;
    }

    @Override
    public void setValueHolder(ValueHolderInterface valueHolder) {
        this.delegate = null;
        this.valueHolder = valueHolder;
        if (valueHolder instanceof UnitOfWorkQueryValueHolder) {
            this.isRegistered = true;
        }
    }

    @Override
    public int size() {
        return this.getDelegate().size();
    }

    protected boolean shouldUseLazyInstantiation() {
        return this.useLazyInstantiation;
    }

    @Override
    public List subList(int fromIndex, int toIndex) {
        return this.getDelegate().subList(fromIndex, toIndex);
    }

    @Override
    public Object[] toArray() {
        return this.getDelegate().toArray();
    }

    @Override
    public Object[] toArray(Object[] a) {
        return this.getDelegate().toArray(a);
    }

    @Override
    public String toString() {
        if (this.isInstantiated()) {
            return "{" + this.getDelegate().toString() + "}";
        }
        return "{" + Helper.getShortClassName(this.getClass()) + ": not instantiated}";
    }

    @Override
    public void trimToSize() {
        this.getDelegate().trimToSize();
    }

    @Override
    public PropertyChangeListener _persistence_getPropertyChangeListener() {
        return this.changeListener;
    }

    public boolean hasTrackedPropertyChangeListener() {
        return this.changeListener != null;
    }

    @Override
    public void _persistence_setPropertyChangeListener(PropertyChangeListener changeListener) {
        this.changeListener = changeListener;
        if (changeListener != null) {
            this.isRegistered = true;
        }
    }

    @Override
    public String getTrackedAttributeName() {
        return this.attributeName;
    }

    @Override
    public void setTrackedAttributeName(String attributeName) {
        this.attributeName = attributeName;
    }

    @Override
    public Collection getRemovedElements() {
        if (this.removedElements == null) {
            this.removedElements = new ArrayList();
        }
        return this.removedElements;
    }

    @Override
    public Collection getAddedElements() {
        if (this.addedElements == null) {
            this.addedElements = new ArrayList();
        }
        return this.addedElements;
    }

    public boolean hasAddedElements() {
        return this.addedElements != null && !this.addedElements.isEmpty();
    }

    public boolean hasRemovedElements() {
        return this.removedElements != null && !this.removedElements.isEmpty();
    }

    @Override
    public boolean hasDeferredChanges() {
        return this.hasRemovedElements() || this.hasAddedElements();
    }

    protected boolean shouldAvoidInstantiation() {
        return !this.isInstantiated() && this.shouldUseLazyInstantiation() && this._persistence_getPropertyChangeListener() instanceof AttributeChangeListener && !this.usesListOrderField() && ((WeavedAttributeValueHolderInterface)this.getValueHolder()).shouldAllowInstantiationDeferral();
    }

    protected boolean usesListOrderField() {
        if (this.valueHolder instanceof UnitOfWorkValueHolder) {
            return ((CollectionMapping)((UnitOfWorkValueHolder)this.valueHolder).getMapping()).getListOrderField() != null;
        }
        return false;
    }

    public boolean isListOrderBrokenInDb() {
        return this.isListOrderBrokenInDb;
    }

    public void setIsListOrderBrokenInDb(boolean isBroken) {
        this.isListOrderBrokenInDb = isBroken;
    }
}

