/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemini.web.tomcat.internal.loading;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.gemini.web.tomcat.internal.support.BundleFileResolver;
import org.eclipse.gemini.web.tomcat.internal.support.BundleFileResolverFactory;
import org.osgi.framework.Bundle;
import org.osgi.framework.wiring.BundleRevision;
import org.osgi.framework.wiring.BundleWire;
import org.osgi.framework.wiring.BundleWiring;

public final class BundleEntry {
    private static final String WEB_INF_DOT = "WEB-INF.";
    private static final String META_INF_DOT = "META-INF.";
    private static final String META_INF = "META-INF";
    private static final String OSGI_INF_DOT = "OSGI-INF.";
    private static final String OSGI_OPT_DOT = "OSGI-OPT.";
    private static final String PATH_SEPARATOR = "/";
    private static final String DOT = ".";
    private final String path;
    private final Bundle bundle;
    private final List<Bundle> fragments;
    private final BundleFileResolver bundleFileResolver = BundleFileResolverFactory.createBundleFileResolver();
    private final boolean checkEntryPath;
    private String bundleLocationCanonicalPath;
    private boolean isBundleLocationDirectory;

    public BundleEntry(Bundle bundle) {
        this.path = "";
        this.bundle = bundle;
        this.fragments = this.getFragments(bundle);
        this.checkEntryPath = this.checkEntryPath();
        File bundleLocation = this.bundleFileResolver.resolve(bundle);
        if (bundleLocation != null) {
            try {
                this.bundleLocationCanonicalPath = bundleLocation.getCanonicalPath();
            }
            catch (IOException iOException) {}
            if (bundleLocation.isDirectory()) {
                this.isBundleLocationDirectory = true;
            }
        }
    }

    private BundleEntry(Bundle bundle, List<Bundle> fragments, String path, boolean checkEntryPath, String bundleLocationCanonicalPath, boolean isBundleLocationDirectory) {
        this.path = path;
        this.bundle = bundle;
        this.fragments = fragments;
        this.checkEntryPath = checkEntryPath;
        this.bundleLocationCanonicalPath = bundleLocationCanonicalPath;
        this.isBundleLocationDirectory = isBundleLocationDirectory;
    }

    public Bundle getBundle() {
        return this.bundle;
    }

    public List<BundleEntry> list() {
        ArrayList<BundleEntry> entries = new ArrayList<BundleEntry>();
        Set<String> paths = this.getEntryPathsFromBundle();
        if (paths != null) {
            for (String subPath : paths) {
                entries.add(this.createBundleEntry(subPath));
            }
        }
        return entries;
    }

    private BundleEntry createBundleEntry(String path) {
        return new BundleEntry(this.bundle, this.fragments, path, this.checkEntryPath, this.bundleLocationCanonicalPath, this.isBundleLocationDirectory);
    }

    private Set<String> getEntryPathsFromBundle() {
        Set<String> paths = this.getEntryPathsFromBundle(this.bundle);
        int i = 0;
        while (i < this.fragments.size()) {
            paths.addAll(this.getEntryPathsFromBundle(this.fragments.get(i)));
            ++i;
        }
        if (paths.isEmpty()) {
            return null;
        }
        return paths;
    }

    private Set<String> getEntryPathsFromBundle(Bundle bundle) {
        Enumeration ep = bundle.getEntryPaths(this.path);
        HashSet<String> paths = new HashSet<String>();
        if (ep != null) {
            while (ep.hasMoreElements()) {
                paths.add((String)ep.nextElement());
            }
        }
        return paths;
    }

    public Map.Entry<BundleEntry, URL> getEntry(String subPath) {
        String finalPath = String.valueOf(this.path) + subPath;
        URL entryURL = this.getEntryFromBundle(finalPath);
        if (entryURL != null) {
            HashMap<BundleEntry, URL> result = new HashMap<BundleEntry, URL>();
            result.put(this.createBundleEntry(finalPath), entryURL);
            return result.entrySet().iterator().next();
        }
        return null;
    }

    private URL getEntryFromBundle(String path) {
        String searchFile;
        String searchPath;
        if (this.checkEntryPath && (this.checkNotAttemptingToAccess(path, META_INF_DOT) || this.checkNotAttemptingToAccess(path, WEB_INF_DOT) || this.checkNotAttemptingToAccess(path, OSGI_INF_DOT) || this.checkNotAttemptingToAccess(path, OSGI_OPT_DOT))) {
            return null;
        }
        if (path.endsWith(PATH_SEPARATOR) || path.length() == 0) {
            return this.bundle.getEntry(path);
        }
        int lastSlashIndex = path.lastIndexOf(PATH_SEPARATOR);
        if (lastSlashIndex == -1) {
            searchPath = PATH_SEPARATOR;
            searchFile = path;
        } else {
            searchPath = path.substring(0, lastSlashIndex);
            searchFile = path.substring(lastSlashIndex + 1);
        }
        if (searchFile.equals(DOT)) {
            return this.bundle.getEntry(path.substring(0, path.length() - 1));
        }
        Enumeration entries = this.bundle.findEntries(searchPath, searchFile, false);
        if (entries != null && entries.hasMoreElements()) {
            return (URL)entries.nextElement();
        }
        return null;
    }

    private boolean checkNotAttemptingToAccess(String path, String prefix) {
        return path.startsWith(String.valueOf(prefix) + PATH_SEPARATOR) || path.startsWith(PATH_SEPARATOR + prefix + PATH_SEPARATOR) || path.startsWith("./" + prefix + PATH_SEPARATOR);
    }

    public String getName() {
        int index;
        String name = this.path;
        if (name.endsWith(PATH_SEPARATOR)) {
            name = name.substring(0, this.path.length() - 1);
        }
        if ((index = name.lastIndexOf(PATH_SEPARATOR)) > -1) {
            name = name.substring(index + 1);
        }
        if (name.length() == 0) {
            return PATH_SEPARATOR;
        }
        return name;
    }

    public URL getURL() {
        return this.getEntryFromBundle(this.path);
    }

    public String getPath() {
        return this.path;
    }

    public static boolean isDirectory(URL url) {
        return url.getFile().endsWith(PATH_SEPARATOR);
    }

    public String toString() {
        return String.format("BundleEntry [bundle=%s,path=%s]", this.bundle, this.path);
    }

    public long getContentLength(URLConnection urlConnection) {
        long size = this.bundleFileResolver.resolveBundleEntrySize(this.bundle, this.path);
        if (size == -1L && urlConnection != null) {
            size = urlConnection.getContentLength();
        }
        return size;
    }

    private List<Bundle> getFragments(Bundle bundle) {
        ArrayList<Bundle> fragments = new ArrayList<Bundle>();
        BundleRevision bundleRevision = (BundleRevision)bundle.adapt(BundleRevision.class);
        if (bundleRevision != null) {
            BundleWiring bundleWiring = bundleRevision.getWiring();
            List bundleWires = bundleWiring.getProvidedWires("osgi.wiring.host");
            int i = 0;
            while (bundleWires != null && i < bundleWires.size()) {
                fragments.add(((BundleWire)bundleWires.get(i)).getRequirerWiring().getRevision().getBundle());
                ++i;
            }
        }
        return fragments;
    }

    private boolean checkEntryPath() {
        try {
            return new File(META_INF).getCanonicalPath().equals(new File(META_INF_DOT).getCanonicalPath());
        }
        catch (IOException iOException) {
            return true;
        }
    }

    public String getBundleLocationCanonicalPath() {
        return this.bundleLocationCanonicalPath;
    }

    public boolean isBundleLocationDirectory() {
        return this.isBundleLocationDirectory;
    }
}

