/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.kernel.userregion.internal.management;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.ZipException;
import org.eclipse.virgo.kernel.osgi.quasi.QuasiBundle;
import org.eclipse.virgo.kernel.osgi.quasi.QuasiFramework;
import org.eclipse.virgo.kernel.osgi.quasi.QuasiFrameworkFactory;
import org.eclipse.virgo.kernel.osgi.quasi.QuasiResolutionFailure;
import org.eclipse.virgo.kernel.userregion.internal.management.JMXQuasiBundle;
import org.eclipse.virgo.kernel.userregion.internal.management.JMXQuasiMinimalBundle;
import org.eclipse.virgo.kernel.userregion.internal.management.JMXQuasiResolutionFailure;
import org.eclipse.virgo.kernel.userregion.internal.management.StateDumpMXBean;
import org.eclipse.virgo.medic.log.EntryExitTrace;

public class JMXQuasiStateDump
implements StateDumpMXBean {
    private final QuasiFrameworkFactory quasiFrameworkFactory;
    private static transient /* synthetic */ EntryExitTrace ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance;

    public JMXQuasiStateDump(QuasiFrameworkFactory quasiFrameworkFactory) {
        this.quasiFrameworkFactory = quasiFrameworkFactory;
    }

    @Override
    public JMXQuasiResolutionFailure[] getUnresolvedBundleFailures(String dumpFile) {
        QuasiFramework quasiFramework = this.getQuasiFramework(dumpFile);
        ArrayList<JMXQuasiResolutionFailure> fails = new ArrayList<JMXQuasiResolutionFailure>();
        List bundles = quasiFramework.getBundles();
        for (QuasiBundle quasiBundle : bundles) {
            List diagnoses;
            if (quasiBundle.isResolved() || (diagnoses = quasiFramework.diagnose(quasiBundle.getBundleId())) == null) continue;
            for (QuasiResolutionFailure quasiResolutionFailure : diagnoses) {
                if (quasiResolutionFailure == null) continue;
                fails.add(new JMXQuasiResolutionFailure(quasiResolutionFailure));
            }
        }
        return fails.toArray(new JMXQuasiResolutionFailure[fails.size()]);
    }

    @Override
    public JMXQuasiMinimalBundle[] listBundles(String dumpFile) {
        QuasiFramework quasiFramework = this.getQuasiFramework(dumpFile);
        List bundles = quasiFramework.getBundles();
        ArrayList<JMXQuasiMinimalBundle> jmxBundles = new ArrayList<JMXQuasiMinimalBundle>();
        for (QuasiBundle minimalBundleMXBean : bundles) {
            jmxBundles.add(new JMXQuasiMinimalBundle(minimalBundleMXBean));
        }
        return jmxBundles.toArray(new JMXQuasiMinimalBundle[jmxBundles.size()]);
    }

    @Override
    public JMXQuasiBundle getBundle(String dumpFile, long bundleId) {
        if (bundleId < 0L) {
            return null;
        }
        QuasiFramework quasiFramework = this.getQuasiFramework(dumpFile);
        QuasiBundle quasiBundle = quasiFramework.getBundle(bundleId);
        return new JMXQuasiBundle(quasiBundle);
    }

    private QuasiFramework getQuasiFramework(String dumpFile) {
        File dumpDir = new File(dumpFile);
        if (dumpDir.exists() && dumpDir.isDirectory()) {
            try {
                return this.quasiFrameworkFactory.create(dumpDir);
            }
            catch (ZipException e) {
                throw new RuntimeException("Unable to extract the state dump: " + e.getMessage(), e);
            }
            catch (IOException e) {
                throw new RuntimeException("Error reading the state dump: " + e.getMessage(), e);
            }
        }
        throw new RuntimeException("Not a valid dump directory: " + dumpFile);
    }

    public static /* synthetic */ EntryExitTrace ajc$org_eclipse_virgo_medic_log_EntryExitTrace$localAspectOf() {
        return ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance;
    }

    static {
        ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance = EntryExitTrace.ajc$createAspectInstance((String)"org.eclipse.virgo.kernel.userregion.internal.management.JMXQuasiStateDump");
    }
}

