/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.ds;

import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.equinox.internal.ds.Activator;
import org.eclipse.equinox.internal.ds.Messages;
import org.eclipse.equinox.internal.ds.model.ComponentReference;
import org.eclipse.equinox.internal.ds.model.ServiceComponent;
import org.eclipse.equinox.internal.ds.model.ServiceComponentProp;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.Filter;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServicePermission;
import org.osgi.framework.ServiceReference;

public final class Reference
implements org.apache.felix.scr.Reference {
    public ComponentReference reference;
    ServiceComponentProp scp;
    String interfaceName;
    String target;
    int policy;
    int cardinalityHigh;
    int cardinalityLow;
    Vector boundServiceReferences = new Vector(1);

    Reference(ComponentReference reference, ServiceComponentProp scp, Dictionary properties) {
        this.reference = reference;
        this.scp = scp;
        this.interfaceName = reference.interfaceName;
        this.target = reference.target;
        if (properties != null) {
            this.target = (String)properties.get(String.valueOf(reference.name) + ".target");
        }
        if (this.target == null) {
            this.target = "(objectClass=" + this.interfaceName + ")";
        }
        this.policy = reference.policy;
        switch (reference.cardinality) {
            case 0: {
                this.cardinalityLow = 0;
                this.cardinalityHigh = 1;
                break;
            }
            case 1: {
                this.cardinalityLow = 0;
                this.cardinalityHigh = Integer.MAX_VALUE;
                break;
            }
            case 2: {
                this.cardinalityLow = 1;
                this.cardinalityHigh = 1;
                break;
            }
            case 3: {
                this.cardinalityLow = 1;
                this.cardinalityHigh = Integer.MAX_VALUE;
            }
        }
    }

    public String getTarget() {
        return this.target;
    }

    public void setTarget(String newTarget) {
        this.target = newTarget;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    final boolean hasProviders(Hashtable serviceReferenceTable) {
        if (System.getSecurityManager() != null && !this.scp.bc.getBundle().hasPermission((Object)new ServicePermission(this.interfaceName, "get"))) {
            return false;
        }
        try {
            ServiceReference[] serviceReferences = null;
            serviceReferences = this.scp.bc.getServiceReferences(this.interfaceName, this.target);
            if (serviceReferences == null) return false;
            if (serviceReferenceTable == null) {
                return true;
            }
            int i = 0;
            while (true) {
                if (i >= serviceReferences.length) {
                    return false;
                }
                if (serviceReferenceTable.containsKey(serviceReferences[i])) {
                    return true;
                }
                ++i;
            }
        }
        catch (InvalidSyntaxException e) {
            Activator.log(this.reference.component.bc, 2, "Reference.hasProviders(): " + NLS.bind((String)Messages.INVALID_TARGET_FILTER, (Object)this.target), e);
        }
        return false;
    }

    final boolean isRequiredFor(ServiceComponent cd) {
        return this.cardinalityLow == 1;
    }

    public boolean isRequired() {
        return this.cardinalityLow == 1;
    }

    public boolean isUnary() {
        return this.cardinalityHigh == 1;
    }

    final boolean bindNewReference(ServiceReference referenceToBind, boolean dynamicBind) {
        Object currentBoundServiceReference;
        int res;
        if (dynamicBind) {
            if (this.policy == 0) {
                return false;
            }
        } else {
            if (this.policy == 1) {
                return false;
            }
            if (this.reference.policy_option == 0) {
                return false;
            }
        }
        String[] serviceNames = (String[])referenceToBind.getProperty("objectClass");
        boolean hasName = false;
        int i = 0;
        while (i < serviceNames.length) {
            if (serviceNames[i].equals(this.interfaceName)) {
                hasName = true;
                break;
            }
            ++i;
        }
        if (!hasName) {
            return false;
        }
        if (this.reference.bind != null) {
            if (this.reference.serviceReferences.size() >= this.cardinalityHigh) {
                Object currentBoundServiceReference2;
                int res2;
                if (this.reference.policy_option == 0) {
                    return false;
                }
                if (this.reference.policy_option == 1 && (res2 = referenceToBind.compareTo(currentBoundServiceReference2 = this.reference.serviceReferences.keys().nextElement())) <= 0) {
                    return false;
                }
            }
        } else if (!dynamicBind && this.boundServiceReferences.size() >= this.cardinalityHigh && this.reference.policy_option == 1 && (res = referenceToBind.compareTo(currentBoundServiceReference = this.boundServiceReferences.elementAt(0))) <= 0) {
            return false;
        }
        try {
            Filter filter = FrameworkUtil.createFilter((String)this.target);
            return filter.match(referenceToBind);
        }
        catch (InvalidSyntaxException invalidSyntaxException) {
            return false;
        }
    }

    public boolean doSatisfy(String newTargetFilter) {
        ServiceReference[] refs = null;
        try {
            refs = this.scp.bc.getServiceReferences(this.reference.interfaceName, newTargetFilter);
        }
        catch (InvalidSyntaxException e) {
            Activator.log(this.scp.bc, 2, "[SCR] " + NLS.bind((String)Messages.INVALID_TARGET_FILTER, (Object)newTargetFilter), e);
            return false;
        }
        if (refs == null) {
            if (this.cardinalityLow > 0) {
                return false;
            }
            return this.policy != 0 || !(this.reference.bind != null ? this.reference.serviceReferences.size() > 0 : this.boundServiceReferences.size() > 0);
        }
        if (this.policy == 0) {
            if (this.reference.bind != null) {
                Enumeration keys = this.reference.serviceReferences.keys();
                while (keys.hasMoreElements()) {
                    Object serviceRef = keys.nextElement();
                    boolean found = false;
                    int i = 0;
                    while (i < refs.length) {
                        if (refs[i] == serviceRef) {
                            found = true;
                            break;
                        }
                        ++i;
                    }
                    if (found) continue;
                    return false;
                }
                if (this.cardinalityHigh > 1 && this.reference.serviceReferences.size() < refs.length) {
                    return false;
                }
            } else {
                int i = 0;
                while (i < this.boundServiceReferences.size()) {
                    Object serviceRef = this.boundServiceReferences.elementAt(i);
                    boolean found = false;
                    int j = 0;
                    while (j < refs.length) {
                        if (refs[j] == serviceRef) {
                            found = true;
                            break;
                        }
                        ++j;
                    }
                    if (!found) {
                        return false;
                    }
                    ++i;
                }
                if (this.cardinalityHigh > 1 && this.boundServiceReferences.size() < refs.length) {
                    return false;
                }
            }
        }
        return true;
    }

    final boolean dynamicUnbindReference(ServiceReference changedReference) {
        if (this.policy == 0) {
            return false;
        }
        return this.reference.serviceReferences.containsKey(changedReference);
    }

    final boolean staticUnbindReference(ServiceReference changedReference) {
        if (this.policy == 1) {
            return false;
        }
        if (this.reference.serviceReferences.containsKey(changedReference)) {
            return true;
        }
        if (this.boundServiceReferences.size() > 0) {
            return this.cardinalityHigh == 1 ? this.boundServiceReferences.elementAt(0) == changedReference : this.boundServiceReferences.contains(changedReference);
        }
        return false;
    }

    public boolean isInSatisfiedList(ServiceReference serviceReference) {
        Filter filter;
        try {
            filter = FrameworkUtil.createFilter((String)this.target);
        }
        catch (InvalidSyntaxException e) {
            Activator.log(this.reference.component.bc, 2, "Reference.isInSatisfiedList(): " + NLS.bind((String)Messages.INVALID_TARGET_FILTER, (Object)this.target), e);
            return false;
        }
        return filter.match(serviceReference);
    }

    public void setBoundServiceReferences(ServiceReference[] references) {
        if (this.policy == 1) {
            return;
        }
        this.boundServiceReferences.removeAllElements();
        if (this.cardinalityHigh == 1) {
            this.boundServiceReferences.addElement(references[0]);
        } else {
            int i = 0;
            while (i < references.length) {
                this.boundServiceReferences.addElement(references[i]);
                ++i;
            }
        }
    }

    public ServiceComponentProp[] selectProviders(Vector scps) {
        Filter filter;
        try {
            filter = FrameworkUtil.createFilter((String)this.target);
        }
        catch (InvalidSyntaxException e) {
            Activator.log(this.reference.component.bc, 2, "Reference.selectProviders(): " + NLS.bind((String)Messages.INVALID_TARGET_FILTER, (Object)this.target), e);
            return null;
        }
        Vector<ServiceComponentProp> result = new Vector<ServiceComponentProp>(2);
        int i = 0;
        while (i < scps.size()) {
            ServiceComponentProp providerSCP = (ServiceComponentProp)scps.elementAt(i);
            if (providerSCP.serviceComponent.serviceInterfaces != null && providerSCP.serviceComponent.serviceInterfaces.contains(this.interfaceName) && filter.match(providerSCP.getProperties())) {
                result.addElement(providerSCP);
            }
            ++i;
        }
        Object[] res = new ServiceComponentProp[result.size()];
        result.copyInto(res);
        return res;
    }

    public boolean isBound() {
        if (this.reference.bind != null) {
            return this.reference.serviceReferences.size() >= this.cardinalityLow;
        }
        return true;
    }

    public Vector getBoundServiceReferences() {
        return this.boundServiceReferences;
    }

    public String getBindMethodName() {
        return this.reference.bind;
    }

    public String getName() {
        return this.reference.name;
    }

    public String getServiceName() {
        return this.reference.interfaceName;
    }

    public ServiceReference[] getServiceReferences() {
        Vector result = null;
        if (this.reference.bind != null) {
            if (!this.reference.serviceReferences.isEmpty()) {
                result = new Vector(2);
                Enumeration keys = this.reference.serviceReferences.keys();
                while (keys.hasMoreElements()) {
                    result.add(keys.nextElement());
                }
            }
        } else if (!this.boundServiceReferences.isEmpty()) {
            result = (Vector)this.boundServiceReferences.clone();
        }
        if (result != null && !result.isEmpty()) {
            Object[] finalResult = new ServiceReference[result.size()];
            result.copyInto(finalResult);
            return finalResult;
        }
        return null;
    }

    public String getUnbindMethodName() {
        return this.reference.unbind;
    }

    public boolean isMultiple() {
        return this.cardinalityHigh > 1;
    }

    public boolean isOptional() {
        return this.cardinalityLow == 0;
    }

    public boolean isSatisfied() {
        if (this.cardinalityLow == 0) {
            return true;
        }
        try {
            ServiceReference[] serviceReferences = this.reference.component.bc.getServiceReferences(this.interfaceName, this.target);
            if (serviceReferences != null) {
                return true;
            }
        }
        catch (InvalidSyntaxException invalidSyntaxException) {}
        return false;
    }

    public boolean isStatic() {
        return this.policy == 0;
    }

    public String getUpdatedMethodName() {
        if (this.reference.component.isNamespaceAtLeast12()) {
            return this.reference.updated;
        }
        return null;
    }
}

