/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.expression.spel.ast;

import org.springframework.core.convert.TypeDescriptor;
import org.springframework.expression.EvaluationException;
import org.springframework.expression.TypedValue;
import org.springframework.expression.spel.ExpressionState;
import org.springframework.expression.spel.SpelEvaluationException;
import org.springframework.expression.spel.SpelMessage;
import org.springframework.expression.spel.ast.Operator;
import org.springframework.expression.spel.ast.SpelNodeImpl;
import org.springframework.expression.spel.support.BooleanTypedValue;

public class OpAnd
extends Operator {
    public OpAnd(int pos, SpelNodeImpl ... operands) {
        super("and", pos, operands);
    }

    public TypedValue getValueInternal(ExpressionState state) throws EvaluationException {
        boolean rightValue;
        boolean leftValue;
        TypedValue typedValue;
        try {
            typedValue = this.getLeftOperand().getValueInternal(state);
            this.assertTypedValueNotNull(typedValue);
            leftValue = (Boolean)state.convertValue(typedValue, TypeDescriptor.valueOf(Boolean.class));
        }
        catch (SpelEvaluationException ee) {
            ee.setPosition(this.getLeftOperand().getStartPosition());
            throw ee;
        }
        if (!leftValue) {
            return BooleanTypedValue.forValue(false);
        }
        try {
            typedValue = this.getRightOperand().getValueInternal(state);
            this.assertTypedValueNotNull(typedValue);
            rightValue = (Boolean)state.convertValue(typedValue, TypeDescriptor.valueOf(Boolean.class));
        }
        catch (SpelEvaluationException ee) {
            ee.setPosition(this.getRightOperand().getStartPosition());
            throw ee;
        }
        return BooleanTypedValue.forValue(rightValue);
    }

    private void assertTypedValueNotNull(TypedValue typedValue) {
        if (TypedValue.NULL.equals(typedValue)) {
            throw new SpelEvaluationException(SpelMessage.TYPE_CONVERSION_ERROR, "null", "boolean");
        }
    }
}

