/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.converter.json.simplifier;

import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import javax.management.AttributeNotFoundException;
import org.jolokia.converter.json.Extractor;
import org.jolokia.converter.json.ObjectToJsonConverter;
import org.jolokia.converter.object.StringToObjectConverter;
import org.json.simple.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class SimplifierExtractor<T>
implements Extractor {
    private Map<String, AttributeExtractor<T>> extractorMap = new HashMap<String, AttributeExtractor<T>>();
    private Class<T> type;

    SimplifierExtractor(Class<T> pType) {
        this.type = pType;
        this.init(this.extractorMap);
    }

    @Override
    public Class getType() {
        return this.type;
    }

    @Override
    public Object extractObject(ObjectToJsonConverter pConverter, Object pValue, Stack<String> pExtraArgs, boolean jsonify) throws AttributeNotFoundException {
        if (pExtraArgs.size() > 0) {
            String element = pExtraArgs.pop();
            AttributeExtractor<Object> extractor = this.extractorMap.get(element);
            if (extractor == null) {
                throw new IllegalArgumentException("Illegal path element " + element + " for object " + pValue);
            }
            Object attributeValue = null;
            try {
                attributeValue = extractor.extract(pValue);
                return pConverter.extractObject(attributeValue, pExtraArgs, jsonify);
            }
            catch (SkipAttributeException e) {
                throw new IllegalArgumentException("Illegal path element " + element + " for object " + pValue, e);
            }
        }
        if (jsonify) {
            JSONObject ret = new JSONObject();
            for (Map.Entry<String, AttributeExtractor<T>> entry : this.extractorMap.entrySet()) {
                Object value = null;
                try {
                    value = entry.getValue().extract(pValue);
                }
                catch (SkipAttributeException e) {
                    continue;
                }
                ret.put((Object)entry.getKey(), pConverter.extractObject(value, pExtraArgs, jsonify));
            }
            return ret;
        }
        return pValue;
    }

    @Override
    public boolean canSetValue() {
        return false;
    }

    @Override
    public Object setObjectValue(StringToObjectConverter pConverter, Object pInner, String pAttribute, Object pValue) throws IllegalAccessException, InvocationTargetException {
        throw new IllegalArgumentException("A simplify handler can't set a value");
    }

    protected void addExtractors(Object[][] pAttrExtractors) {
        for (int i = 0; i < pAttrExtractors.length; ++i) {
            this.extractorMap.put((String)pAttrExtractors[i][0], (AttributeExtractor)pAttrExtractors[i][1]);
        }
    }

    abstract void init(Map<String, AttributeExtractor<T>> var1);

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static interface AttributeExtractor<T> {
        public Object extract(T var1) throws SkipAttributeException;
    }

    static class SkipAttributeException
    extends Exception {
        SkipAttributeException() {
        }
    }
}

