/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.kernel.management.internal.system;

import java.lang.management.ManagementFactory;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.eclipse.virgo.kernel.management.internal.system.SystemManagementExporter;
import org.eclipse.virgo.medic.log.EntryExitTrace;
import org.eclipse.virgo.nano.serviceability.dump.DumpCoordinator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSystemManagementExporter<T>
implements SystemManagementExporter {
    private static final String OBJECT_NAME_PATTERN = "%s:category=System Information,type=%s";
    private final Logger logger;
    private final MBeanServer server;
    private static transient /* synthetic */ EntryExitTrace ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;

    public AbstractSystemManagementExporter() {
        try {
            try {
            }
            catch (RuntimeException runtimeException) {
                DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                throw runtimeException;
            }
            this.logger = LoggerFactory.getLogger(this.getClass());
            this.server = ManagementFactory.getPlatformMBeanServer();
            return;
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    @Override
    public void register(String managementDomain) {
        try {
            try {
                AbstractSystemManagementExporter.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$1$557a3571(ajc$tjp_0);
                try {
                    this.server.registerMBean(this.getBean(), this.getObjectName(managementDomain));
                }
                catch (Exception exception) {
                    this.logger.warn("Unable to register system information {} for management", (Object)this.getName());
                }
                AbstractSystemManagementExporter.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$2$557a3571(ajc$tjp_0);
                return;
            }
            catch (Throwable throwable) {
                AbstractSystemManagementExporter.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$3$557a3571(throwable, ajc$tjp_0);
                throw throwable;
            }
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    @Override
    public void unregister(String managementDomain) {
        try {
            try {
                AbstractSystemManagementExporter.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$1$557a3571(ajc$tjp_1);
                try {
                    this.server.unregisterMBean(this.getObjectName(managementDomain));
                }
                catch (Exception exception) {
                    this.logger.warn("Unable to unregister system information {} from management", (Object)this.getName());
                }
                AbstractSystemManagementExporter.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$2$557a3571(ajc$tjp_1);
                return;
            }
            catch (Throwable throwable) {
                AbstractSystemManagementExporter.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$3$557a3571(throwable, ajc$tjp_1);
                throw throwable;
            }
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    private ObjectName getObjectName(String managementDomain) throws MalformedObjectNameException, NullPointerException {
        try {
            return new ObjectName(String.format(OBJECT_NAME_PATTERN, managementDomain, this.getName()));
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    abstract T getBean();

    abstract String getName();

    static {
        Factory factory = new Factory("AbstractSystemManagementExporter.java", Class.forName("org.eclipse.virgo.kernel.management.internal.system.AbstractSystemManagementExporter"));
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "register", "org.eclipse.virgo.kernel.management.internal.system.AbstractSystemManagementExporter", "java.lang.String:", "managementDomain:", "", "void"), 44);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "unregister", "org.eclipse.virgo.kernel.management.internal.system.AbstractSystemManagementExporter", "java.lang.String:", "managementDomain:", "", "void"), 52);
        ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance = EntryExitTrace.ajc$createAspectInstance((String)"org.eclipse.virgo.kernel.management.internal.system.AbstractSystemManagementExporter");
    }
}

