/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.kernel.install.artifact.internal.bundle;

import java.util.Set;
import org.eclipse.virgo.kernel.install.artifact.internal.ArtifactStateMonitor;
import org.eclipse.virgo.kernel.install.artifact.internal.bundle.StandardBundleInstallArtifact;
import org.eclipse.virgo.nano.deployer.api.core.DeploymentException;
import org.eclipse.virgo.nano.serviceability.NonNull;
import org.eclipse.virgo.util.math.ConcurrentHashSet;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.SynchronousBundleListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class BundleDriverBundleListener
implements SynchronousBundleListener {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final StandardBundleInstallArtifact installArtifact;
    private final Bundle bundle;
    private final ArtifactStateMonitor artifactStateMonitor;
    private final Set<Bundle> solicitedStartBundleSet = new ConcurrentHashSet();

    public BundleDriverBundleListener(@NonNull StandardBundleInstallArtifact installArtifact, @NonNull Bundle bundle, @NonNull ArtifactStateMonitor artifactStateMonitor) {
        this.installArtifact = installArtifact;
        this.bundle = bundle;
        this.artifactStateMonitor = artifactStateMonitor;
    }

    void addSolicitedStart(Bundle bundle) {
        this.solicitedStartBundleSet.add(bundle);
    }

    void removeSolicitedStart(Bundle bundle) {
        this.solicitedStartBundleSet.remove(bundle);
    }

    public void bundleChanged(BundleEvent event) {
        if (event.getBundle() == this.bundle) {
            try {
                switch (event.getType()) {
                    case 32: {
                        this.artifactStateMonitor.onResolved(this.installArtifact);
                        break;
                    }
                    case 512: {
                        break;
                    }
                    case 128: {
                        this.artifactStateMonitor.onStarting(this.installArtifact);
                        break;
                    }
                    case 2: {
                        if (!this.solicitedStartBundleSet.contains(this.bundle)) {
                            this.installArtifact.trackStart();
                        }
                        break;
                    }
                    case 256: {
                        this.artifactStateMonitor.onStopping(this.installArtifact);
                        break;
                    }
                    case 4: {
                        this.artifactStateMonitor.onStopped(this.installArtifact);
                        break;
                    }
                    case 64: {
                        this.artifactStateMonitor.onUnresolved(this.installArtifact);
                        break;
                    }
                    case 16: {
                        this.artifactStateMonitor.onUninstalled(this.installArtifact);
                        break;
                    }
                }
            }
            catch (DeploymentException e) {
                this.logger.error(String.format("listener for bundle %s threw DeploymentException", this.bundle), (Throwable)e);
                throw new RuntimeException("percolated listener exception", e);
            }
        }
    }
}

