/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.nano.config.internal;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.virgo.nano.serviceability.dump.DumpCoordinator;
import org.osgi.framework.BundleContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class KernelConfiguration {
    private final Logger LOGGER;
    static final String PROPERTY_KERNEL_CONFIG = "org.eclipse.virgo.kernel.config";
    static final String PROPERTY_KERNEL_HOME = "org.eclipse.virgo.kernel.home";
    static final String PROPERTY_KERNEL_DOMAIN = "org.eclipse.virgo.kernel.domain";
    static final String PROPERTY_KERNEL_STARTUP_WAIT_LIMIT = "org.eclipse.virgo.kernel.startup.wait.limit";
    private static final String DEFAULT_WORK_DIRECTORY_NAME = "work";
    private static final String DEFAULT_CONFIG_DIRECTORY_NAME = "config";
    private static final String DEFAULT_KERNEL_DOMAIN = "org.eclipse.virgo.kernel";
    private static final int DEFAULT_STARTUP_WAIT_LIMIT = 180;
    private final File homeDirectory;
    private final File[] configDirectories;
    private final File workDirectory;
    private final String domain;
    private final int startupWaitLimit;

    public KernelConfiguration(BundleContext context) {
        try {
            this.LOGGER = LoggerFactory.getLogger(this.getClass());
            this.homeDirectory = KernelConfiguration.readHomeDirectory(context);
            this.configDirectories = KernelConfiguration.readConfigDirectories(context);
            this.workDirectory = new File(this.homeDirectory, DEFAULT_WORK_DIRECTORY_NAME);
            this.domain = KernelConfiguration.readDomain(context);
            this.startupWaitLimit = this.readBundleStartupWaitLimit(context);
            return;
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    public File getHomeDirectory() {
        try {
            return this.homeDirectory;
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    public File[] getConfigDirectories() {
        try {
            return (File[])this.configDirectories.clone();
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    public File getWorkDirectory() {
        try {
            return this.workDirectory;
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    public String getDomain() {
        try {
            return this.domain;
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    public int getStartupWaitLimit() {
        try {
            return this.startupWaitLimit;
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    private static File readHomeDirectory(BundleContext context) {
        try {
            String kernelHomeProperty = KernelConfiguration.readFrameworkProperty(PROPERTY_KERNEL_HOME, context);
            if (!KernelConfiguration.hasText(kernelHomeProperty)) {
                throw new IllegalStateException("org.eclipse.virgo.kernel.home property must be specified, and must not be empty");
            }
            return new File(kernelHomeProperty);
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    private static File[] readConfigDirectories(BundleContext context) {
        try {
            String kernelConfigProperty = KernelConfiguration.readFrameworkProperty(PROPERTY_KERNEL_CONFIG, context);
            ArrayList<File> configDirectories = new ArrayList<File>();
            if (KernelConfiguration.hasText(kernelConfigProperty)) {
                KernelConfiguration.parseKernelConfigProperty(kernelConfigProperty, configDirectories);
            }
            if (configDirectories.isEmpty()) {
                configDirectories.add(new File(DEFAULT_CONFIG_DIRECTORY_NAME));
            }
            return configDirectories.toArray(new File[configDirectories.size()]);
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    private static void parseKernelConfigProperty(String kernelConfigProperty, List<File> configDirectories) {
        try {
            String[] components;
            String[] stringArray = components = kernelConfigProperty.split(",");
            int n = components.length;
            int n2 = 0;
            while (n2 < n) {
                String component = stringArray[n2];
                File configDir = new File(component.trim());
                if (!configDir.isAbsolute()) {
                    configDir = new File(component.trim());
                }
                configDirectories.add(configDir);
                ++n2;
            }
            return;
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    private static String readDomain(BundleContext context) {
        try {
            String kernelDomainProperty = KernelConfiguration.readFrameworkProperty(PROPERTY_KERNEL_DOMAIN, context);
            if (!KernelConfiguration.hasText(kernelDomainProperty)) {
                kernelDomainProperty = DEFAULT_KERNEL_DOMAIN;
            }
            return kernelDomainProperty;
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    private int readBundleStartupWaitLimit(BundleContext context) {
        try {
            String waitLimitProperty = KernelConfiguration.readFrameworkProperty(PROPERTY_KERNEL_STARTUP_WAIT_LIMIT, context);
            if (!KernelConfiguration.hasText(waitLimitProperty)) {
                return 180;
            }
            try {
                return Integer.parseInt(waitLimitProperty);
            }
            catch (NumberFormatException numberFormatException) {
                this.LOGGER.warn("Could not parse property {} with value '{}'. Using default limit {} seconds", new Object[]{PROPERTY_KERNEL_STARTUP_WAIT_LIMIT, waitLimitProperty, 180});
                return 180;
            }
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    private static String readFrameworkProperty(String propertyKey, BundleContext context) {
        try {
            return context.getProperty(propertyKey);
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    private static boolean hasText(String string) {
        try {
            return string != null && !string.trim().isEmpty();
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }
}

