/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.web.core.internal;

import java.io.IOException;
import java.util.Locale;
import org.eclipse.virgo.kernel.install.artifact.BundleInstallArtifact;
import org.eclipse.virgo.kernel.install.artifact.InstallArtifact;
import org.eclipse.virgo.kernel.install.environment.InstallEnvironment;
import org.eclipse.virgo.kernel.install.pipeline.stage.transform.Transformer;
import org.eclipse.virgo.nano.deployer.api.core.DeploymentException;
import org.eclipse.virgo.util.common.GraphNode;
import org.eclipse.virgo.util.osgi.manifest.BundleManifest;
import org.eclipse.virgo.web.core.internal.WebContainerUtils;

final class WarDetectingTransformer
implements Transformer {
    private static final String WAR_EXTENSION = ".war";
    private static final String WAR_HEADER = "org-eclipse-virgo-web-war-detected";

    WarDetectingTransformer() {
    }

    public void transform(GraphNode<InstallArtifact> installGraph, InstallEnvironment installEnvironment) throws DeploymentException {
        installGraph.visit((GraphNode.ExceptionThrowingDirectedAcyclicGraphVisitor)new GraphNode.ExceptionThrowingDirectedAcyclicGraphVisitor<InstallArtifact, DeploymentException>(){

            public boolean visit(GraphNode<InstallArtifact> node) throws DeploymentException {
                WarDetectingTransformer.this.detectWar((InstallArtifact)node.getValue());
                return true;
            }
        });
    }

    private void detectWar(InstallArtifact installArtifact) throws DeploymentException {
        if (installArtifact instanceof BundleInstallArtifact && this.hasWarSuffix(installArtifact)) {
            BundleInstallArtifact bundleInstallArtifact = (BundleInstallArtifact)installArtifact;
            try {
                BundleManifest bundleManifest = bundleInstallArtifact.getBundleManifest();
                if (!WebContainerUtils.isWebApplicationBundle(bundleManifest)) {
                    bundleManifest.setHeader(WAR_HEADER, "true");
                }
            }
            catch (IOException iOException) {}
        }
    }

    private boolean hasWarSuffix(InstallArtifact installArtifact) {
        return installArtifact.getArtifactFS().getFile().getName().toLowerCase(Locale.ENGLISH).endsWith(WAR_EXTENSION);
    }
}

