/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.kernel.services.work;

import java.io.File;
import org.eclipse.virgo.kernel.services.work.WorkArea;
import org.eclipse.virgo.util.io.PathReference;
import org.osgi.framework.Bundle;

final class StandardWorkArea
implements WorkArea {
    private static final String KERNEL_PREFIX = "org.eclipse.virgo.kernel.";
    private final PathReference workDirectory;
    private final Bundle owner;

    public StandardWorkArea(File workDirectory, Bundle owner) {
        this.owner = owner;
        this.workDirectory = new PathReference(workDirectory).newChild(this.createOwnerDirectoryName(owner));
        this.workDirectory.createDirectory();
    }

    private String createOwnerDirectoryName(Bundle owner) {
        String ownerSymbolicName = owner.getSymbolicName();
        if (ownerSymbolicName.startsWith(KERNEL_PREFIX)) {
            return ownerSymbolicName.substring(KERNEL_PREFIX.length());
        }
        return String.format("%s_%s", ownerSymbolicName, owner.getVersion());
    }

    @Override
    public Bundle getOwner() {
        return this.owner;
    }

    @Override
    public PathReference getWorkDirectory() {
        return this.workDirectory;
    }
}

