/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.snaps.core.internal.webapp;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Properties;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.catalina.Lifecycle;
import org.apache.catalina.LifecycleException;
import org.eclipse.gemini.web.tomcat.spi.WebBundleClassLoaderFactory;
import org.eclipse.virgo.medic.eventlog.EventLogger;
import org.eclipse.virgo.medic.eventlog.LogEvent;
import org.eclipse.virgo.snaps.core.RequestRouter;
import org.eclipse.virgo.snaps.core.internal.Host;
import org.eclipse.virgo.snaps.core.internal.Snap;
import org.eclipse.virgo.snaps.core.internal.SnapException;
import org.eclipse.virgo.snaps.core.internal.SnapUtils;
import org.eclipse.virgo.snaps.core.internal.SnapsLogEvents;
import org.eclipse.virgo.snaps.core.internal.webapp.SnapServletContext;
import org.eclipse.virgo.snaps.core.internal.webapp.config.BundleWebXmlLoader;
import org.eclipse.virgo.snaps.core.internal.webapp.config.WebXml;
import org.eclipse.virgo.snaps.core.internal.webapp.container.VirtualContainer;
import org.eclipse.virgo.snaps.core.internal.webapp.container.VirtualContainerFactory;
import org.eclipse.virgo.util.io.IOUtils;
import org.osgi.framework.Bundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class WebAppSnap
implements Snap {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final Host host;
    private final Bundle snapBundle;
    private volatile VirtualContainer virtualContainer;
    private volatile ClassLoader snapClassLoader;
    private final WebBundleClassLoaderFactory classLoaderFactory;
    private final String contextPath;
    private final EventLogger eventLogger;

    public WebAppSnap(Host host, Bundle snapBundle, WebBundleClassLoaderFactory webBundleClassLoaderFactory, EventLogger eventLogger) {
        this.host = host;
        this.snapBundle = snapBundle;
        this.contextPath = SnapUtils.getSnapContextPath(snapBundle);
        this.classLoaderFactory = webBundleClassLoaderFactory;
        this.eventLogger = eventLogger;
    }

    @Override
    public final void init() throws ServletException {
        this.logger.info("Initializing snap '{}'", (Object)this.contextPath);
        WebXml webXml = BundleWebXmlLoader.loadWebXml(this.snapBundle);
        SnapServletContext servletContext = new SnapServletContext(this.host.getServletContext(), this.snapBundle, this.contextPath);
        servletContext.setAttribute("osgi-bundlecontext", this.snapBundle.getBundleContext());
        this.snapClassLoader = this.classLoaderFactory.createWebBundleClassLoader(this.snapBundle);
        try {
            ((Lifecycle)this.snapClassLoader).start();
        }
        catch (LifecycleException e) {
            this.logger.error("Failed to start snap's class loader", (Throwable)e);
            throw new ServletException("Failed to start web bundle's class loader", (Throwable)e);
        }
        VirtualContainer virtualContainer = this.createVirtualContainer(webXml, servletContext, this.snapClassLoader, this.host.getRouter());
        virtualContainer.init();
        this.virtualContainer = virtualContainer;
        this.eventLogger.log((LogEvent)SnapsLogEvents.SNAP_BOUND, new Object[]{SnapUtils.boundContextPath(this.host.getServletContext().getContextPath(), this.contextPath)});
    }

    @Override
    public final void destroy() {
        ClassLoader snapClassLoader;
        VirtualContainer virtualContainer = this.virtualContainer;
        if (virtualContainer != null) {
            virtualContainer.destroy();
        }
        if ((snapClassLoader = this.snapClassLoader) != null) {
            try {
                ((Lifecycle)snapClassLoader).stop();
            }
            catch (LifecycleException e) {
                this.logger.error("Failed to stop snap's class loader", (Throwable)e);
                throw new SnapException("Failed to stop web bundle class loader", e);
            }
        }
        this.eventLogger.log((LogEvent)SnapsLogEvents.SNAP_UNBOUND, new Object[]{SnapUtils.boundContextPath(this.host.getServletContext().getContextPath(), this.contextPath)});
    }

    @Override
    public final String getContextPath() {
        return this.contextPath;
    }

    @Override
    public final void handleRequest(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        VirtualContainer virtualContainer = this.virtualContainer;
        if (virtualContainer == null) {
            throw new ServletException("handleRequest invoked when virtual container was null");
        }
        virtualContainer.createDispatcher().service(request, response);
    }

    protected VirtualContainer createVirtualContainer(WebXml webXml, SnapServletContext servletContext, ClassLoader snapClassLoader, RequestRouter requestRouter) {
        return VirtualContainerFactory.fromWebXml(webXml, servletContext, snapClassLoader, requestRouter);
    }

    @Override
    public Properties getSnapProperties() {
        Properties properties = new Properties();
        URL url = this.snapBundle.getEntry("META-INF/snap.properties");
        if (url != null) {
            InputStream is = null;
            try {
                try {
                    is = url.openStream();
                    properties.load(is);
                }
                catch (IOException iOException) {
                    IOUtils.closeQuietly((Closeable)is);
                }
            }
            finally {
                IOUtils.closeQuietly((Closeable)is);
            }
        }
        return properties;
    }
}

