/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.snaps.core.internal.webapp.url;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.virgo.snaps.core.internal.webapp.url.DefaultUrlPattern;
import org.eclipse.virgo.snaps.core.internal.webapp.url.ExactUrlPattern;
import org.eclipse.virgo.snaps.core.internal.webapp.url.ExtensionUrlPattern;
import org.eclipse.virgo.snaps.core.internal.webapp.url.Mapping;
import org.eclipse.virgo.snaps.core.internal.webapp.url.PathUrlPattern;
import org.eclipse.virgo.snaps.core.internal.webapp.url.UrlPattern;
import org.eclipse.virgo.snaps.core.internal.webapp.url.UrlPatternFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class UrlPatternMatcher {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final List<Mapping> exactMappings = Collections.synchronizedList(new ArrayList());
    private final List<Mapping> pathMappings = Collections.synchronizedList(new ArrayList());
    private final List<Mapping> extensionMappings = Collections.synchronizedList(new ArrayList());
    private volatile Mapping defaultMapping;

    public void addMapping(String name, String pattern) {
        this.logger.info("Adding mapping '{}' with pattern '{}'", (Object)name, (Object)pattern);
        UrlPattern urlPattern = UrlPatternFactory.create(pattern);
        Mapping entry = new Mapping(urlPattern, name, pattern);
        if (urlPattern instanceof ExactUrlPattern) {
            this.exactMappings.add(entry);
        } else if (urlPattern instanceof ExtensionUrlPattern) {
            this.extensionMappings.add(entry);
        } else if (urlPattern instanceof PathUrlPattern) {
            this.pathMappings.add(entry);
            this.sortPathMappings();
        } else if (urlPattern instanceof DefaultUrlPattern) {
            this.defaultMapping = entry;
        } else {
            this.logger.error("Unrecognized UrlPattern type '{}'", pattern.getClass());
            throw new IllegalStateException("Unrecognised UrlPattern type '" + pattern.getClass() + "'");
        }
    }

    private void sortPathMappings() {
        Collections.sort(this.pathMappings, new PathSpecificityComparator());
    }

    public Mapping match(String path) {
        Mapping m;
        Mapping match = this.findMatchIn(path, this.exactMappings);
        if (match == null && (match = this.findMatchIn(path, this.pathMappings)) == null && (match = this.findMatchIn(path, this.extensionMappings)) == null && (m = this.defaultMapping) != null && m.getPattern().matches(path)) {
            match = m;
        }
        if (match != null) {
            this.logger.info("Matched path '{}' with mapping '{}'", (Object)path, (Object)match.getName());
        } else {
            this.logger.warn("Unable to match path '{}'", (Object)path);
        }
        return match;
    }

    private Mapping findMatchIn(String path, List<Mapping> mappings) {
        for (Mapping entry : mappings) {
            if (!entry.getPattern().matches(path)) continue;
            return entry;
        }
        return null;
    }

    private static final class PathSpecificityComparator
    implements Comparator<Mapping>,
    Serializable {
        private static final long serialVersionUID = 3703208057785098804L;

        private PathSpecificityComparator() {
        }

        @Override
        public int compare(Mapping e1, Mapping e2) {
            Integer s1 = this.specificityOf(e1);
            Integer s2 = this.specificityOf(e2);
            return s2.compareTo(s1);
        }

        private Integer specificityOf(Mapping e) {
            String pattern = e.getRawPattern();
            return this.countOccurencesOf(pattern, '/');
        }

        private int countOccurencesOf(String pattern, char c) {
            int count = 0;
            int x = 0;
            while (x < pattern.length()) {
                if (c == pattern.charAt(x)) {
                    ++count;
                }
                ++x;
            }
            return count;
        }
    }
}

