/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.apps.admin.web;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.virgo.apps.admin.core.ArtifactService;
import org.eclipse.virgo.apps.admin.web.internal.DojoTreeFormatter;
import org.eclipse.virgo.kernel.shell.model.helper.ArtifactAccessor;
import org.eclipse.virgo.kernel.shell.model.helper.RamAccessorHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.ServletRequestBindingException;
import org.springframework.web.bind.ServletRequestUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import org.springframework.web.servlet.ModelAndView;

@Controller
public final class ArtifactController {
    private static final Logger LOGGER = LoggerFactory.getLogger(ArtifactController.class);
    private static final String AJAX_JSON_CONTENT_TYPE = "application/json";
    private static final String TYPE = "type";
    private static final String NAME = "name";
    private static final String VERSION = "version";
    private static final String REGION = "region";
    private static final String PARENT = "parent";
    private final ArtifactService artifactService;
    private final DojoTreeFormatter dojoTreeJsonFormatter;
    private final RamAccessorHelper ramAccessorHelper;

    @Autowired
    public ArtifactController(ArtifactService artifactService, DojoTreeFormatter dojoTreeJsonFormatter, RamAccessorHelper ramAccessorHelper) {
        this.artifactService = artifactService;
        this.dojoTreeJsonFormatter = dojoTreeJsonFormatter;
        this.ramAccessorHelper = ramAccessorHelper;
    }

    @RequestMapping(value={"/artifact/overview.htm"})
    public ModelAndView overview(HttpServletRequest request) {
        String msg = request.getParameter("message");
        if (msg == null || "".equals(msg)) {
            return new ModelAndView("artifact-overview");
        }
        return new ModelAndView("artifact-overview").addObject("result", (Object)msg);
    }

    @RequestMapping(value={"/artifact/deploy.htm"})
    public ModelAndView deploy(HttpServletRequest request) {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        MultipartFile multipartFile = multipartRequest.getFile("application");
        String msg = multipartFile == null || multipartFile.isEmpty() ? "Error: Please select the artifact you would like to upload." : this.deployFile(multipartFile);
        return new ModelAndView("artifact-overview").addObject("result", (Object)msg);
    }

    private String deployFile(MultipartFile multipartFile) {
        File dest = new File(this.artifactService.getStagingDirectory().getAbsolutePath(), multipartFile.getOriginalFilename());
        try {
            multipartFile.transferTo(dest);
            return this.artifactService.deploy(dest);
        }
        catch (IOException e) {
            String msg = "An error occurred while transferring an uploaded file to [" + dest.getAbsolutePath() + "]. Consult the serviceability output for further details.";
            LOGGER.warn(msg, (Throwable)e);
            return msg;
        }
    }

    @RequestMapping(value={"/artifact/do/start"})
    public ModelAndView actionStart(HttpServletRequest request) throws ServletRequestBindingException {
        String type = ServletRequestUtils.getRequiredStringParameter((ServletRequest)request, (String)TYPE);
        String name = ServletRequestUtils.getRequiredStringParameter((ServletRequest)request, (String)NAME);
        String version = ServletRequestUtils.getRequiredStringParameter((ServletRequest)request, (String)VERSION);
        String region = ServletRequestUtils.getRequiredStringParameter((ServletRequest)request, (String)REGION);
        String msg = this.ramAccessorHelper.start(type, name, version, region);
        return new ModelAndView("artifact-overview").addObject("result", (Object)msg);
    }

    @RequestMapping(value={"/artifact/do/stop"})
    public ModelAndView actionStop(HttpServletRequest request) throws ServletRequestBindingException {
        String type = ServletRequestUtils.getRequiredStringParameter((ServletRequest)request, (String)TYPE);
        String name = ServletRequestUtils.getRequiredStringParameter((ServletRequest)request, (String)NAME);
        String version = ServletRequestUtils.getRequiredStringParameter((ServletRequest)request, (String)VERSION);
        String region = ServletRequestUtils.getRequiredStringParameter((ServletRequest)request, (String)REGION);
        String msg = this.ramAccessorHelper.stop(type, name, version, region);
        return new ModelAndView("artifact-overview").addObject("result", (Object)msg);
    }

    @RequestMapping(value={"/artifact/do/uninstall"})
    public ModelAndView actionUninstall(HttpServletRequest request) throws ServletRequestBindingException {
        String type = ServletRequestUtils.getRequiredStringParameter((ServletRequest)request, (String)TYPE);
        String name = ServletRequestUtils.getRequiredStringParameter((ServletRequest)request, (String)NAME);
        String version = ServletRequestUtils.getRequiredStringParameter((ServletRequest)request, (String)VERSION);
        String region = ServletRequestUtils.getRequiredStringParameter((ServletRequest)request, (String)REGION);
        String msg = this.ramAccessorHelper.uninstall(type, name, version, region);
        return new ModelAndView("artifact-overview").addObject("result", (Object)msg);
    }

    @RequestMapping(value={"/artifact/do/refresh"})
    public ModelAndView actionRefresh(HttpServletRequest request) throws ServletRequestBindingException {
        String type = ServletRequestUtils.getRequiredStringParameter((ServletRequest)request, (String)TYPE);
        String name = ServletRequestUtils.getRequiredStringParameter((ServletRequest)request, (String)NAME);
        String version = ServletRequestUtils.getRequiredStringParameter((ServletRequest)request, (String)VERSION);
        String region = ServletRequestUtils.getRequiredStringParameter((ServletRequest)request, (String)REGION);
        String msg = this.ramAccessorHelper.refresh(type, name, version, region);
        return new ModelAndView("artifact-overview").addObject("result", (Object)msg);
    }

    @RequestMapping(value={"/artifact/data"})
    public void data(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletRequestBindingException {
        String responseString;
        String type = ServletRequestUtils.getStringParameter((ServletRequest)request, (String)TYPE);
        String name = ServletRequestUtils.getStringParameter((ServletRequest)request, (String)NAME);
        String version = ServletRequestUtils.getStringParameter((ServletRequest)request, (String)VERSION);
        String region = ServletRequestUtils.getStringParameter((ServletRequest)request, (String)REGION);
        String parent = ServletRequestUtils.getStringParameter((ServletRequest)request, (String)PARENT);
        if (type == null) {
            responseString = this.dojoTreeJsonFormatter.formatTypes(this.ramAccessorHelper.getTypes());
        } else if (type != null && name == null) {
            responseString = this.dojoTreeJsonFormatter.formatArtifactsOfType(parent, this.ramAccessorHelper.getArtifactsOfType(type));
        } else if (type != null && name != null && version != null) {
            ArtifactAccessor artifact = this.ramAccessorHelper.getArtifact(type, name, version, region);
            responseString = this.dojoTreeJsonFormatter.formatArtifactDetails(parent, artifact);
        } else {
            throw new IllegalArgumentException(String.format("Cannot service request with parameters: %s", request.getQueryString()));
        }
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        sb.append("identifier: 'id',");
        sb.append("label: 'label',");
        sb.append("items: [ ");
        if (responseString != null) {
            sb.append(responseString);
        }
        sb.append("]}");
        response.setContentType(AJAX_JSON_CONTENT_TYPE);
        PrintWriter writer = response.getWriter();
        writer.write(sb.toString());
        writer.flush();
    }
}

