/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.osgi.console.supportability;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.osgi.framework.console.CommandProvider;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public class CommandCompleter {
    private Set<String> availableCommands;
    private ServiceTracker<CommandProvider, Object> cpTracker;
    private BundleContext context = null;

    public CommandCompleter(BundleContext context) {
        this.context = context;
        this.availableCommands = new HashSet<String>();
        this.availableCommands = Collections.synchronizedSet(this.availableCommands);
        this.availableCommands.add("more");
        this.availableCommands.add("disconnect");
        this.availableCommands.add("grep");
        if (context != null) {
            this.cpTracker = new ServiceTracker(context, CommandProvider.class.getName(), (ServiceTrackerCustomizer)new CommandProviderCustomizer());
            this.cpTracker.open();
        }
    }

    public String[] complete(String prefix) {
        ArrayList<String> candidates = new ArrayList<String>();
        for (String command : this.availableCommands) {
            if (!command.startsWith(prefix)) continue;
            candidates.add(command);
        }
        return candidates.toArray(new String[candidates.size()]);
    }

    class CommandProviderCustomizer
    implements ServiceTrackerCustomizer<CommandProvider, Object> {
        CommandProviderCustomizer() {
        }

        public Object addingService(ServiceReference<CommandProvider> reference) {
            Method[] methods;
            CommandProvider provider = (CommandProvider)CommandCompleter.this.context.getService(reference);
            Method[] methodArray = methods = provider.getClass().getMethods();
            int n = methods.length;
            int n2 = 0;
            while (n2 < n) {
                Method method = methodArray[n2];
                if (method.getName().startsWith("_")) {
                    CommandCompleter.this.availableCommands.add(method.getName().substring(1));
                }
                ++n2;
            }
            return null;
        }

        public void modifiedService(ServiceReference<CommandProvider> reference, Object service) {
        }

        public void removedService(ServiceReference<CommandProvider> reference, Object service) {
            Method[] methods;
            CommandProvider provider = (CommandProvider)CommandCompleter.this.context.getService(reference);
            Method[] methodArray = methods = provider.getClass().getMethods();
            int n = methods.length;
            int n2 = 0;
            while (n2 < n) {
                Method method = methodArray[n2];
                if (method.getName().startsWith("_")) {
                    CommandCompleter.this.availableCommands.remove(method.getName());
                }
                ++n2;
            }
        }
    }
}

