/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.medic.dump.impl;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.virgo.medic.dump.DumpContributor;
import org.eclipse.virgo.medic.dump.impl.heap.HeapDumpContributor;
import org.eclipse.virgo.medic.dump.impl.logback.LogDumpContributor;
import org.eclipse.virgo.medic.dump.impl.summary.SummaryDumpContributor;
import org.eclipse.virgo.medic.dump.impl.thread.ThreadDumpContributor;
import org.eclipse.virgo.medic.impl.config.ConfigurationProvider;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;

public final class DumpContributorPublisher {
    private static final String SUPPRESS_HEAP_DUMPS = "org.eclipse.virgo.suppress.heap.dumps";
    private final List<ServiceRegistration> contributorRegistrations = new ArrayList<ServiceRegistration>();
    private final BundleContext bundleContext;
    private final ConfigurationProvider configurationProvider;
    private final LogDumpContributor logDumpContributor;

    public DumpContributorPublisher(BundleContext bundleContext, ConfigurationProvider configurationProvider) {
        this.bundleContext = bundleContext;
        this.configurationProvider = configurationProvider;
        this.logDumpContributor = new LogDumpContributor(this.configurationProvider);
    }

    public void publishDumpContributors() {
        this.publishDumpContributor(new SummaryDumpContributor());
        if ("false".equalsIgnoreCase(this.bundleContext.getProperty(SUPPRESS_HEAP_DUMPS))) {
            this.publishDumpContributor(new HeapDumpContributor());
        }
        this.publishDumpContributor(new ThreadDumpContributor());
        this.publishDumpContributor(this.logDumpContributor);
    }

    private void publishDumpContributor(DumpContributor dumpContributor) {
        ServiceRegistration registration = this.bundleContext.registerService(DumpContributor.class.getName(), (Object)dumpContributor, null);
        this.contributorRegistrations.add(registration);
    }

    public void retractDumpContributors() {
        for (ServiceRegistration registration : this.contributorRegistrations) {
            registration.unregister();
        }
        this.logDumpContributor.clear();
        this.contributorRegistrations.clear();
    }
}

