/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.store.access.heap;

import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.store.access.Qualifier;
import org.apache.derby.iapi.store.access.RowUtil;
import org.apache.derby.iapi.store.access.ScanInfo;
import org.apache.derby.iapi.store.access.conglomerate.ScanManager;
import org.apache.derby.iapi.store.access.conglomerate.TransactionManager;
import org.apache.derby.iapi.store.raw.RecordHandle;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.RowLocation;
import org.apache.derby.impl.store.access.conglomerate.GenericScanController;
import org.apache.derby.impl.store.access.conglomerate.RowPosition;
import org.apache.derby.impl.store.access.heap.Heap;
import org.apache.derby.impl.store.access.heap.HeapPostCommit;
import org.apache.derby.impl.store.access.heap.HeapRowLocation;
import org.apache.derby.impl.store.access.heap.HeapScanInfo;

class HeapScan
extends GenericScanController
implements ScanManager {
    private DataValueDescriptor[][] fetchNext_one_slot_array = new DataValueDescriptor[1][];

    protected void queueDeletePostCommitWork(RowPosition rowPosition) throws StandardException {
        TransactionManager transactionManager = this.open_conglom.getXactMgr();
        transactionManager.addPostCommitWork(new HeapPostCommit(transactionManager.getAccessManager(), (Heap)this.open_conglom.getConglomerate(), rowPosition.current_page.getPageNumber()));
    }

    protected void setRowLocationArray(RowLocation[] rowLocationArray, int n, RowPosition rowPosition) throws StandardException {
        if (rowLocationArray[n] == null) {
            rowLocationArray[n] = new HeapRowLocation(rowPosition.current_rh);
        } else {
            ((HeapRowLocation)rowLocationArray[n]).setFrom(rowPosition.current_rh);
        }
    }

    protected void setRowLocationArray(RowLocation[] rowLocationArray, int n, RecordHandle recordHandle) throws StandardException {
        if (rowLocationArray[n] == null) {
            rowLocationArray[n] = new HeapRowLocation(recordHandle);
        } else {
            ((HeapRowLocation)rowLocationArray[n]).setFrom(recordHandle);
        }
    }

    private boolean reopenScanByRecordHandleAndSetLocks(RecordHandle recordHandle) throws StandardException {
        if (recordHandle == null) {
            return false;
        }
        if (this.scan_position.current_rh != null) {
            this.open_conglom.unlockPositionAfterRead(this.scan_position);
        }
        this.scan_position.current_rh = recordHandle;
        this.scan_position.current_rh_qualified = false;
        boolean bl = this.open_conglom.latchPageAndRepositionScan(this.scan_position);
        if (!bl) {
            this.setScanState(2);
            this.open_conglom.lockPositionForRead(this.scan_position, null, true, true);
        }
        this.scan_position.unlatch();
        return !bl;
    }

    public boolean fetchNext(DataValueDescriptor[] dataValueDescriptorArray) throws StandardException {
        this.fetchNext_one_slot_array[0] = dataValueDescriptorArray == null ? RowUtil.EMPTY_ROW : dataValueDescriptorArray;
        boolean bl = this.fetchRows(this.fetchNext_one_slot_array, null, null, 1L, null) == 1;
        return bl;
    }

    public boolean next() throws StandardException {
        this.fetchNext_one_slot_array[0] = this.open_conglom.getRuntimeMem().get_scratch_row(this.open_conglom.getRawTran());
        boolean bl = this.fetchRows(this.fetchNext_one_slot_array, null, null, 1L, null) == 1;
        return bl;
    }

    public boolean positionAtRowLocation(RowLocation rowLocation) throws StandardException {
        if (this.open_conglom.isClosed() && !this.rowLocationsInvalidated) {
            this.reopenAfterEndTransaction();
        }
        if (this.rowLocationsInvalidated) {
            return false;
        }
        return this.reopenScanByRecordHandleAndSetLocks(((HeapRowLocation)rowLocation).getRecordHandle(this.open_conglom.getContainer()));
    }

    public void fetchLocation(RowLocation rowLocation) throws StandardException {
        if (this.open_conglom.getContainer() == null || this.scan_position.current_rh == null) {
            throw StandardException.newException("XSCH7.S");
        }
        HeapRowLocation heapRowLocation = (HeapRowLocation)rowLocation;
        heapRowLocation.setFrom(this.scan_position.current_rh);
    }

    public int fetchNextGroup(DataValueDescriptor[][] dataValueDescriptorArray, RowLocation[] rowLocationArray) throws StandardException {
        return this.fetchRows(dataValueDescriptorArray, rowLocationArray, null, dataValueDescriptorArray.length, null);
    }

    public int fetchNextGroup(DataValueDescriptor[][] dataValueDescriptorArray, RowLocation[] rowLocationArray, RowLocation[] rowLocationArray2) throws StandardException {
        throw StandardException.newException("XSCH8.S");
    }

    public ScanInfo getScanInfo() throws StandardException {
        return new HeapScanInfo(this);
    }

    public void reopenScanByRowLocation(RowLocation rowLocation, Qualifier[][] qualifierArray) throws StandardException {
        this.reopenScanByRecordHandle(((HeapRowLocation)rowLocation).getRecordHandle(this.open_conglom.getContainer()), qualifierArray);
    }
}

