/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.sessions.remote;

import java.util.IdentityHashMap;
import java.util.Map;
import org.eclipse.persistence.config.ReferenceMode;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.history.AsOfClause;
import org.eclipse.persistence.internal.descriptors.OptimisticLockingPolicy;
import org.eclipse.persistence.internal.queries.ContainerPolicy;
import org.eclipse.persistence.internal.sequencing.Sequencing;
import org.eclipse.persistence.internal.sequencing.SequencingFactory;
import org.eclipse.persistence.internal.sessions.MergeManager;
import org.eclipse.persistence.internal.sessions.UnitOfWorkImpl;
import org.eclipse.persistence.internal.sessions.remote.ObjectDescriptor;
import org.eclipse.persistence.internal.sessions.remote.RemoteConnection;
import org.eclipse.persistence.internal.sessions.remote.RemoteUnitOfWork;
import org.eclipse.persistence.internal.sessions.remote.RemoteValueHolder;
import org.eclipse.persistence.internal.sessions.remote.Transporter;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ObjectLevelReadQuery;
import org.eclipse.persistence.sessions.Login;
import org.eclipse.persistence.sessions.Session;
import org.eclipse.persistence.sessions.remote.DistributedSession;

public class RemoteSession
extends DistributedSession {
    protected Sequencing sequencing;
    protected boolean shouldEnableDistributedIndirectionGarbageCollection = false;

    public RemoteSession(RemoteConnection remoteConnection) {
        super(remoteConnection);
        this.initializeSequencing();
    }

    public void setShouldEnableDistributedIndirectionGarbageCollection(boolean shouldEnableDistributedIndirectionGarbageCollection) {
        this.shouldEnableDistributedIndirectionGarbageCollection = shouldEnableDistributedIndirectionGarbageCollection;
    }

    public boolean shouldEnableDistributedIndirectionGarbageCollection() {
        return this.shouldEnableDistributedIndirectionGarbageCollection;
    }

    @Override
    public Session acquireHistoricalSession(AsOfClause clause) throws ValidationException {
        throw ValidationException.cannotAcquireHistoricalSession();
    }

    @Override
    public UnitOfWorkImpl acquireUnitOfWork() {
        return this.acquireUnitOfWork(null);
    }

    @Override
    public UnitOfWorkImpl acquireUnitOfWork(ReferenceMode referenceMode) {
        this.log(2, "transaction", "acquire_unit_of_work");
        this.setNumberOfActiveUnitsOfWork(this.getNumberOfActiveUnitsOfWork() + 1);
        return new RemoteUnitOfWork(this, referenceMode);
    }

    @Override
    public Object executeQuery(DatabaseQuery query) {
        return query.remoteExecute(this);
    }

    @Override
    public Login getDatasourceLogin() {
        Login login = super.getDatasourceLogin();
        if (login == null && this.getRemoteConnection() != null) {
            login = this.getRemoteConnection().getLogin();
            this.setDatasourceLogin(login);
        }
        return login;
    }

    @Override
    public Object getObjectCorrespondingTo(Object serverSideDomainObject, Map objectDescriptors, Map processedObjects, ObjectLevelReadQuery query) {
        if (serverSideDomainObject == null) {
            return null;
        }
        ClassDescriptor descriptor = this.getDescriptor(serverSideDomainObject);
        if (descriptor.isAggregateCollectionDescriptor() || query != null && !query.shouldMaintainCache()) {
            if (query != null && !query.hasPartialAttributeExpressions()) {
                descriptor.getObjectBuilder().fixObjectReferences(serverSideDomainObject, objectDescriptors, processedObjects, query, this);
            }
            return serverSideDomainObject;
        }
        ObjectDescriptor objectDescriptor = (ObjectDescriptor)objectDescriptors.get(serverSideDomainObject);
        if (objectDescriptor == null) {
            objectDescriptor = new ObjectDescriptor();
            objectDescriptor.setKey(descriptor.getObjectBuilder().extractPrimaryKeyFromObject(serverSideDomainObject, this));
            objectDescriptor.setObject(serverSideDomainObject);
            OptimisticLockingPolicy policy = descriptor.getOptimisticLockingPolicy();
            if (policy == null) {
                objectDescriptor.setWriteLockValue(null);
            } else {
                objectDescriptor.setWriteLockValue(policy.getBaseValue());
            }
            objectDescriptors.put(serverSideDomainObject, objectDescriptor);
        }
        Object primaryKey = objectDescriptor.getKey();
        Object clientSideDomainObject = this.getIdentityMapAccessorInstance().getFromIdentityMap(primaryKey, serverSideDomainObject.getClass(), descriptor);
        if (processedObjects.containsKey(serverSideDomainObject)) {
            if (clientSideDomainObject == null) {
                return serverSideDomainObject;
            }
            return clientSideDomainObject;
        }
        processedObjects.put(serverSideDomainObject, serverSideDomainObject);
        if (clientSideDomainObject == null) {
            this.getIdentityMapAccessorInstance().putInIdentityMap(serverSideDomainObject, primaryKey, objectDescriptor.getWriteLockValue(), objectDescriptor.getReadTime(), descriptor);
            descriptor.getObjectBuilder().fixObjectReferences(serverSideDomainObject, objectDescriptors, processedObjects, query, this);
            clientSideDomainObject = serverSideDomainObject;
        } else if (query == null || query.shouldRefreshRemoteIdentityMapResult() || this.getDescriptor(clientSideDomainObject).shouldAlwaysRefreshCacheOnRemote()) {
            MergeManager mergeManager = new MergeManager(this);
            mergeManager.refreshRemoteObject();
            mergeManager.setObjectDescriptors(objectDescriptors);
            if (query == null) {
                mergeManager.cascadePrivateParts();
            } else {
                mergeManager.setCascadePolicy(query.getCascadePolicy());
            }
            clientSideDomainObject = mergeManager.mergeChanges(serverSideDomainObject, null, this);
        }
        return clientSideDomainObject;
    }

    @Override
    public Object getObjectsCorrespondingToAll(Object serverSideDomainObjects, Map objectDescriptors, Map processedObjects, ObjectLevelReadQuery query, ContainerPolicy containerPolicy) {
        Object clientSideDomainObjects = containerPolicy.containerInstance(containerPolicy.sizeFor(serverSideDomainObjects));
        Object iter = containerPolicy.iteratorFor(serverSideDomainObjects);
        while (containerPolicy.hasNext(iter)) {
            Object serverSideDomainObject = containerPolicy.next(iter, this);
            containerPolicy.addInto(this.getObjectCorrespondingTo(serverSideDomainObject, objectDescriptors, processedObjects, query), clientSideDomainObjects, this);
        }
        return clientSideDomainObjects;
    }

    @Override
    public Object instantiateRemoteValueHolderOnServer(RemoteValueHolder remoteValueHolder) {
        Transporter transporter = this.getRemoteConnection().instantiateRemoteValueHolderOnServer(remoteValueHolder);
        return remoteValueHolder.getMapping().getObjectCorrespondingTo(transporter.getObject(), this, transporter.getObjectDescriptors(), new IdentityHashMap(), remoteValueHolder.getQuery());
    }

    @Override
    public boolean isRemoteSession() {
        return true;
    }

    @Override
    public Sequencing getSequencing() {
        return this.sequencing;
    }

    public void initializeSequencing() {
        this.sequencing = SequencingFactory.createSequencing(this);
    }
}

