/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vorto.wizard;

import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.vorto.codegen.ui.context.IProjectContext;
import org.eclipse.vorto.wizard.AbstractWizardPage;

public abstract class AbstractProjectWizardPage
extends AbstractWizardPage
implements IProjectContext {
    private String projectName;
    private Text txtProjectName;
    private Text txtWorkspaceLocation;
    private String workspaceLocation;

    protected AbstractProjectWizardPage(String pageName, String title, ImageDescriptor descriptor) {
        super(pageName, title, descriptor);
    }

    protected AbstractProjectWizardPage(String pageName) {
        super(pageName);
    }

    protected abstract String getDefaultProjectName();

    private void initialize() {
        this.txtProjectName.setText(this.getDefaultProjectName());
        this.txtWorkspaceLocation.setText(String.valueOf(this.getWorkspaceLocation()) + "/" + this.getDefaultProjectName());
    }

    public void createControl(Composite parent) {
        Composite topContainer = new Composite(parent, 0);
        this.setControl((Control)topContainer);
        topContainer.setLayout((Layout)new GridLayout(1, false));
        Group grpProjectDetails = new Group(topContainer, 0);
        grpProjectDetails.setLayout((Layout)new GridLayout(3, false));
        GridData gridGrpProjectDetails = new GridData(0x1000000, 0x1000000, false, false, 1, 1);
        gridGrpProjectDetails.heightHint = 60;
        gridGrpProjectDetails.widthHint = 575;
        grpProjectDetails.setLayoutData((Object)gridGrpProjectDetails);
        grpProjectDetails.setText("Project Details");
        Label lblProjectName = new Label((Composite)grpProjectDetails, 0);
        GridData gridLblProjectName = new GridData(131072, 0x1000000, false, false, 1, 1);
        gridLblProjectName.widthHint = 78;
        lblProjectName.setLayoutData((Object)gridLblProjectName);
        lblProjectName.setText("Project Name:");
        this.txtProjectName = new Text((Composite)grpProjectDetails, 2048);
        GridData gridTxtProjectName = new GridData(4, 0x1000000, false, false, 1, 1);
        gridTxtProjectName.widthHint = 370;
        this.txtProjectName.setLayoutData((Object)gridTxtProjectName);
        this.txtProjectName.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AbstractProjectWizardPage.this.projectNameChanged();
                AbstractProjectWizardPage.this.dialogChanged();
            }
        });
        new Label((Composite)grpProjectDetails, 0);
        Label lblLocation = new Label((Composite)grpProjectDetails, 0);
        GridData gridLblLocation = new GridData(131072, 0x1000000, false, false, 1, 1);
        gridLblLocation.widthHint = 48;
        lblLocation.setLayoutData((Object)gridLblLocation);
        lblLocation.setText("Location:");
        this.txtWorkspaceLocation = new Text((Composite)grpProjectDetails, 2048);
        this.txtWorkspaceLocation.setEditable(false);
        GridData gridTxtLocation = new GridData(16384, 0x1000000, false, false, 1, 1);
        gridTxtLocation.widthHint = 385;
        this.txtWorkspaceLocation.setLayoutData((Object)gridTxtLocation);
        Button btnBrowse = new Button((Composite)grpProjectDetails, 0);
        btnBrowse.setText("Browse...");
        btnBrowse.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AbstractProjectWizardPage.this.handleBrowse(e);
            }
        });
        this.initialize();
        this.setControl((Control)topContainer);
    }

    @Override
    public String getProjectName() {
        return this.txtProjectName.getText();
    }

    private void projectNameChanged() {
        this.txtWorkspaceLocation.setText(String.valueOf(this.getWorkspaceLocation()) + "/" + this.getProjectName());
        this.projectName = this.getProjectName();
    }

    public void dialogChanged() {
        if (this.validateProject()) {
            this.setErrorMessage(null);
            this.setPageComplete(true);
        } else {
            this.setPageComplete(false);
        }
    }

    protected void handleBrowse(SelectionEvent e) {
        DirectoryDialog directoryDialog = new DirectoryDialog(this.getShell());
        directoryDialog.setFilterPath(this.workspaceLocation);
        directoryDialog.setText("Workspace folder selection");
        directoryDialog.setMessage("Select a directory for this project");
        String selectedDirectory = directoryDialog.open();
        selectedDirectory = StringUtils.replace((String)selectedDirectory, (String)"\\", (String)"/");
        if (selectedDirectory != null) {
            this.workspaceLocation = selectedDirectory;
            this.updateWorkspaceLocationField(this.workspaceLocation);
            this.dialogChanged();
        }
    }

    protected boolean validateProject() {
        boolean result = true;
        String projectName = this.getProjectName();
        result &= this.validateStrExist(projectName, "Project name must be specified");
        result &= this.validateExistingSameProjectName(projectName);
        return result &= this.checkProjectName(projectName);
    }

    public void updateWorkspaceLocationField(String directory) {
        this.txtWorkspaceLocation.setText(String.valueOf(directory) + "/" + this.getProjectName());
    }

    public String getProjName() {
        return this.projectName;
    }

    public String getWorkspaceLocation() {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        if (this.workspaceLocation == null) {
            this.workspaceLocation = workspace.getRoot().getLocation().toString();
        }
        return this.workspaceLocation;
    }
}

