/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dali.internal.utility;

import java.io.Serializable;
import java.lang.reflect.Field;
import java.text.Collator;
import org.eclipse.dali.internal.utility.ClassTools;

public final class JDBCType
implements Comparable,
Cloneable,
Serializable {
    private final String name;
    private final int code;
    private static final long serialVersionUID = 1L;
    private static JDBCType[] TYPES;
    static /* synthetic */ Class class$0;

    private JDBCType(String name, int code) {
        this.name = name;
        this.code = code;
    }

    public String getName() {
        return this.name;
    }

    public int getCode() {
        return this.code;
    }

    public void appendTo(StringBuffer sb) {
        sb.append(this.name);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(ClassTools.shortClassNameForObject(this));
        sb.append('(');
        this.appendTo(sb);
        sb.append(')');
        return sb.toString();
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public int compareTo(Object o) {
        return Collator.getInstance().compare(this.name, ((JDBCType)o).name);
    }

    public static synchronized JDBCType[] types() {
        if (TYPES == null) {
            TYPES = JDBCType.buildTypes();
        }
        return TYPES;
    }

    public static JDBCType type(int code) {
        JDBCType[] types = JDBCType.types();
        int i = types.length;
        while (i-- > 0) {
            if (types[i].getCode() != code) continue;
            return types[i];
        }
        throw new IllegalArgumentException("invalid JDBC type code: " + code);
    }

    public static JDBCType type(String name) {
        JDBCType[] types = JDBCType.types();
        int i = types.length;
        while (i-- > 0) {
            if (!types[i].getName().equals(name)) continue;
            return types[i];
        }
        throw new IllegalArgumentException("invalid JDBC type name: " + name);
    }

    private static JDBCType[] buildTypes() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("java.sql.Types");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Field[] fields = clazz.getDeclaredFields();
        int len = fields.length;
        JDBCType[] types = new JDBCType[len];
        int i = len;
        while (i-- > 0) {
            int code;
            String name = fields[i].getName();
            try {
                code = (Integer)fields[i].get(null);
            }
            catch (IllegalAccessException ex) {
                throw new RuntimeException(ex);
            }
            types[i] = new JDBCType(name, code);
        }
        return types;
    }
}

