/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dali.internal.utility;

import java.util.Collection;
import java.util.Iterator;
import org.eclipse.dali.internal.utility.CollectionTools;
import org.eclipse.dali.internal.utility.HashBag;

public final class NameTools {
    public static String uniqueNameFor(String rootName, Iterator existingNames) {
        return NameTools.uniqueNameFor(rootName, CollectionTools.set(existingNames));
    }

    public static String uniqueNameFor(String rootName, Collection existingNames) {
        return NameTools.uniqueNameFor(rootName, existingNames, rootName);
    }

    public static String uniqueNameForIgnoreCase(String rootName, Iterator existingNames) {
        return NameTools.uniqueNameForIgnoreCase(rootName, CollectionTools.set(existingNames));
    }

    public static String uniqueNameForIgnoreCase(String rootName, Collection existingNames) {
        return NameTools.uniqueNameFor(rootName, NameTools.convertToLowerCase(existingNames), rootName.toLowerCase());
    }

    private static String uniqueNameFor(String rootName, Collection existingNames, String templateName) {
        if (!existingNames.contains(templateName)) {
            return rootName;
        }
        String uniqueName = templateName;
        int suffix = 2;
        while (existingNames.contains(String.valueOf(uniqueName) + suffix)) {
            ++suffix;
        }
        return rootName.concat(String.valueOf(suffix));
    }

    private static Collection convertToLowerCase(Collection strings) {
        HashBag result = new HashBag(strings.size());
        Iterator stream = strings.iterator();
        while (stream.hasNext()) {
            result.add(((String)stream.next()).toLowerCase());
        }
        return result;
    }

    public static String buildQualifiedDatabaseObjectName(String catalog, String schema, String name) {
        if (name == null) {
            throw new IllegalArgumentException();
        }
        if (catalog == null && schema == null) {
            return name;
        }
        StringBuffer sb = new StringBuffer(100);
        if (catalog != null) {
            sb.append(catalog);
            sb.append('.');
        }
        if (schema != null) {
            sb.append(schema);
        }
        sb.append('.');
        sb.append(name);
        return sb.toString();
    }

    private NameTools() {
        throw new UnsupportedOperationException();
    }
}

